/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.collections.EqHashTable;
import one.microstream.storage.types.Database;

public interface Databases {
    public Database get(String var1);

    public Database ensureStoragelessDatabase(String var1);

    public static Databases get() {
        return Static.get();
    }

    public static Databases New() {
        return new Default((EqHashTable<String, Database>)EqHashTable.New());
    }

    public static final class Default
    implements Databases {
        private final EqHashTable<String, Database> databases;

        Default(EqHashTable<String, Database> databases) {
            this.databases = databases;
        }

        @Override
        public final synchronized Database get(String databaseName) {
            return (Database)this.databases.get((Object)databaseName);
        }

        @Override
        public final synchronized Database ensureStoragelessDatabase(String databaseName) {
            Database database = this.get(databaseName);
            if (database != null) {
                database.guaranteeNoActiveStorage();
            } else {
                database = Database.New(databaseName);
                this.databases.add((Object)databaseName, (Object)database);
            }
            return database;
        }
    }

    public static final class Static {
        private static final Databases SINGLETON = Databases.New();

        static Databases get() {
            return SINGLETON;
        }
    }
}

