/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.types.StorageBackupHandler;
import one.microstream.storage.types.StorageBackupItemEnqueuer;
import one.microstream.storage.types.StorageFileUser;
import one.microstream.storage.types.StorageLiveChannelFile;

public interface StorageBackupItemQueue
extends StorageBackupItemEnqueuer,
StorageFileUser {
    public boolean processNextItem(StorageBackupHandler var1, long var2) throws InterruptedException;

    public boolean isEmpty();

    public static StorageBackupItemQueue New() {
        return new Default();
    }

    public static final class Default
    implements StorageBackupItemQueue {
        private final Item head;
        private Item tail;

        Default() {
            this.tail = this.head = new Item(null, 0L, 0L);
        }

        @Override
        public final boolean isEmpty() {
            return this.head.next == null;
        }

        @Override
        public final void enqueueCopyingItem(StorageLiveChannelFile<?> sourceFile, long sourcePosition, long length) {
            this.internalEnqueueItem(sourceFile, sourcePosition, length);
        }

        @Override
        public final void enqueueTruncatingItem(StorageLiveChannelFile<?> file, long newLength) {
            this.internalEnqueueItem(file, newLength, -1L);
        }

        @Override
        public void enqueueDeletionItem(StorageLiveChannelFile<?> file) {
            this.internalEnqueueItem(file, 0L, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEnqueueItem(StorageLiveChannelFile<?> sourceFile, long sourcePosition, long length) {
            sourceFile.registerUsage(this);
            Item item = this.head;
            synchronized (item) {
                this.tail = this.tail.next = new Item(sourceFile, sourcePosition, length);
                this.head.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final boolean processNextItem(StorageBackupHandler handler, long timeoutMs) throws InterruptedException {
            long timeBudgetBound = System.currentTimeMillis() + timeoutMs;
            long waitInterval = timeoutMs / 16L;
            Item item = this.head;
            synchronized (item) {
                while (true) {
                    if (this.head.next != null) {
                        Item itemToBeProcessed = this.head.next;
                        itemToBeProcessed.processBy(handler);
                        itemToBeProcessed.sourceFile.unregisterUsageClosing(this, null);
                        this.head.next = itemToBeProcessed.next;
                        if (this.head.next == null) {
                            this.tail = this.head;
                        }
                        return true;
                    }
                    if (!handler.isRunning()) {
                        return true;
                    }
                    if (System.currentTimeMillis() >= timeBudgetBound) {
                        return false;
                    }
                    this.head.wait(waitInterval);
                }
            }
        }

        static final class Item {
            final StorageLiveChannelFile<?> sourceFile;
            final long sourcePosition;
            final long length;
            Item next;

            Item(StorageLiveChannelFile<?> sourceFile, long sourcePosition, long length) {
                this.sourceFile = sourceFile;
                this.sourcePosition = sourcePosition;
                this.length = length;
            }

            public void processBy(StorageBackupHandler handler) {
                if (this.length < 0L) {
                    if (this.sourcePosition == 0L) {
                        handler.deleteFile(this.sourceFile);
                    } else {
                        handler.truncateFile(this.sourceFile, this.sourcePosition);
                    }
                } else {
                    handler.copyFilePart(this.sourceFile, this.sourcePosition, this.length);
                }
            }
        }
    }
}

