/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AWritableFile;
import one.microstream.collections.BulkList;
import one.microstream.functional.ThrowingProcedure;
import one.microstream.functional._longProcedure;
import one.microstream.math.XMath;
import one.microstream.persistence.binary.types.Chunk;
import one.microstream.persistence.binary.types.ChunksBuffer;
import one.microstream.persistence.binary.types.ChunksBufferByteReversing;
import one.microstream.persistence.binary.types.MemoryRangeReader;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.persistence.types.Unpersistable;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageActivePart;
import one.microstream.storage.types.StorageChannelResetablePart;
import one.microstream.storage.types.StorageEntity;
import one.microstream.storage.types.StorageEntityCache;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityType;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageEventLogger;
import one.microstream.storage.types.StorageExceptionHandler;
import one.microstream.storage.types.StorageFileManager;
import one.microstream.storage.types.StorageHousekeepingBroker;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageHousekeepingExecutor;
import one.microstream.storage.types.StorageIdAnalysis;
import one.microstream.storage.types.StorageImportSourceFile;
import one.microstream.storage.types.StorageInventory;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRawFileStatistics;
import one.microstream.storage.types.StorageTask;
import one.microstream.storage.types.StorageTaskBroker;
import one.microstream.storage.types.StorageTypeDictionary;
import one.microstream.time.XTime;
import one.microstream.typing.KeyValue;
import one.microstream.util.BufferSizeProviderIncremental;

public interface StorageChannel
extends Runnable,
StorageChannelResetablePart,
StorageActivePart {
    public StorageTypeDictionary typeDictionary();

    public ChunksBuffer collectLoadByOids(ChunksBuffer[] var1, PersistenceIdSet var2);

    public ChunksBuffer collectLoadRoots(ChunksBuffer[] var1);

    public ChunksBuffer collectLoadByTids(ChunksBuffer[] var1, PersistenceIdSet var2);

    public KeyValue<ByteBuffer[], long[]> storeEntities(long var1, Chunk var3);

    public void rollbackChunkStorage();

    public void commitChunkStorage();

    public void postStoreUpdateEntityCache(ByteBuffer[] var1, long[] var2) throws InterruptedException;

    public StorageInventory readStorage();

    public boolean issuedGarbageCollection(long var1);

    public boolean issuedFileCleanupCheck(long var1);

    public boolean issuedEntityCacheCheck(long var1, StorageEntityCacheEvaluator var3);

    public void exportData(StorageLiveFileProvider var1);

    public StorageEntityCache.Default prepareImportData();

    public void importData(StorageImportSourceFile var1);

    public void rollbackImportData(Throwable var1);

    public void commitImportData(long var1);

    public KeyValue<Long, Long> exportTypeEntities(StorageEntityTypeHandler var1, AWritableFile var2) throws IOException;

    public KeyValue<Long, Long> exportTypeEntities(StorageEntityTypeHandler var1, AWritableFile var2, Predicate<? super StorageEntity> var3) throws IOException;

    public StorageRawFileStatistics.ChannelStatistics createRawFileStatistics();

    public StorageIdAnalysis initializeStorage(long var1, long var3, StorageInventory var5);

    public void signalGarbageCollectionSweepCompleted();

    public void cleanupStore();

    public static final class Default
    implements StorageChannel,
    Unpersistable,
    StorageHousekeepingExecutor {
        private final int channelIndex;
        private final StorageExceptionHandler exceptionHandler;
        private final StorageTaskBroker taskBroker;
        private final StorageOperationController operationController;
        private final StorageHousekeepingController housekeepingController;
        private final StorageHousekeepingBroker housekeepingBroker;
        private final StorageFileManager.Default fileManager;
        private final StorageEntityCache.Default entityCache;
        private final boolean switchByteOrder;
        private final BufferSizeProviderIncremental loadingBufferSizeProvider;
        private final StorageEventLogger eventLogger;
        private final HousekeepingTask[] housekeepingTasks;
        private int nextHouseKeepingIndex;
        private long housekeepingIntervalBoundTimeNs;
        private long housekeepingIntervalBudgetNs;
        private boolean active;

        public Default(int hashIndex, StorageExceptionHandler exceptionHandler, StorageTaskBroker taskBroker, StorageOperationController operationController, StorageHousekeepingBroker housekeepingBroker, StorageHousekeepingController housekeepingController, StorageEntityCache.Default entityCache, boolean switchByteOrder, BufferSizeProviderIncremental loadingBufferSizeProvider, StorageFileManager.Default fileManager, StorageEventLogger eventLogger) {
            this.channelIndex = XMath.notNegative((int)hashIndex);
            this.exceptionHandler = (StorageExceptionHandler)X.notNull((Object)exceptionHandler);
            this.taskBroker = (StorageTaskBroker)X.notNull((Object)taskBroker);
            this.operationController = (StorageOperationController)X.notNull((Object)operationController);
            this.housekeepingBroker = (StorageHousekeepingBroker)X.notNull((Object)housekeepingBroker);
            this.fileManager = (StorageFileManager.Default)X.notNull((Object)fileManager);
            this.entityCache = (StorageEntityCache.Default)X.notNull((Object)entityCache);
            this.housekeepingController = (StorageHousekeepingController)X.notNull((Object)housekeepingController);
            this.loadingBufferSizeProvider = (BufferSizeProviderIncremental)X.notNull((Object)loadingBufferSizeProvider);
            this.eventLogger = (StorageEventLogger)X.notNull((Object)eventLogger);
            this.switchByteOrder = switchByteOrder;
            this.housekeepingTasks = this.defineHouseKeepingTasks();
        }

        private HousekeepingTask[] defineHouseKeepingTasks() {
            BulkList tasks = BulkList.New();
            tasks.add(this::houseKeepingCheckFileCleanup);
            tasks.add(this::houseKeepingGarbageCollection);
            tasks.add(this::houseKeepingEntityCacheCheck);
            return (HousekeepingTask[])tasks.toArray(HousekeepingTask.class);
        }

        private int getCurrentHouseKeepingIndexAndAdvance() {
            if (this.nextHouseKeepingIndex >= this.housekeepingTasks.length) {
                this.nextHouseKeepingIndex = 1;
                return 0;
            }
            return this.nextHouseKeepingIndex++;
        }

        private void houseKeeping() {
            long currentNanotime = System.nanoTime();
            if (currentNanotime >= this.housekeepingIntervalBoundTimeNs) {
                this.housekeepingIntervalBoundTimeNs = currentNanotime + Storage.millisecondsToNanoseconds(this.housekeepingController.housekeepingIntervalMs());
                this.housekeepingIntervalBudgetNs = this.housekeepingController.housekeepingTimeBudgetNs();
            } else {
                if (this.housekeepingIntervalBudgetNs <= 0L) {
                    return;
                }
                if (this.housekeepingIntervalBoundTimeNs - currentNanotime < this.housekeepingIntervalBudgetNs) {
                    this.housekeepingIntervalBudgetNs = this.housekeepingIntervalBoundTimeNs - currentNanotime;
                }
            }
            long budgetOffset = currentNanotime + this.housekeepingIntervalBudgetNs;
            int c = 0;
            while (c < this.housekeepingTasks.length) {
                this.housekeepingTasks[this.getCurrentHouseKeepingIndexAndAdvance()].perform();
                this.housekeepingIntervalBudgetNs = budgetOffset - System.nanoTime();
                if (this.housekeepingIntervalBudgetNs <= 0L) break;
                ++c;
            }
        }

        @Override
        public boolean performIssuedGarbageCollection(long nanoTimeBudget) {
            long nanoTimeBudgetBound = XTime.calculateNanoTimeBudgetBound((long)nanoTimeBudget);
            return this.entityCache.issuedGarbageCollection(nanoTimeBudgetBound, this);
        }

        @Override
        public boolean performIssuedFileCleanupCheck(long nanoTimeBudget) {
            if (!this.fileManager.isFileCleanupEnabled()) {
                return true;
            }
            long nanoTimeBudgetBound = XTime.calculateNanoTimeBudgetBound((long)nanoTimeBudget);
            return this.fileManager.issuedFileCleanupCheck(nanoTimeBudgetBound);
        }

        @Override
        public boolean performIssuedEntityCacheCheck(long nanoTimeBudget, StorageEntityCacheEvaluator evaluator) {
            long nanoTimeBudgetBound = XTime.calculateNanoTimeBudgetBound((long)nanoTimeBudget);
            return this.entityCache.issuedEntityCacheCheck(nanoTimeBudgetBound, evaluator);
        }

        @Override
        public final boolean performFileCleanupCheck(long nanoTimeBudget) {
            if (!this.fileManager.isFileCleanupEnabled()) {
                return true;
            }
            long nanoTimeBudgetBound = XTime.calculateNanoTimeBudgetBound((long)nanoTimeBudget);
            return this.fileManager.incrementalFileCleanupCheck(nanoTimeBudgetBound);
        }

        @Override
        public boolean performGarbageCollection(long nanoTimeBudget) {
            long nanoTimeBudgetBound = XTime.calculateNanoTimeBudgetBound((long)nanoTimeBudget);
            return this.entityCache.incrementalGarbageCollection(nanoTimeBudgetBound, this);
        }

        @Override
        public boolean performEntityCacheCheck(long nanoTimeBudget) {
            long nanoTimeBudgetBound = XTime.calculateNanoTimeBudgetBound((long)nanoTimeBudget);
            return this.entityCache.incrementalEntityCacheCheck(nanoTimeBudgetBound);
        }

        @Override
        public final boolean issuedGarbageCollection(long nanoTimeBudget) {
            return this.housekeepingBroker.performIssuedGarbageCollection(this, nanoTimeBudget);
        }

        @Override
        public boolean issuedFileCleanupCheck(long nanoTimeBudget) {
            return this.housekeepingBroker.performIssuedFileCleanupCheck(this, nanoTimeBudget);
        }

        @Override
        public boolean issuedEntityCacheCheck(long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator) {
            return this.housekeepingBroker.performIssuedEntityCacheCheck(this, nanoTimeBudget, entityEvaluator);
        }

        private long calculateSpecificHousekeepingTimeBudget(long nanoTimeBudget) {
            return Math.min(nanoTimeBudget, this.housekeepingIntervalBudgetNs);
        }

        final boolean houseKeepingCheckFileCleanup() {
            if (!this.fileManager.isFileCleanupEnabled()) {
                return true;
            }
            long nanoTimeBudget = this.calculateSpecificHousekeepingTimeBudget(this.housekeepingController.fileCheckTimeBudgetNs());
            return this.housekeepingBroker.performFileCleanupCheck(this, nanoTimeBudget);
        }

        final boolean houseKeepingGarbageCollection() {
            long nanoTimeBudget = this.calculateSpecificHousekeepingTimeBudget(this.housekeepingController.garbageCollectionTimeBudgetNs());
            return this.housekeepingBroker.performGarbageCollection(this, nanoTimeBudget);
        }

        final boolean houseKeepingEntityCacheCheck() {
            long nanoTimeBudget = this.calculateSpecificHousekeepingTimeBudget(this.housekeepingController.liveCheckTimeBudgetNs());
            return this.housekeepingBroker.performEntityCacheCheck(this, nanoTimeBudget);
        }

        private void work() throws InterruptedException {
            StorageOperationController operationController = this.operationController;
            StorageHousekeepingController housekeepingController = this.housekeepingController;
            StorageTask processedTask = new StorageTask.DummyTask();
            StorageTask currentTask = (StorageTask)X.notNull((Object)this.taskBroker.currentTask());
            while (true) {
                if (currentTask != processedTask) {
                    currentTask.processBy(this);
                    processedTask = currentTask;
                }
                if (!operationController.checkProcessingEnabled()) {
                    this.eventLogger.logChannelProcessingDisabled(this);
                    break;
                }
                try {
                    this.houseKeeping();
                }
                catch (Throwable t) {
                    this.eventLogger.logDisruption(this, t);
                    this.operationController.setChannelProcessingEnabled(false);
                    this.eventLogger.logChannelProcessingDisabled(this);
                    break;
                }
                currentTask = processedTask.awaitNext(housekeepingController.housekeepingIntervalMs());
                if (currentTask != null) continue;
                currentTask = processedTask;
            }
            this.eventLogger.logChannelStoppedWorking(this);
        }

        @Override
        public synchronized boolean isActive() {
            return this.active;
        }

        private synchronized void activate() {
            this.active = true;
        }

        private synchronized void deactivate() {
            this.active = false;
        }

        @Override
        public final void run() {
            this.activate();
            Throwable workingDisruption = null;
            try {
                try {
                    this.work();
                }
                catch (Throwable t) {
                    workingDisruption = t;
                    this.eventLogger.logDisruption(this, t);
                    this.exceptionHandler.handleException(t, this);
                    try {
                        try {
                            this.reset();
                        }
                        catch (Throwable t1) {
                            if (workingDisruption != null) {
                                t1.addSuppressed(workingDisruption);
                            }
                            this.deactivate();
                        }
                    }
                    finally {
                        this.deactivate();
                    }
                }
            }
            finally {
                block22: {
                    try {
                        try {
                            this.reset();
                        }
                        catch (Throwable t1) {
                            if (workingDisruption != null) {
                                t1.addSuppressed(workingDisruption);
                            }
                            this.deactivate();
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        this.deactivate();
                        throw throwable;
                    }
                    this.deactivate();
                }
            }
        }

        @Override
        public void commitChunkStorage() {
            this.fileManager.commitWrite();
        }

        @Override
        public KeyValue<ByteBuffer[], long[]> storeEntities(long timestamp, Chunk chunkData) {
            this.entityCache.registerPendingStoreUpdate();
            ByteBuffer[] buffers = chunkData.buffers();
            return X.KeyValue((Object)buffers, (Object)this.fileManager.storeChunks(timestamp, buffers));
        }

        @Override
        public void postStoreUpdateEntityCache(ByteBuffer[] chunks, long[] chunksStoragePositions) throws InterruptedException {
            this.entityCache.postStorePutEntities(chunks, chunksStoragePositions, this.fileManager.currentStorageFile());
        }

        @Override
        public final int channelIndex() {
            return this.channelIndex;
        }

        @Override
        public final StorageTypeDictionary typeDictionary() {
            return this.entityCache.typeDictionary();
        }

        private ChunksBuffer createLoadingChunksBuffer(ChunksBuffer[] channelChunks) {
            return this.switchByteOrder ? ChunksBufferByteReversing.New((ChunksBuffer[])channelChunks, (BufferSizeProviderIncremental)this.loadingBufferSizeProvider) : ChunksBuffer.New((ChunksBuffer[])channelChunks, (BufferSizeProviderIncremental)this.loadingBufferSizeProvider);
        }

        @Override
        public final ChunksBuffer collectLoadByOids(ChunksBuffer[] resultArray, PersistenceIdSet loadOids) {
            ChunksBuffer chunks = this.createLoadingChunksBuffer(resultArray);
            if (!loadOids.isEmpty()) {
                loadOids.iterate((_longProcedure)new EntityCollectorByOid(this.entityCache, chunks));
            }
            return chunks.complete();
        }

        @Override
        public final ChunksBuffer collectLoadRoots(ChunksBuffer[] resultArray) {
            ChunksBuffer chunks = this.createLoadingChunksBuffer(resultArray);
            this.entityCache.copyRoots(chunks);
            return chunks.complete();
        }

        @Override
        public final ChunksBuffer collectLoadByTids(ChunksBuffer[] resultArray, PersistenceIdSet loadTids) {
            ChunksBuffer chunks = this.createLoadingChunksBuffer(resultArray);
            if (!loadTids.isEmpty()) {
                loadTids.iterate((_longProcedure)new EntityCollectorByTid(this.entityCache, chunks));
            }
            return chunks.complete();
        }

        @Override
        public final void exportData(StorageLiveFileProvider fileProvider) {
            this.fileManager.exportData(fileProvider);
        }

        @Override
        public StorageEntityCache.Default prepareImportData() {
            this.fileManager.prepareImport();
            return this.entityCache;
        }

        @Override
        public void importData(StorageImportSourceFile importFile) {
            this.fileManager.copyData(importFile);
        }

        @Override
        public void rollbackImportData(Throwable cause) {
            this.fileManager.rollbackImport();
        }

        @Override
        public void commitImportData(long taskTimestamp) {
            this.fileManager.commitImport(taskTimestamp);
        }

        @Override
        public final KeyValue<Long, Long> exportTypeEntities(StorageEntityTypeHandler type, final AWritableFile file, final Predicate<? super StorageEntity> predicateEntity) throws IOException {
            StorageEntityType.Default entities = this.entityCache.getType(type.typeId());
            if (entities == null || entities.entityCount() == 0L) {
                return X.KeyValue((Object)0L, (Object)0L);
            }
            long byteCount = entities.iterateEntities(new ThrowingProcedure<StorageEntity.Default, IOException>(){
                long byteCount;

                public void accept(StorageEntity.Default e) throws IOException {
                    if (!predicateEntity.test(e)) {
                        return;
                    }
                    this.byteCount += e.exportTo(file);
                }
            }).byteCount;
            return X.KeyValue((Object)byteCount, (Object)entities.entityCount());
        }

        @Override
        public final KeyValue<Long, Long> exportTypeEntities(StorageEntityTypeHandler type, final AWritableFile file) throws IOException {
            StorageEntityType.Default entities = this.entityCache.getType(type.typeId());
            if (entities == null || entities.entityCount() == 0L) {
                return X.KeyValue((Object)0L, (Object)0L);
            }
            long byteCount = entities.iterateEntities(new ThrowingProcedure<StorageEntity.Default, IOException>(){
                long byteCount;

                public void accept(StorageEntity.Default e) throws IOException {
                    this.byteCount += e.exportTo(file);
                }
            }).byteCount;
            return X.KeyValue((Object)byteCount, (Object)entities.entityCount());
        }

        @Override
        public final StorageRawFileStatistics.ChannelStatistics createRawFileStatistics() {
            return this.fileManager.createRawFileStatistics();
        }

        @Override
        public final void rollbackChunkStorage() {
            this.fileManager.rollbackWrite();
        }

        @Override
        public final StorageInventory readStorage() {
            return this.fileManager.readStorage();
        }

        @Override
        public final StorageIdAnalysis initializeStorage(long taskTimestamp, long consistentStoreTimestamp, StorageInventory storageInventory) {
            return this.fileManager.initializeStorage(taskTimestamp, consistentStoreTimestamp, storageInventory, this);
        }

        @Override
        public final void reset() {
            this.entityCache.reset();
            this.fileManager.reset();
        }

        @Override
        public final void signalGarbageCollectionSweepCompleted() {
            this.fileManager.restartFileCleanupCursor();
        }

        @Override
        public void cleanupStore() {
            this.entityCache.clearPendingStoreUpdate();
        }
    }

    public static final class EntityCollectorByOid
    implements _longProcedure {
        private final StorageEntityCache.Default entityCache;
        private final ChunksBuffer dataCollector;

        public EntityCollectorByOid(StorageEntityCache.Default entityCache, ChunksBuffer dataCollector) {
            this.entityCache = entityCache;
            this.dataCollector = dataCollector;
        }

        public final void accept(long objectId) {
            StorageEntity.Default entry = this.entityCache.getEntry(objectId);
            if (entry == null) {
                throw new StorageExceptionConsistency("No entity found for objectId " + objectId);
            }
            entry.copyCachedData((MemoryRangeReader)this.dataCollector);
        }
    }

    public static final class EntityCollectorByTid
    implements _longProcedure {
        private final StorageEntityCache.Default entityCache;
        private final ChunksBuffer dataCollector;

        public EntityCollectorByTid(StorageEntityCache.Default entityCache, ChunksBuffer dataCollector) {
            this.entityCache = entityCache;
            this.dataCollector = dataCollector;
        }

        public final void accept(long tid) {
            StorageEntityType.Default type = this.entityCache.getType(tid);
            if (type == null) {
                return;
            }
            StorageEntity.Default entity = type.head;
            while ((entity = entity.typeNext) != null) {
                entity.copyCachedData((MemoryRangeReader)this.dataCollector);
            }
        }
    }

    @FunctionalInterface
    public static interface HousekeepingTask {
        public boolean perform();
    }
}

