/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.memory.XMemory;
import one.microstream.storage.types.StorageBackupHandler;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCache;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityMarkMonitor;
import one.microstream.storage.types.StorageEventLogger;
import one.microstream.storage.types.StorageExceptionHandler;
import one.microstream.storage.types.StorageFileManager;
import one.microstream.storage.types.StorageFileWriter;
import one.microstream.storage.types.StorageGCZombieOidHandler;
import one.microstream.storage.types.StorageHousekeepingBroker;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageInitialDataFileNumberProvider;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageObjectIdMarkQueue;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRootOidSelector;
import one.microstream.storage.types.StorageTaskBroker;
import one.microstream.storage.types.StorageTimestampProvider;
import one.microstream.storage.types.StorageTypeDictionary;
import one.microstream.storage.types.StorageWriteController;
import one.microstream.util.BufferSizeProvider;
import one.microstream.util.BufferSizeProviderIncremental;

public interface StorageChannelsCreator {
    public StorageChannel[] createChannels(int var1, StorageInitialDataFileNumberProvider var2, StorageExceptionHandler var3, StorageDataFileEvaluator var4, StorageLiveFileProvider var5, StorageEntityCacheEvaluator var6, StorageTypeDictionary var7, StorageTaskBroker var8, StorageOperationController var9, StorageHousekeepingBroker var10, StorageHousekeepingController var11, StorageTimestampProvider var12, StorageWriteController var13, StorageFileWriter.Provider var14, StorageGCZombieOidHandler var15, StorageRootOidSelector.Provider var16, StorageObjectIdMarkQueue.Creator var17, StorageEntityMarkMonitor.Creator var18, StorageBackupHandler var19, StorageEventLogger var20, boolean var21, long var22);

    public static final class Default
    implements StorageChannelsCreator {
        public final StorageChannel.Default[] createChannels(int channelCount, StorageInitialDataFileNumberProvider initialDataFileNumberProvider, StorageExceptionHandler exceptionHandler, StorageDataFileEvaluator dataFileEvaluator, StorageLiveFileProvider liveFileProvider, StorageEntityCacheEvaluator entityCacheEvaluator, StorageTypeDictionary typeDictionary, StorageTaskBroker taskBroker, StorageOperationController operationController, StorageHousekeepingBroker housekeepingBroker, StorageHousekeepingController housekeepingController, StorageTimestampProvider timestampProvider, StorageWriteController writeController, StorageFileWriter.Provider writerProvider, StorageGCZombieOidHandler zombieOidHandler, StorageRootOidSelector.Provider rootOidSelectorProvider, StorageObjectIdMarkQueue.Creator oidMarkQueueCreator, StorageEntityMarkMonitor.Creator entityMarkMonitorCreator, StorageBackupHandler backupHandler, StorageEventLogger eventLogger, boolean switchByteOrder, long rootTypeId) {
            int markBufferLength = 10000;
            long markingWaitTimeMs = 10L;
            int loadingBufferSize = XMemory.defaultBufferSize();
            int readingDefaultBufferSize = XMemory.defaultBufferSize();
            StorageChannel.Default[] channels = new StorageChannel.Default[channelCount];
            StorageObjectIdMarkQueue[] markQueues = new StorageObjectIdMarkQueue[channels.length];
            int i = 0;
            while (i < markQueues.length) {
                markQueues[i] = oidMarkQueueCreator.createOidMarkQueue(10000);
                ++i;
            }
            StorageEntityMarkMonitor markMonitor = entityMarkMonitorCreator.createEntityMarkMonitor(markQueues, eventLogger);
            BufferSizeProviderIncremental loadingBufferSizeProvider = BufferSizeProviderIncremental.New((long)loadingBufferSize);
            BufferSizeProvider readingDefaultBufferSizeProvider = BufferSizeProvider.New((long)readingDefaultBufferSize);
            int i2 = 0;
            while (i2 < channels.length) {
                StorageEntityCache.Default entityCache = new StorageEntityCache.Default(i2, channels.length, entityCacheEvaluator, typeDictionary, markMonitor, zombieOidHandler, rootOidSelectorProvider.provideRootOidSelector(i2), rootTypeId, markQueues[i2], eventLogger, 10L, 10000);
                StorageFileManager.Default fileManager = new StorageFileManager.Default(i2, initialDataFileNumberProvider, timestampProvider, liveFileProvider, dataFileEvaluator, entityCache, writeController, writerProvider.provideWriter(i2), readingDefaultBufferSizeProvider, backupHandler);
                entityCache.initializeStorageManager(fileManager);
                channels[i2] = new StorageChannel.Default(i2, exceptionHandler, taskBroker, operationController, housekeepingBroker, housekeepingController, entityCache, switchByteOrder, loadingBufferSizeProvider, fileManager, eventLogger);
                ++i2;
            }
            return channels;
        }
    }
}

