/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.meta.XDebug;
import one.microstream.persistence.binary.types.BinaryEntityRawDataIterator;
import one.microstream.storage.exceptions.StorageExceptionIncompleteValidation;
import one.microstream.storage.types.StorageDataFile;
import one.microstream.storage.types.StorageEntityDataValidator;
import one.microstream.storage.types.StorageFileEntityDataIterator;
import one.microstream.storage.types.StorageTypeDictionary;

public interface StorageDataFileValidator {
    public void validateFile(StorageDataFile var1, long var2, long var4);

    default public void validateFile(StorageDataFile file) {
        this.validateFile(file, 0L, file.size());
    }

    default public void freeMemory() {
    }

    public static StorageDataFileValidator New(BinaryEntityRawDataIterator entityDataIterator, StorageEntityDataValidator entityDataValidator, StorageFileEntityDataIterator fileIterator) {
        return new Default((BinaryEntityRawDataIterator)X.notNull((Object)entityDataIterator), (StorageEntityDataValidator)X.notNull((Object)entityDataValidator), (StorageFileEntityDataIterator)X.notNull((Object)fileIterator));
    }

    @Deprecated
    public static StorageDataFileValidator DebugLogging(BinaryEntityRawDataIterator entityDataIterator, StorageEntityDataValidator entityDataValidator, StorageFileEntityDataIterator fileIterator) {
        return new Default((BinaryEntityRawDataIterator)X.notNull((Object)entityDataIterator), (StorageEntityDataValidator)X.notNull((Object)entityDataValidator), (StorageFileEntityDataIterator)X.notNull((Object)fileIterator)){

            @Override
            public void validateFile(StorageDataFile file, long fileOffset, long iterationLength) {
                XDebug.println((String)("Validating file " + file.identifier() + "[" + fileOffset + ";" + (fileOffset + iterationLength) + "["));
                super.validateFile(file, fileOffset, iterationLength);
            }
        };
    }

    public static Creator Creator(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator) {
        return new Creator.Default(entityDataIteratorProvider, entityDataValidatorCreator);
    }

    @Deprecated
    public static Creator CreatorDebugLogging(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator) {
        return new Creator.DebugLogging(entityDataIteratorProvider, entityDataValidatorCreator);
    }

    public static interface Creator {
        public StorageDataFileValidator createDataFileValidator(StorageTypeDictionary var1);

        @Deprecated
        public static final class DebugLogging
        extends Default {
            DebugLogging(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator) {
                super(entityDataIteratorProvider, entityDataValidatorCreator);
            }

            @Override
            public StorageDataFileValidator createDataFileValidator(StorageTypeDictionary typeDictionary) {
                return new Debugging(super.createDataFileValidator(typeDictionary));
            }
        }

        public static class Default
        implements Creator {
            private final BinaryEntityRawDataIterator.Provider entityDataIteratorProvider;
            private final StorageEntityDataValidator.Creator entityDataValidatorCreator;

            Default(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator) {
                this.entityDataIteratorProvider = entityDataIteratorProvider;
                this.entityDataValidatorCreator = entityDataValidatorCreator;
            }

            @Override
            public StorageDataFileValidator createDataFileValidator(StorageTypeDictionary typeDictionary) {
                return StorageDataFileValidator.New(this.entityDataIteratorProvider.provideEntityDataIterator(), this.entityDataValidatorCreator.createDataFileValidator(typeDictionary), StorageFileEntityDataIterator.New());
            }
        }
    }

    public static class Debugging
    implements StorageDataFileValidator {
        private final StorageDataFileValidator delegate;

        Debugging(StorageDataFileValidator delegate) {
            this.delegate = delegate;
        }

        @Override
        public void validateFile(StorageDataFile file, long fileOffset, long iterationLength) {
            XDebug.println((String)("Validating file " + file.identifier() + "[" + fileOffset + ";" + (fileOffset + iterationLength) + "["));
            this.delegate.validateFile(file, fileOffset, iterationLength);
        }
    }

    public static class Default
    implements StorageDataFileValidator {
        private final BinaryEntityRawDataIterator entityDataIterator;
        private final StorageEntityDataValidator entityDataValidator;
        private final StorageFileEntityDataIterator fileIterator;

        protected Default(BinaryEntityRawDataIterator entityDataIterator, StorageEntityDataValidator entityDataValidator, StorageFileEntityDataIterator fileIterator) {
            this.entityDataIterator = (BinaryEntityRawDataIterator)X.notNull((Object)entityDataIterator);
            this.entityDataValidator = (StorageEntityDataValidator)X.notNull((Object)entityDataValidator);
            this.fileIterator = (StorageFileEntityDataIterator)X.notNull((Object)fileIterator);
        }

        @Override
        public void freeMemory() {
            this.fileIterator.removeBuffer();
        }

        @Override
        public void validateFile(StorageDataFile file, long fileOffset, long iterationLength) {
            long remainingLength = this.fileIterator.iterateEntityData(file, fileOffset, iterationLength, this.entityDataIterator, this.entityDataValidator);
            if (remainingLength != 0L) {
                throw new StorageExceptionIncompleteValidation(String.valueOf(remainingLength) + " remaining bytes of " + iterationLength + " total cannot be validated" + " in file " + file.identifier() + " at offset " + fileOffset);
            }
        }
    }
}

