/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.BinaryEntityRawDataAcceptor;
import one.microstream.persistence.binary.types.BinaryEntityRawDataIterator;
import one.microstream.storage.exceptions.StorageExceptionIoReading;
import one.microstream.storage.types.StorageDataFile;

public interface StorageFileEntityDataIterator {
    public long iterateEntityData(StorageDataFile var1, long var2, long var4, BinaryEntityRawDataIterator var6, BinaryEntityRawDataAcceptor var7);

    public long bufferCapacity();

    public StorageFileEntityDataIterator ensureBufferCapacity(long var1);

    public void removeBuffer();

    public static StorageFileEntityDataIterator New() {
        return new Default();
    }

    public static final class Default
    implements Internal {
        private ByteBuffer directByteBuffer;

        Default() {
        }

        @Override
        public final long bufferCapacity() {
            return this.directByteBuffer != null ? (long)this.directByteBuffer.capacity() : -1L;
        }

        @Override
        public StorageFileEntityDataIterator ensureBufferCapacity(long requiredBufferCapacity) {
            if (this.bufferCapacity() < requiredBufferCapacity) {
                XMemory.deallocateDirectByteBuffer((ByteBuffer)this.directByteBuffer);
                this.directByteBuffer = XMemory.allocateDirectNative((long)requiredBufferCapacity);
            }
            return this;
        }

        @Override
        public void removeBuffer() {
            this.directByteBuffer = null;
        }

        @Override
        public void fillBuffer(Internal self, StorageDataFile file, long fileOffset, long iterationLength) {
            try {
                try {
                    this.prepareFile(self, file, fileOffset, iterationLength);
                    self.validateIterationRange(self, file, file.size(), fileOffset, iterationLength);
                    self.ensureBufferCapacity(iterationLength);
                    ByteBuffer buffer = this.directByteBuffer;
                    buffer.clear();
                    buffer.limit(X.checkArrayRange((long)iterationLength));
                    file.readBytes(buffer, fileOffset);
                }
                catch (Exception e) {
                    throw new StorageExceptionIoReading(e);
                }
            }
            finally {
                self.wrapUpFile(self, file, fileOffset, iterationLength);
            }
        }

        @Override
        public void validateIterationRange(Internal self, StorageDataFile file, long actualFileLength, long fileOffset, long iterationLength) {
            if (fileOffset < 0L || fileOffset > actualFileLength) {
                throw new StorageExceptionIoReading("Invalid file offset " + fileOffset + " specified for " + actualFileLength + " bytes long file \"" + file.identifier() + "\".");
            }
            if (iterationLength < 0L) {
                throw new StorageExceptionIoReading("Invalid negative iteration length " + iterationLength + " specified for file \"" + file.identifier() + "\".");
            }
            if (fileOffset + iterationLength > actualFileLength) {
                throw new StorageExceptionIoReading("Invalid iteration range [" + fileOffset + "; " + (fileOffset + iterationLength) + "]" + " specified for " + actualFileLength + " bytes long file \"" + file.identifier() + "\".");
            }
        }

        @Override
        public long iterateFilledBuffer(Internal self, BinaryEntityRawDataIterator dataIterator, BinaryEntityRawDataAcceptor dataAcceptor) {
            long bufferStartAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)this.directByteBuffer);
            long bufferBoundAddress = bufferStartAddress + (long)this.directByteBuffer.position();
            return dataIterator.iterateEntityRawData(bufferStartAddress, bufferBoundAddress, dataAcceptor);
        }
    }

    public static interface Internal
    extends StorageFileEntityDataIterator {
        @Override
        default public long iterateEntityData(StorageDataFile file, long fileOffset, long iterationLength, BinaryEntityRawDataIterator dataIterator, BinaryEntityRawDataAcceptor dataAcceptor) {
            this.fillBuffer(this, file, fileOffset, iterationLength);
            return this.iterateFilledBuffer(this, dataIterator, dataAcceptor);
        }

        default public void prepareFile(Internal self, StorageDataFile file, long fileOffset, long iterationLength) {
        }

        default public void wrapUpFile(Internal self, StorageDataFile file, long fileOffset, long iterationLength) {
        }

        public void fillBuffer(Internal var1, StorageDataFile var2, long var3, long var5);

        public long iterateFilledBuffer(Internal var1, BinaryEntityRawDataIterator var2, BinaryEntityRawDataAcceptor var3);

        public void validateIterationRange(Internal var1, StorageDataFile var2, long var3, long var5, long var7);
    }
}

