/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.VarString;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.XSort;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.exceptions.MultiCauseException;
import one.microstream.math.XMath;
import one.microstream.memory.XMemory;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.exceptions.StorageExceptionIoReading;
import one.microstream.storage.exceptions.StorageExceptionIoWriting;
import one.microstream.storage.exceptions.StorageExceptionIoWritingChunk;
import one.microstream.storage.types.StorageBackupHandler;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelImportBatch;
import one.microstream.storage.types.StorageChannelImportEntity;
import one.microstream.storage.types.StorageChannelResetablePart;
import one.microstream.storage.types.StorageClosableFile;
import one.microstream.storage.types.StorageDataFileDissolvingEvaluator;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageDataInventoryFile;
import one.microstream.storage.types.StorageEntity;
import one.microstream.storage.types.StorageEntityCache;
import one.microstream.storage.types.StorageEntityInitializer;
import one.microstream.storage.types.StorageFile;
import one.microstream.storage.types.StorageFileUser;
import one.microstream.storage.types.StorageFileWriter;
import one.microstream.storage.types.StorageIdAnalysis;
import one.microstream.storage.types.StorageImportSourceFile;
import one.microstream.storage.types.StorageInitialDataFileNumberProvider;
import one.microstream.storage.types.StorageInventory;
import one.microstream.storage.types.StorageLiveDataFile;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageLiveTransactionsFile;
import one.microstream.storage.types.StorageRawFileStatistics;
import one.microstream.storage.types.StorageTimestampProvider;
import one.microstream.storage.types.StorageTransactionEntry;
import one.microstream.storage.types.StorageTransactionsAnalysis;
import one.microstream.storage.types.StorageWriteController;
import one.microstream.typing.XTypes;
import one.microstream.util.BufferSizeProvider;

public interface StorageFileManager
extends StorageChannelResetablePart {
    @Override
    public int channelIndex();

    @Override
    public void reset();

    public long[] storeChunks(long var1, ByteBuffer[] var3) throws StorageExceptionIoWritingChunk;

    public void rollbackWrite();

    public void commitWrite();

    public StorageInventory readStorage();

    public StorageIdAnalysis initializeStorage(long var1, long var3, StorageInventory var5, StorageChannel var6);

    public StorageLiveDataFile currentStorageFile();

    public void iterateStorageFiles(Consumer<? super StorageLiveDataFile> var1);

    public boolean incrementalFileCleanupCheck(long var1);

    public boolean issuedFileCleanupCheck(long var1);

    public void exportData(StorageLiveFileProvider var1);

    public StorageRawFileStatistics.ChannelStatistics createRawFileStatistics();

    public void restartFileCleanupCursor();

    public static final class Default
    implements StorageFileManager,
    StorageFileUser {
        static final int MAX_FILE_LENGTH = Integer.MAX_VALUE;
        private static final boolean DEBUG_ENABLE_FILE_CLEANUP = true;
        private final int channelIndex;
        private final StorageInitialDataFileNumberProvider initialDataFileNumberProvider;
        private final StorageTimestampProvider timestampProvider;
        private final StorageLiveFileProvider fileProvider;
        private final StorageDataFileEvaluator dataFileEvaluator;
        private final StorageEntityCache.Default entityCache;
        private final StorageWriteController writeController;
        private final StorageFileWriter writer;
        private final StorageBackupHandler backupHandler;
        private final Consumer<? super StorageLiveDataFile.Default> deleter = this::deleteFile;
        private final Consumer<? super StorageLiveDataFile.Default> pendingDeleter = this::deletePendingFile;
        private final ByteBuffer entryBufferFileCreation = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthFileCreation());
        private final ByteBuffer entryBufferStore = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthStore());
        private final ByteBuffer entryBufferTransfer = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthTransfer());
        private final ByteBuffer entryBufferFileDeletion = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthFileCreation());
        private final ByteBuffer entryBufferFileTruncation = XMemory.allocateDirectNative((int)StorageTransactionsAnalysis.Logic.entryLengthFileTruncation());
        private final Iterable<? extends ByteBuffer> entryBufferWrapFileCreation = X.ArrayView((Object[])new ByteBuffer[]{this.entryBufferFileCreation});
        private final Iterable<? extends ByteBuffer> entryBufferWrapStore = X.ArrayView((Object[])new ByteBuffer[]{this.entryBufferStore});
        private final Iterable<? extends ByteBuffer> entryBufferWrapTransfer = X.ArrayView((Object[])new ByteBuffer[]{this.entryBufferTransfer});
        private final Iterable<? extends ByteBuffer> entryBufferWrapFileDeletion = X.ArrayView((Object[])new ByteBuffer[]{this.entryBufferFileDeletion});
        private final Iterable<? extends ByteBuffer> entryBufferWrapFileTruncation = X.ArrayView((Object[])new ByteBuffer[]{this.entryBufferFileTruncation});
        private final long entryBufferFileCreationAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)this.entryBufferFileCreation);
        private final long entryBufferStoreAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)this.entryBufferStore);
        private final long entryBufferTransferAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)this.entryBufferTransfer);
        private final long entryBufferFileDeletionAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)this.entryBufferFileDeletion);
        private final long entryBufferFileTruncationAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)this.entryBufferFileTruncation);
        private final ByteBuffer standardByteBuffer;
        private StorageLiveTransactionsFile fileTransactions;
        private StorageLiveDataFile.Default fileCleanupCursor;
        private long uncommittedDataLength;
        private int pendingFileDeletes;
        private StorageLiveDataFile.Default headFile;
        ImportHelper importHelper;

        private static long[] allChunksStoragePositions(ByteBuffer[] chunks, long basePosition) {
            long[] storagePositions = new long[chunks.length];
            long position = basePosition;
            int i = 0;
            while (i < chunks.length) {
                storagePositions[i] = position;
                position += (long)chunks[i].limit();
                ++i;
            }
            return storagePositions;
        }

        public Default(int channelIndex, StorageInitialDataFileNumberProvider initialDataFileNumberProvider, StorageTimestampProvider timestampProvider, StorageLiveFileProvider fileProvider, StorageDataFileEvaluator dataFileEvaluator, StorageEntityCache.Default entityCache, StorageWriteController writeController, StorageFileWriter writer, BufferSizeProvider standardBufferSizeProvider, StorageBackupHandler backupHandler) {
            StorageTransactionsAnalysis.Logic.initializeEntryFileCreation(this.entryBufferFileCreationAddress);
            StorageTransactionsAnalysis.Logic.initializeEntryStore(this.entryBufferStoreAddress);
            StorageTransactionsAnalysis.Logic.initializeEntryTransfer(this.entryBufferTransferAddress);
            StorageTransactionsAnalysis.Logic.initializeEntryFileDeletion(this.entryBufferFileDeletionAddress);
            StorageTransactionsAnalysis.Logic.initializeEntryFileTruncation(this.entryBufferFileTruncationAddress);
            this.channelIndex = XMath.notNegative((int)channelIndex);
            this.initialDataFileNumberProvider = (StorageInitialDataFileNumberProvider)X.notNull((Object)initialDataFileNumberProvider);
            this.timestampProvider = (StorageTimestampProvider)X.notNull((Object)timestampProvider);
            this.dataFileEvaluator = (StorageDataFileEvaluator)X.notNull((Object)dataFileEvaluator);
            this.fileProvider = (StorageLiveFileProvider)X.notNull((Object)fileProvider);
            this.entityCache = (StorageEntityCache.Default)X.notNull((Object)entityCache);
            this.writeController = (StorageWriteController)X.notNull((Object)writeController);
            this.writer = (StorageFileWriter)X.notNull((Object)writer);
            this.backupHandler = (StorageBackupHandler)X.mayNull((Object)backupHandler);
            this.standardByteBuffer = XMemory.allocateDirectNative((long)standardBufferSizeProvider.provideBufferSize());
        }

        final boolean isFileCleanupEnabled() {
            return this.writeController.isFileCleanupEnabled();
        }

        final <L extends Consumer<StorageEntity.Default>> L iterateEntities(L logic) {
            StorageLiveDataFile.Default head;
            StorageLiveDataFile.Default file = head = this.headFile;
            do {
                file = file.next;
                StorageEntity.Default tail = file.tail;
                StorageEntity.Default entity = file.head;
                while ((entity = entity.fileNext) != tail) {
                    logic.accept((StorageEntity.Default)entity);
                }
            } while (file != head);
            return logic;
        }

        final boolean isHeadFile(StorageLiveDataFile.Default dataFile) {
            return this.headFile == dataFile;
        }

        private void addFirstFile() {
            this.createNewStorageFile(this.initialDataFileNumberProvider.provideInitialDataFileNumber(this.channelIndex()));
        }

        final void clearTransactionsFile() {
            if (this.fileTransactions != null) {
                this.fileTransactions.unregisterUsageClosing(this, null);
                this.fileTransactions = null;
            }
        }

        final void clearRegisteredFiles() {
            StorageLiveDataFile.Default headFile;
            this.clearTransactionsFile();
            if (this.headFile == null) {
                return;
            }
            StorageLiveDataFile.Default file = headFile = this.headFile;
            do {
                file.unregisterUsageClosing(this, null);
            } while ((file = file.next) != headFile);
            this.headFile = null;
            this.fileCleanupCursor = null;
        }

        private ByteBuffer buffer(int length) {
            if (length > this.standardByteBuffer.capacity()) {
                return XMemory.allocateDirectNative((int)length);
            }
            this.standardByteBuffer.clear().limit(length);
            return this.standardByteBuffer;
        }

        private void clearBuffer(ByteBuffer buffer) {
            buffer.clear();
            if (buffer != this.standardByteBuffer) {
                XMemory.deallocateDirectByteBuffer((ByteBuffer)buffer);
            }
        }

        final void transferOneChainToHeadFile(StorageLiveDataFile.Default sourceFile) {
            StorageLiveDataFile.Default headFile = this.headFile;
            StorageEntity.Default first = sourceFile.head.fileNext;
            StorageEntity.Default last = null;
            StorageEntity.Default current = first;
            long copyStart = first.storagePosition;
            long targetFileOldTotalLength = headFile.totalLength();
            long maximumFileSize = this.dataFileEvaluator.fileMaximumSize();
            long freeSpace = maximumFileSize - targetFileOldTotalLength;
            long copyLength = 0L;
            do {
                if (copyLength + (long)current.length > freeSpace) {
                    if (copyLength != 0L) break;
                    if (targetFileOldTotalLength != 0L) {
                        this.createNextStorageFile();
                        return;
                    }
                }
                current.typeInFile = headFile.typeInFile(current.typeInFile.type);
                current.storagePosition = XTypes.to_int((long)(targetFileOldTotalLength + copyLength));
                last = current;
                current = last.fileNext;
            } while ((long)current.storagePosition == copyStart + (copyLength += (long)current.length));
            sourceFile.removeHeadBoundChain(current, copyLength);
            headFile.addChainToTail(first, last);
            this.appendBytesToHeadFile(sourceFile, copyStart, copyLength);
            if (copyLength >= freeSpace) {
                this.createNextStorageFile();
            }
        }

        private void appendBytesToHeadFile(StorageLiveDataFile.Default sourceFile, long copyStart, long copyLength) {
            StorageLiveDataFile.Default headFile = this.headFile;
            this.writer.writeTransfer(sourceFile, copyStart, copyLength, headFile);
            headFile.increaseContentLength(copyLength);
            long newHeadFileLength = headFile.totalLength();
            long timestamp = this.timestampProvider.currentNanoTimestamp();
            this.writeTransactionsEntryTransfer(sourceFile, copyStart, copyLength, timestamp, newHeadFileLength);
        }

        final StorageLiveDataFile.Default createLiveDataFile(AFile file, int channelIndex, long number) {
            return new StorageLiveDataFile.Default(this, (AFile)X.notNull((Object)file), XMath.notNegative((int)channelIndex), XMath.notNegative((long)number));
        }

        private void createNewStorageFile(long fileNumber) {
            AFile file = this.fileProvider.provideDataFile(this.channelIndex(), fileNumber);
            file.ensureExists();
            if (!file.isEmpty()) {
                throw new StorageExceptionIoWriting("New storage file is not empty: " + file);
            }
            StorageLiveDataFile.Default dataFile = this.createLiveDataFile(file, this.channelIndex(), fileNumber);
            this.registerStorageHeadFile(dataFile);
            this.writeTransactionsEntryFileCreation(0L, this.timestampProvider.currentNanoTimestamp(), fileNumber);
        }

        private void registerStorageHeadFile(StorageLiveDataFile.Default storageFile) {
            if (this.headFile == null) {
                storageFile.next = storageFile.prev = storageFile;
            } else {
                storageFile.next = this.headFile.next;
                storageFile.prev = this.headFile;
                this.headFile.next.prev = storageFile;
                this.headFile.next = storageFile;
            }
            this.headFile = storageFile;
        }

        @Override
        public final int channelIndex() {
            return this.channelIndex;
        }

        @Override
        public final StorageLiveDataFile.Default currentStorageFile() {
            return this.headFile;
        }

        @Override
        public void iterateStorageFiles(Consumer<? super StorageLiveDataFile> procedure) {
            StorageLiveDataFile.Default current;
            StorageLiveDataFile.Default file = current = this.headFile;
            do {
                file = file.next;
                procedure.accept(file);
            } while (file != current);
        }

        private void checkForNewFile() {
            if (this.headFile.needsRetirement(this.dataFileEvaluator)) {
                this.createNextStorageFile();
            }
        }

        final void createNextStorageFile() {
            this.createNewStorageFile(this.headFile.number() + 1L);
        }

        private long ensureHeadFileTotalLength() {
            long expectedLength;
            long physicalLength = this.headFile.size();
            if (physicalLength != (expectedLength = this.headFile.totalLength())) {
                throw new StorageExceptionIoWriting("Physical length " + physicalLength + " of current head file " + this.headFile.number() + " is not equal its expected length of " + expectedLength);
            }
            return physicalLength;
        }

        @Override
        public final long[] storeChunks(long timestamp, ByteBuffer[] dataBuffers) throws StorageExceptionIoWritingChunk {
            if (dataBuffers.length == 0) {
                return new long[0];
            }
            this.checkForNewFile();
            long oldTotalLength = this.ensureHeadFileTotalLength();
            long[] storagePositions = Default.allChunksStoragePositions(dataBuffers, oldTotalLength);
            long writeCount = this.writer.writeStore(this.headFile, (Iterable<? extends ByteBuffer>)X.ArrayView((Object[])dataBuffers));
            long newTotalLength = oldTotalLength + writeCount;
            if (newTotalLength != this.headFile.size()) {
                Default.throwImpossibleStoreLengthException(timestamp, oldTotalLength, writeCount, dataBuffers);
            }
            this.uncommittedDataLength = writeCount;
            this.writeTransactionsEntryStore(this.headFile, oldTotalLength, writeCount, timestamp, newTotalLength);
            this.restartFileCleanupCursor();
            return storagePositions;
        }

        @Override
        public final void rollbackWrite() {
            this.writer.truncate(this.headFile, this.headFile.totalLength(), this.fileProvider);
        }

        @Override
        public final void commitWrite() {
            this.headFile.increaseContentLength(this.uncommittedDataLength);
            this.clearUncommittedDataLength();
        }

        final void clearUncommittedDataLength() {
            this.uncommittedDataLength = 0L;
        }

        final void loadData(StorageLiveDataFile.Default dataFile, StorageEntity.Default entity, long length, long cacheChange) {
            ByteBuffer dataBuffer = this.buffer(X.checkArrayRange((long)length));
            try {
                try {
                    dataFile.readBytes(dataBuffer, (long)entity.storagePosition);
                    this.putLiveEntityData(entity, XMemory.getDirectByteBufferAddress((ByteBuffer)dataBuffer), length, cacheChange);
                }
                catch (StorageExceptionIoReading e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new StorageExceptionIoReading(e);
                }
            }
            finally {
                this.clearBuffer(dataBuffer);
            }
        }

        private void putLiveEntityData(StorageEntity.Default entity, long address, long length, long cacheChange) {
            entity.putCacheData(address, length);
            this.entityCache.modifyUsedCacheSize(cacheChange);
        }

        @Override
        public final StorageInventory readStorage() {
            if (this.headFile != null) {
                throw new StorageExceptionIoReading(String.valueOf(this.channelIndex()) + " already initialized");
            }
            StorageTransactionsAnalysis transactionsAnalysis = this.readTransactionsFile();
            EqHashTable dataFiles = EqHashTable.New();
            this.fileProvider.collectDataFiles(StorageDataInventoryFile::New, f -> {
                boolean bl = dataFiles.add((Object)f.number(), f);
            }, this.channelIndex());
            dataFiles.keys().sort(XSort::compare);
            return StorageInventory.New(this.channelIndex(), (XGettingTable<Long, StorageDataInventoryFile>)dataFiles, transactionsAnalysis);
        }

        final StorageTransactionsAnalysis readTransactionsFile() {
            StorageLiveTransactionsFile file = this.createTransactionsFile();
            if (!file.exists()) {
                return null;
            }
            try {
                StorageTransactionsAnalysis.EntryAggregator aggregator = file.processBy(new StorageTransactionsAnalysis.EntryAggregator(this.channelIndex()));
                return aggregator.yield(file);
            }
            catch (Exception e) {
                StorageClosableFile.close(file, e);
                throw new StorageException(e);
            }
        }

        private long validateStorageDataFilesLength(StorageInventory storageInventory, EqHashTable<Long, StorageDataInventoryFile> supplementedMissingEmptyFiles) {
            StorageTransactionsAnalysis tFileAnalysis = storageInventory.transactionsFileAnalysis();
            long unregisteredEmptyLastFileNumber = -1L;
            if (tFileAnalysis == null || tFileAnalysis.transactionsFileEntries().isEmpty()) {
                return unregisteredEmptyLastFileNumber;
            }
            XGettingTable.Values dataFiles = storageInventory.dataFiles().values();
            EqHashTable fileEntries = EqHashTable.New(tFileAnalysis.transactionsFileEntries());
            StorageDataInventoryFile lastFile = (StorageDataInventoryFile)dataFiles.peek();
            for (StorageDataInventoryFile file : dataFiles) {
                long actualFileLength = file.size();
                StorageTransactionEntry entryFile = (StorageTransactionEntry)fileEntries.removeFor((Object)file.number());
                if (entryFile == null) {
                    if (file == lastFile && actualFileLength == 0L) {
                        unregisteredEmptyLastFileNumber = file.number();
                        continue;
                    }
                    throw new StorageException(String.valueOf(this.channelIndex()) + " could not find transactions entry for file " + file.number());
                }
                if (entryFile.length() == actualFileLength || file == lastFile && entryFile.length() < actualFileLength) continue;
                throw new StorageExceptionConsistency(String.valueOf(this.channelIndex()) + " Length " + actualFileLength + " of file " + file.number() + " is inconsinstent with the transactions entry's length of " + entryFile.length());
            }
            for (StorageTransactionEntry remainingFileEntry : fileEntries.values()) {
                if (remainingFileEntry.isDeleted()) continue;
                if (remainingFileEntry.isEmpty()) {
                    this.supplementedMissingEmptyFile(supplementedMissingEmptyFiles, remainingFileEntry.fileNumber());
                    continue;
                }
                throw new StorageException("Non-deleted non-empty data file not found: channel " + this.channelIndex() + ", file " + remainingFileEntry.fileNumber());
            }
            return unregisteredEmptyLastFileNumber;
        }

        protected void supplementedMissingEmptyFile(EqHashTable<Long, StorageDataInventoryFile> supplementedMissingEmptyFiles, long fileNumber) {
            AFile missingEmptyFile = this.fileProvider.provideDataFile(this.channelIndex, fileNumber);
            missingEmptyFile.ensureExists();
            StorageDataInventoryFile supplementedDataFile = StorageDataInventoryFile.New(missingEmptyFile, this.channelIndex, fileNumber);
            supplementedMissingEmptyFiles.add((Object)fileNumber, (Object)supplementedDataFile);
        }

        @Override
        public StorageIdAnalysis initializeStorage(long taskTimestamp, long consistentStoreTimestamp, StorageInventory storageInventory, StorageChannel parent) {
            EqHashTable supplementedMissingEmptyFiles = EqHashTable.New();
            long unregisteredEmptyLastFileNumber = this.validateStorageDataFilesLength(storageInventory, (EqHashTable<Long, StorageDataInventoryFile>)supplementedMissingEmptyFiles);
            StorageInventory effectiveStorageInventory = this.determineEffectiveStorageInventory(storageInventory, (EqHashTable<Long, StorageDataInventoryFile>)supplementedMissingEmptyFiles);
            boolean isEmpty = true;
            try {
                StorageIdAnalysis idAnalysis;
                isEmpty = effectiveStorageInventory.dataFiles().isEmpty();
                if (isEmpty) {
                    this.initializeForNoFiles(taskTimestamp, effectiveStorageInventory);
                    idAnalysis = StorageIdAnalysis.New(0L, 0L, 0L);
                    this.initializeBackupHandler();
                } else {
                    this.entityCache.registerPendingStoreUpdate();
                    idAnalysis = this.initializeForExistingFiles(taskTimestamp, effectiveStorageInventory, consistentStoreTimestamp, unregisteredEmptyLastFileNumber);
                    this.initializeBackupHandler(effectiveStorageInventory);
                }
                this.restartFileCleanupCursor();
                StorageIdAnalysis storageIdAnalysis = idAnalysis;
                return storageIdAnalysis;
            }
            catch (RuntimeException e) {
                parent.reset();
                throw e;
            }
            finally {
                if (!isEmpty) {
                    this.entityCache.clearPendingStoreUpdate();
                }
            }
        }

        protected StorageInventory determineEffectiveStorageInventory(StorageInventory storageInventory, EqHashTable<Long, StorageDataInventoryFile> supplementedMissingEmptyFiles) {
            if (supplementedMissingEmptyFiles.isEmpty()) {
                return storageInventory;
            }
            EqHashTable completeDataFiles = EqHashTable.New(storageInventory.dataFiles()).addAll(supplementedMissingEmptyFiles);
            completeDataFiles.keys().sort(XSort::compare);
            return StorageInventory.New(storageInventory.channelIndex(), (XGettingTable<Long, StorageDataInventoryFile>)completeDataFiles.immure(), storageInventory.transactionsFileAnalysis());
        }

        private boolean initializeBackupHandler() {
            if (this.backupHandler == null) {
                return false;
            }
            this.backupHandler.initialize(this.channelIndex());
            return true;
        }

        private void initializeBackupHandler(StorageInventory inventory) {
            if (!this.initializeBackupHandler()) {
                return;
            }
            this.backupHandler.synchronize(inventory);
        }

        private StorageIdAnalysis initializeForExistingFiles(long taskTimestamp, StorageInventory storageInventory, long consistentStoreTimestamp, long unregisteredEmptyLastFileNumber) {
            XGettingTable.Values files = storageInventory.dataFiles().values();
            long lastFileLength = unregisteredEmptyLastFileNumber >= 0L ? 0L : this.determineLastFileLength(consistentStoreTimestamp, storageInventory);
            StorageEntityInitializer<StorageLiveDataFile.Default> initializer = StorageEntityInitializer.New(this.entityCache, f -> StorageLiveDataFile.New(this, f));
            this.headFile = initializer.registerEntities((XGettingSequence<StorageDataInventoryFile>)files, lastFileLength);
            StorageIdAnalysis idAnalysis = this.entityCache.validateEntities();
            this.ensureTransactionsFile(taskTimestamp, storageInventory, unregisteredEmptyLastFileNumber);
            this.handleLastFile(this.headFile, lastFileLength);
            this.checkForNewFile();
            return idAnalysis;
        }

        private long determineLastFileLength(long consistentStoreTimestamp, StorageInventory storageInventory) {
            StorageTransactionsAnalysis tFileAnalysis = storageInventory.transactionsFileAnalysis();
            if (tFileAnalysis == null || tFileAnalysis.isEmpty()) {
                return ((StorageDataInventoryFile)storageInventory.dataFiles().values().last()).size();
            }
            if (tFileAnalysis.headFileLatestTimestamp() == consistentStoreTimestamp) {
                return tFileAnalysis.headFileLatestLength();
            }
            if (tFileAnalysis.headFileLastConsistentStoreTimestamp() == consistentStoreTimestamp) {
                return tFileAnalysis.headFileLastConsistentStoreLength();
            }
            throw new StorageExceptionConsistency("Inconsistent last timestamps in last file of channel " + this.channelIndex());
        }

        private void initializeForNoFiles(long taskTimestamp, StorageInventory storageInventory) {
            this.ensureTransactionsFile(taskTimestamp, storageInventory, -1L);
            this.addFirstFile();
        }

        private void ensureTransactionsFile(long taskTimestamp, StorageInventory storageInventory, long unregisteredEmptyLastFileNumber) {
            StorageLiveTransactionsFile transactionsFile;
            StorageTransactionsAnalysis trFileAn = storageInventory.transactionsFileAnalysis();
            if (trFileAn == null || trFileAn.isEmpty()) {
                StorageLiveTransactionsFile storageLiveTransactionsFile = transactionsFile = trFileAn == null ? this.createTransactionsFile() : trFileAn.transactionsFile();
                if (transactionsFile.size() != 0L) {
                    throw new StorageException("Invalid transactions file in channel " + this.channelIndex);
                }
                this.deriveTransactionsFile(taskTimestamp, storageInventory, transactionsFile);
            } else {
                transactionsFile = trFileAn.transactionsFile();
            }
            this.setTransactionsFile(transactionsFile);
            if (unregisteredEmptyLastFileNumber >= 0L) {
                this.writeTransactionsEntryFileCreation(0L, taskTimestamp, unregisteredEmptyLastFileNumber);
            }
        }

        private StorageLiveTransactionsFile createTransactionsFile() {
            AFile file = this.fileProvider.provideTransactionsFile(this.channelIndex());
            file.ensureExists();
            return StorageLiveTransactionsFile.New(file, this.channelIndex());
        }

        private void deriveTransactionsFile(long taskTimestamp, StorageInventory storageInventory, StorageLiveTransactionsFile tfile) {
            XGettingTable.Values files = storageInventory.dataFiles().values();
            ByteBuffer buffer = this.entryBufferFileCreation;
            long address = this.entryBufferFileCreationAddress;
            StorageFileWriter writer = this.writer;
            long timestamp = taskTimestamp - storageInventory.dataFiles().size() - 1L;
            try {
                for (StorageDataInventoryFile file : files) {
                    buffer.clear();
                    StorageTransactionsAnalysis.Logic.setEntryFileCreation(address, file.size(), ++timestamp, file.number());
                    writer.write(tfile, this.entryBufferWrapFileCreation);
                }
            }
            catch (Exception e) {
                StorageClosableFile.close(tfile, e);
                throw e;
            }
        }

        private void writeTransactionsEntryFileCreation(long length, long timestamp, long number) {
            this.entryBufferFileCreation.clear();
            StorageTransactionsAnalysis.Logic.setEntryFileCreation(this.entryBufferFileCreationAddress, length, timestamp, number);
            this.writer.writeTransactionEntryCreate(this.fileTransactions, this.entryBufferWrapFileCreation, this.headFile);
        }

        private void writeTransactionsEntryStore(StorageLiveDataFile dataFile, long dataFileOffset, long storeLength, long timestamp, long headFileNewTotalLength) {
            this.entryBufferStore.clear();
            StorageTransactionsAnalysis.Logic.setEntryStore(this.entryBufferStoreAddress, headFileNewTotalLength, timestamp);
            this.writer.writeTransactionEntryStore(this.fileTransactions, this.entryBufferWrapStore, dataFile, dataFileOffset, storeLength);
        }

        private void writeTransactionsEntryTransfer(StorageLiveDataFile sourceFile, long sourcefileOffset, long copyLength, long timestamp, long headNewFileTotalLength) {
            this.entryBufferTransfer.clear();
            StorageTransactionsAnalysis.Logic.setEntryTransfer(this.entryBufferTransferAddress, headNewFileTotalLength, timestamp, sourceFile.number(), sourcefileOffset);
            this.writer.writeTransactionEntryTransfer(this.fileTransactions, this.entryBufferWrapTransfer, sourceFile, sourcefileOffset, copyLength);
        }

        private void writeTransactionsEntryFileDeletion(StorageLiveDataFile.Default dataFile, long timestamp) {
            this.entryBufferFileDeletion.clear();
            StorageTransactionsAnalysis.Logic.setEntryFileDeletion(this.entryBufferFileDeletionAddress, dataFile.totalLength(), timestamp, dataFile.number());
            this.writer.writeTransactionEntryDelete(this.fileTransactions, this.entryBufferWrapFileDeletion, dataFile);
        }

        private void writeTransactionsEntryFileTruncation(StorageLiveDataFile.Default lastFile, long timestamp, long newLength) {
            this.entryBufferFileTruncation.clear();
            StorageTransactionsAnalysis.Logic.setEntryFileTruncation(this.entryBufferFileTruncationAddress, newLength, timestamp, lastFile.number(), lastFile.size());
            this.writer.writeTransactionEntryTruncate(this.fileTransactions, this.entryBufferWrapFileTruncation, lastFile, newLength);
        }

        private void setTransactionsFile(StorageLiveTransactionsFile transactionsFile) {
            this.fileTransactions = transactionsFile;
            transactionsFile.registerUsage(this);
        }

        final void clearStandardByteBuffer() {
            this.standardByteBuffer.clear();
        }

        @Override
        public final void reset() {
            this.clearStandardByteBuffer();
            this.clearUncommittedDataLength();
            this.clearRegisteredFiles();
            this.pendingFileDeletes = 0;
        }

        final void handleLastFile(StorageLiveDataFile.Default lastFile, long lastFileLength) {
            if (lastFileLength != lastFile.size()) {
                long timestamp = this.timestampProvider.currentNanoTimestamp();
                this.writeTransactionsEntryFileTruncation(lastFile, timestamp, lastFileLength);
                this.writer.truncate(lastFile, lastFileLength, this.fileProvider);
            }
        }

        @Override
        public void exportData(StorageLiveFileProvider fileProvider) {
            AFile transactionsFile = fileProvider.provideTransactionsFile(this.channelIndex());
            AFS.executeWriting((AFile)transactionsFile, wf -> {
                long l = this.fileTransactions.copyTo((AWritableFile)wf);
            });
            this.iterateStorageFiles(file -> {
                AFile exportFile = fileProvider.provideDataFile(file.channelIndex(), file.number());
                AFS.executeWriting((AFile)exportFile, wf -> {
                    long l = file.copyTo((AWritableFile)wf);
                });
            });
        }

        private static StorageRawFileStatistics.FileStatistics createFileStatistics(StorageLiveDataFile.Default file) {
            return StorageRawFileStatistics.FileStatistics.New(file.number(), file.identifier(), file.dataLength(), file.totalLength());
        }

        @Override
        public final StorageRawFileStatistics.ChannelStatistics createRawFileStatistics() {
            StorageLiveDataFile.Default file;
            StorageLiveDataFile.Default currentFile = file = this.headFile;
            long liveDataLength = 0L;
            long totalDataLength = 0L;
            BulkList fileStatistics = BulkList.New();
            do {
                file = file.next;
                liveDataLength += file.dataLength();
                totalDataLength += file.totalLength();
                StorageRawFileStatistics.FileStatistics fileStats = Default.createFileStatistics(file);
                fileStatistics.add((Object)fileStats);
            } while (file != currentFile);
            return StorageRawFileStatistics.ChannelStatistics.New(this.channelIndex(), fileStatistics.size(), liveDataLength, totalDataLength, (XGettingSequence<? extends StorageRawFileStatistics.FileStatistics>)fileStatistics);
        }

        @Override
        public final boolean incrementalFileCleanupCheck(long nanoTimeBudgetBound) {
            return this.internalCheckForCleanup(nanoTimeBudgetBound, this.dataFileEvaluator);
        }

        @Override
        public final void restartFileCleanupCursor() {
            this.fileCleanupCursor = this.headFile.next;
        }

        @Override
        public final boolean issuedFileCleanupCheck(long nanoTimeBudgetBound) {
            return this.internalCheckForCleanup(nanoTimeBudgetBound, this.dataFileEvaluator);
        }

        private void deletePendingFile(StorageLiveDataFile.Default file) {
            if (this.pendingFileDeletes < 1) {
                throw new StorageExceptionConsistency(String.valueOf(this.channelIndex()) + " has inconsistent pending deletes: count = " + this.pendingFileDeletes + ", wants to delete " + file);
            }
            --this.pendingFileDeletes;
            this.deleteFile(file);
        }

        private boolean internalCheckForCleanup(long nanoTimeBudgetBound, StorageDataFileDissolvingEvaluator fileDissolver) {
            this.writeController.validateIsFileCleanupEnabled();
            if (this.fileCleanupCursor == null) {
                return true;
            }
            StorageLiveDataFile.Default cycleAnchorFile = this.fileCleanupCursor;
            while (this.fileCleanupCursor != null && System.nanoTime() < nanoTimeBudgetBound) {
                if (!this.fileCleanupCursor.hasUsers()) {
                    if (!this.fileCleanupCursor.executeIfUnsuedData(this.pendingDeleter)) break;
                    if (this.fileCleanupCursor == cycleAnchorFile) {
                        this.fileCleanupCursor = cycleAnchorFile = cycleAnchorFile.next;
                        continue;
                    }
                } else if (fileDissolver.needsDissolving(this.fileCleanupCursor)) {
                    if (this.fileCleanupCursor == this.headFile) {
                        this.createNextStorageFile();
                    }
                    if (!this.incrementalDissolveStorageFile(this.fileCleanupCursor, nanoTimeBudgetBound)) continue;
                    if (this.fileCleanupCursor == cycleAnchorFile) {
                        this.fileCleanupCursor = cycleAnchorFile = cycleAnchorFile.next;
                        continue;
                    }
                }
                if ((this.fileCleanupCursor = this.fileCleanupCursor.next) != cycleAnchorFile) continue;
                if (this.pendingFileDeletes > 0) break;
                this.fileCleanupCursor = null;
            }
            return this.fileCleanupCursor == null;
        }

        private boolean incrementalDissolveStorageFile(StorageLiveDataFile.Default file, long nanoTimeBudgetBound) {
            if (this.incrementalTransferEntities(file, nanoTimeBudgetBound)) {
                if (file.unregisterUsageClosingData(this, this.deleter)) {
                    return true;
                }
                ++this.pendingFileDeletes;
                return false;
            }
            return false;
        }

        private void deleteFile(StorageLiveDataFile.Default file) {
            file.detach();
            file.close();
            this.writeTransactionsEntryFileDeletion(file, this.timestampProvider.currentNanoTimestamp());
            this.writer.delete(file, this.writeController, this.fileProvider);
        }

        private boolean incrementalTransferEntities(StorageLiveDataFile.Default file, long nanoTimeBudgetBound) {
            this.checkForNewFile();
            while (file.hasContent() && System.nanoTime() < nanoTimeBudgetBound) {
                this.transferOneChainToHeadFile(file);
            }
            return !file.hasContent();
        }

        final StorageEntity.Default getFirstEntity() {
            StorageLiveDataFile.Default startingFile;
            StorageLiveDataFile.Default currentFile = this.currentStorageFile();
            if (currentFile == null) {
                return null;
            }
            StorageLiveDataFile.Default file = startingFile = currentFile.next;
            do {
                if (file.head.fileNext == startingFile.tail) continue;
                return file.head.fileNext;
            } while ((file = file.next) != startingFile);
            return null;
        }

        final void prepareImport() {
            this.importHelper = new ImportHelper(this.headFile);
            try {
                this.createNextStorageFile();
            }
            catch (Exception e) {
                this.importHelper = null;
                throw new StorageException(e);
            }
        }

        public void copyData(StorageImportSourceFile importFile) {
            importFile.iterateBatches(this.importHelper.setFile(importFile));
        }

        public void commitImport(long taskTimestamp) {
            long oldTotalLength;
            StorageEntityCache.Default entityCache = this.entityCache;
            StorageLiveDataFile.Default headFile = this.headFile;
            long loopFileLength = oldTotalLength = this.headFile.totalLength();
            for (StorageChannelImportBatch batch : this.importHelper.importBatches) {
                StorageChannelImportEntity entity = batch.first();
                while (entity != null) {
                    StorageEntity.Default actual = entityCache.putEntity(entity.objectId(), entity.type());
                    actual.updateStorageInformation(entity.length(), X.checkArrayRange((long)loopFileLength));
                    headFile.appendEntry(actual);
                    loopFileLength += (long)entity.length();
                    entity = entity.next();
                }
            }
            long copyLength = loopFileLength - oldTotalLength;
            headFile.increaseContentLength(copyLength);
            this.cleanupImportHelper();
            this.writeTransactionsEntryStore(this.headFile, oldTotalLength, copyLength, taskTimestamp, loopFileLength);
        }

        final void cleanupImportHelper() {
            this.importHelper = null;
        }

        final void importBatch(StorageFile file, long position, long length) {
            if (length == 0L) {
                return;
            }
            this.checkForNewFile();
            this.writer.writeImport(file, position, length, this.headFile);
        }

        final void rollbackImport() {
            if (this.importHelper == null) {
                return;
            }
            StorageLiveDataFile.Default first = this.headFile.next;
            StorageLiveDataFile.Default doomed = this.importHelper.preImportHeadFile.next;
            this.headFile.next = null;
            first.prev = this.headFile = this.importHelper.preImportHeadFile;
            this.headFile.next = first;
            BulkList exceptions = BulkList.New();
            while (doomed != null) {
                try {
                    this.terminateFile(doomed);
                }
                catch (RuntimeException e) {
                    exceptions.add((Object)e);
                }
                doomed = doomed.next;
            }
            this.cleanupImportHelper();
            if (!exceptions.isEmpty()) {
                throw new StorageException((Throwable)new MultiCauseException((Throwable[])exceptions.toArray(RuntimeException.class)));
            }
        }

        private void terminateFile(StorageLiveDataFile.Default file) {
            file.close();
            this.writer.delete(file, this.writeController, this.fileProvider);
        }

        static void throwImpossibleStoreLengthException(long timestamp, long currentTotalLength, long uncommittedDataLength, ByteBuffer[] dataBuffers) {
            VarString vs = VarString.New();
            vs.add("Impossible store length:").lf().add("timestamp = ").add(timestamp).lf().add("currentTotalLength = ").add(currentTotalLength).lf().add("uncommittedDataLength = ").add(uncommittedDataLength).lf().add("resulting length = ").add(currentTotalLength + uncommittedDataLength).lf().add("dataBuffers: ");
            if (dataBuffers.length == 0) {
                vs.add("[none]");
            } else {
                int i = 0;
                while (i < dataBuffers.length) {
                    vs.lf().add('#').add(i).add(": ").add("limit = ").add(dataBuffers[i].limit()).add(", ").add("position = ").add(dataBuffers[i].position()).add(", ").add("capacity = ").add(dataBuffers[i].capacity()).add(";");
                    ++i;
                }
            }
            throw new StorageException(vs.toString());
        }

        final class ImportHelper
        implements Consumer<StorageChannelImportBatch> {
            final StorageLiveDataFile.Default preImportHeadFile;
            final BulkList<StorageChannelImportBatch> importBatches = BulkList.New((long)1000L);
            StorageFile file;

            ImportHelper(StorageLiveDataFile.Default preImportHeadFile) {
                this.preImportHeadFile = preImportHeadFile;
            }

            @Override
            public void accept(StorageChannelImportBatch batch) {
                this.importBatches.add((Object)batch);
                Default.this.importBatch(this.file, batch.fileOffset(), batch.fileLength());
            }

            final ImportHelper setFile(StorageFile file) {
                this.file = file;
                return this;
            }
        }
    }
}

