/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.text.SimpleDateFormat;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AFileSystem;
import one.microstream.afs.types.AItem;
import one.microstream.chars.VarString;
import one.microstream.persistence.internal.PersistenceTypeDictionaryFileHandler;
import one.microstream.persistence.types.PersistenceTypeDictionaryIoHandler;
import one.microstream.storage.types.StorageChannelFile;
import one.microstream.storage.types.StorageDataFile;
import one.microstream.storage.types.StorageDirectoryStructureProvider;
import one.microstream.storage.types.StorageFileNameProvider;

public interface StorageFileProvider
extends PersistenceTypeDictionaryIoHandler.Provider {
    public AFileSystem fileSystem();

    public ADirectory baseDirectory();

    public ADirectory deletionDirectory();

    public ADirectory truncationDirectory();

    public StorageFileNameProvider fileNameProvider();

    public AFile provideDeletionTargetFile(StorageChannelFile var1);

    public AFile provideTruncationTargetFile(StorageChannelFile var1, long var2);

    public <F extends StorageDataFile, C extends Consumer<F>> C collectDataFiles(StorageDataFile.Creator<F> var1, C var2, int var3);

    public static abstract class Abstract
    extends PersistenceTypeDictionaryIoHandler.Provider.Abstract
    implements StorageFileProvider {
        private final AFileSystem fileSystem;
        private final ADirectory baseDirectory;
        private final ADirectory deletionDirectory;
        private final ADirectory truncationDirectory;
        private final StorageDirectoryStructureProvider structureProvider;
        private final StorageFileNameProvider fileNameProvider;

        Abstract(ADirectory baseDirectory, ADirectory deletionDirectory, ADirectory truncationDirectory, StorageDirectoryStructureProvider structureProvider, StorageFileNameProvider fileNameProvider, PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator) {
            super(fileHandlerCreator);
            this.fileSystem = baseDirectory.fileSystem();
            this.baseDirectory = baseDirectory;
            this.deletionDirectory = deletionDirectory;
            this.truncationDirectory = truncationDirectory;
            this.structureProvider = structureProvider;
            this.fileNameProvider = fileNameProvider;
        }

        @Override
        public AFileSystem fileSystem() {
            return this.fileSystem;
        }

        @Override
        public ADirectory baseDirectory() {
            return this.baseDirectory;
        }

        @Override
        public ADirectory deletionDirectory() {
            return this.deletionDirectory;
        }

        @Override
        public ADirectory truncationDirectory() {
            return this.truncationDirectory;
        }

        @Override
        public StorageFileNameProvider fileNameProvider() {
            return this.fileNameProvider;
        }

        protected AFile defineTypeDictionaryFile() {
            ADirectory directory = this.baseDirectory;
            directory.ensureExists();
            AFile file = directory.ensureFile(this.fileNameProvider.typeDictionaryFileName());
            return file;
        }

        private ADirectory provideChannelDirectory(ADirectory baseDirectory, int channelIndex) {
            ADirectory channelDirectory = this.structureProvider.provideChannelDirectory(baseDirectory, channelIndex, this.fileNameProvider);
            channelDirectory.ensureExists();
            return channelDirectory;
        }

        private AFile provideChannelFile(ADirectory baseDirectory, StorageChannelFile channelFile, String newName, String newType) {
            String effectiveName = (String)X.coalesce((Object)newName, (Object)channelFile.file().name());
            String effectiveType = (String)X.coalesce((Object)newType, (Object)channelFile.file().type());
            return this.provideChannelFile(baseDirectory, channelFile.channelIndex(), effectiveName, effectiveType);
        }

        private AFile provideChannelFile(ADirectory baseDirectory, int channelIndex, String newName, String newType) {
            ADirectory channelDirectory = this.provideChannelDirectory(baseDirectory, channelIndex);
            AFile channelFile = channelDirectory.ensureFile(newName, newType);
            return channelFile;
        }

        @Override
        public AFile provideDeletionTargetFile(StorageChannelFile fileToBeDeleted) {
            if (this.deletionDirectory == null) {
                return null;
            }
            String baseFileName = fileToBeDeleted.file().name();
            String fileName = Abstract.addDeletionFileNameTag(baseFileName);
            String fileType = this.fileNameProvider.rescuedFileType();
            return this.provideChannelFile(this.deletionDirectory, fileToBeDeleted, fileName, fileType);
        }

        protected static String addDeletionFileNameTag(String currentName) {
            SimpleDateFormat sdf = new SimpleDateFormat("_yyyy-MM-dd_HH-mm-ss_SSS");
            String newFileName = String.valueOf(currentName) + sdf.format(System.currentTimeMillis());
            return newFileName;
        }

        @Override
        public AFile provideTruncationTargetFile(StorageChannelFile fileToBeTruncated, long newLength) {
            if (this.truncationDirectory == null) {
                return null;
            }
            String baseFileName = fileToBeTruncated.file().name();
            String fileType = this.fileNameProvider.rescuedFileType();
            String fileName = Abstract.addTruncationFileNameTag(baseFileName, fileToBeTruncated.size(), newLength);
            return this.provideChannelFile(this.truncationDirectory, fileToBeTruncated, fileName, fileType);
        }

        protected static String addTruncationFileNameTag(String truncationFileNameRaw, long oldLength, long newLength) {
            return String.valueOf(truncationFileNameRaw) + "_truncated_from_" + oldLength + "_to_" + newLength + "_@" + System.currentTimeMillis();
        }

        @Override
        public <F extends StorageDataFile, C extends Consumer<F>> C collectDataFiles(StorageDataFile.Creator<F> creator, C collector, int channelIndex) {
            ADirectory directory = this.structureProvider.provideChannelDirectory(this.baseDirectory, channelIndex, this.fileNameProvider);
            directory.iterateFiles(f -> {
                if (!f.exists()) {
                    return;
                }
                this.fileNameProvider.parseDataInventoryFile(creator, collector, channelIndex, (AFile)f);
            });
            return collector;
        }

        public ADirectory provideChannelDirectory(int channelIndex) {
            return this.provideChannelDirectory(this.baseDirectory, channelIndex);
        }

        public AFile provideDataFile(int channelIndex, long fileNumber) {
            ADirectory channelDirectory = this.provideChannelDirectory(channelIndex);
            String dataFileName = this.fileNameProvider.provideDataFileName(channelIndex, fileNumber);
            String dataFileType = this.fileNameProvider.dataFileType();
            AFile file = channelDirectory.ensureFile(dataFileName, dataFileType);
            return file;
        }

        public AFile provideTransactionsFile(int channelIndex) {
            ADirectory channelDirectory = this.provideChannelDirectory(channelIndex);
            String dataFileName = this.fileNameProvider.provideTransactionsFileName(channelIndex);
            String dataFileType = this.fileNameProvider.transactionsFileType();
            AFile file = channelDirectory.ensureFile(dataFileName, dataFileType);
            return file;
        }

        public AFile provideLockFile() {
            AFile file = this.baseDirectory.ensureFile(this.fileNameProvider.lockFileName());
            return file;
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().blank().add("base directory").tab().add('=').blank().add((Object)this.baseDirectory).lf().blank().add("file names").tab().add('=').blank().add((Object)this.fileNameProvider).lf().toString();
        }
    }

    public static interface Builder<B extends Builder<?>> {
        public AFileSystem fileSystem();

        public ADirectory directory();

        public B setDirectory(ADirectory var1);

        public ADirectory deletionDirectory();

        public B setDeletionDirectory(ADirectory var1);

        public ADirectory truncationDirectory();

        public B setTruncationDirectory(ADirectory var1);

        public StorageDirectoryStructureProvider directoryStructureProvider();

        public B setDirectoryStructureProvider(StorageDirectoryStructureProvider var1);

        public StorageFileNameProvider fileNameProvider();

        public B setFileNameProvider(StorageFileNameProvider var1);

        public PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator();

        public B setFileHandlerCreator(PersistenceTypeDictionaryFileHandler.Creator var1);

        public StorageFileProvider createFileProvider();

        public static abstract class Abstract<B extends Abstract<?>>
        implements Builder<B> {
            private final AFileSystem fileSystem;
            private ADirectory directory;
            private ADirectory deletionDirectory;
            private ADirectory truncationDirectory;
            private StorageDirectoryStructureProvider structureProvider;
            private StorageFileNameProvider fileNameProvider;
            private PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator;

            Abstract(AFileSystem fileSystem) {
                this.fileSystem = (AFileSystem)X.notNull((Object)fileSystem);
            }

            @Override
            public final AFileSystem fileSystem() {
                return this.fileSystem;
            }

            protected final B $() {
                return (B)this;
            }

            @Override
            public ADirectory directory() {
                return this.directory;
            }

            @Override
            public B setDirectory(ADirectory directory) {
                this.directory = (ADirectory)this.fileSystem.validateMember((AItem)directory);
                return this.$();
            }

            @Override
            public ADirectory deletionDirectory() {
                return this.deletionDirectory;
            }

            @Override
            public B setDeletionDirectory(ADirectory deletionDirectory) {
                this.deletionDirectory = (ADirectory)this.fileSystem.validateMember((AItem)deletionDirectory);
                return this.$();
            }

            @Override
            public ADirectory truncationDirectory() {
                return this.truncationDirectory;
            }

            @Override
            public B setTruncationDirectory(ADirectory truncationDirectory) {
                this.truncationDirectory = (ADirectory)this.fileSystem.validateMember((AItem)truncationDirectory);
                return this.$();
            }

            @Override
            public StorageDirectoryStructureProvider directoryStructureProvider() {
                return this.structureProvider;
            }

            @Override
            public B setDirectoryStructureProvider(StorageDirectoryStructureProvider directoryStructureProvider) {
                this.structureProvider = directoryStructureProvider;
                return this.$();
            }

            @Override
            public StorageFileNameProvider fileNameProvider() {
                return this.fileNameProvider;
            }

            @Override
            public B setFileNameProvider(StorageFileNameProvider fileNameProvider) {
                this.fileNameProvider = fileNameProvider;
                return this.$();
            }

            @Override
            public PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator() {
                return this.fileHandlerCreator;
            }

            @Override
            public B setFileHandlerCreator(PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator) {
                this.fileHandlerCreator = fileHandlerCreator;
                return this.$();
            }

            protected abstract ADirectory getBaseDirectory();

            protected ADirectory getDeletionDirectory() {
                return this.deletionDirectory;
            }

            protected ADirectory getTruncationDirectory() {
                return this.truncationDirectory;
            }

            protected StorageDirectoryStructureProvider getDirectoryStructureProvider() {
                return this.structureProvider != null ? this.structureProvider : StorageDirectoryStructureProvider.Defaults.defaultDirectoryStructureProvider();
            }

            protected StorageFileNameProvider getFileNameProvider() {
                return this.fileNameProvider != null ? this.fileNameProvider : StorageFileNameProvider.Defaults.defaultFileNameProvider();
            }

            protected PersistenceTypeDictionaryFileHandler.Creator getTypeDictionaryFileHandler() {
                return this.fileHandlerCreator != null ? this.fileHandlerCreator : PersistenceTypeDictionaryFileHandler::New;
            }
        }
    }
}

