/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteOrder;
import one.microstream.afs.types.WriteController;
import one.microstream.exceptions.MissingFoundationPartException;
import one.microstream.persistence.binary.types.BinaryEntityRawDataIterator;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.Unpersistable;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageBackupThreadProvider;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageChannelThreadProvider;
import one.microstream.storage.types.StorageChannelsCreator;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageDataChunkValidator;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageDataFileValidator;
import one.microstream.storage.types.StorageEntityDataValidator;
import one.microstream.storage.types.StorageEntityMarkMonitor;
import one.microstream.storage.types.StorageEventLogger;
import one.microstream.storage.types.StorageExceptionHandler;
import one.microstream.storage.types.StorageFileWriter;
import one.microstream.storage.types.StorageGCZombieOidHandler;
import one.microstream.storage.types.StorageHousekeepingBroker;
import one.microstream.storage.types.StorageInitialDataFileNumberProvider;
import one.microstream.storage.types.StorageLockFileManager;
import one.microstream.storage.types.StorageLockFileManagerThreadProvider;
import one.microstream.storage.types.StorageLockFileSetup;
import one.microstream.storage.types.StorageObjectIdMarkQueue;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestAcceptor;
import one.microstream.storage.types.StorageRequestTaskCreator;
import one.microstream.storage.types.StorageRootOidSelector;
import one.microstream.storage.types.StorageRootTypeIdProvider;
import one.microstream.storage.types.StorageSystem;
import one.microstream.storage.types.StorageTaskBroker;
import one.microstream.storage.types.StorageThreadNameProvider;
import one.microstream.storage.types.StorageThreadProvider;
import one.microstream.storage.types.StorageTimestampProvider;
import one.microstream.storage.types.StorageTypeDictionary;
import one.microstream.storage.types.StorageWriteController;
import one.microstream.util.InstanceDispatcher;
import one.microstream.util.ProcessIdentityProvider;

public interface StorageFoundation<F extends StorageFoundation<?>> {
    public StorageConfiguration getConfiguration();

    public StorageOperationController.Creator getOperationControllerCreator();

    public StorageInitialDataFileNumberProvider getInitialDataFileNumberProvider();

    public StorageRequestAcceptor.Creator getRequestAcceptorCreator();

    public StorageTaskBroker.Creator getTaskBrokerCreator();

    public StorageDataChunkValidator.Provider getDataChunkValidatorProvider();

    public StorageDataChunkValidator.Provider2 getDataChunkValidatorProvider2();

    public StorageChannelsCreator getChannelCreator();

    public StorageThreadNameProvider getThreadNameProvider();

    public StorageChannelThreadProvider getChannelThreadProvider();

    public StorageBackupThreadProvider getBackupThreadProvider();

    public StorageLockFileManagerThreadProvider getLockFileManagerThreadProvider();

    public StorageThreadProvider getThreadProvider();

    public StorageRequestTaskCreator getRequestTaskCreator();

    public StorageTypeDictionary getTypeDictionary();

    public StorageRootTypeIdProvider getRootTypeIdProvider();

    public StorageTimestampProvider getTimestampProvider();

    public StorageObjectIdRangeEvaluator getObjectIdRangeEvaluator();

    public StorageFileWriter.Provider getWriterProvider();

    public StorageGCZombieOidHandler getGCZombieOidHandler();

    public StorageRootOidSelector.Provider getRootOidSelectorProvider();

    public StorageObjectIdMarkQueue.Creator getOidMarkQueueCreator();

    public StorageEntityMarkMonitor.Creator getEntityMarkMonitorCreator();

    public StorageDataFileValidator.Creator getDataFileValidatorCreator();

    public BinaryEntityRawDataIterator.Provider getEntityDataIteratorProvider();

    public StorageEntityDataValidator.Creator getEntityDataValidatorCreator();

    public ProcessIdentityProvider getProcessIdentityProvider();

    public StorageLockFileSetup getLockFileSetup();

    public StorageLockFileSetup.Provider getLockFileSetupProvider();

    public StorageLockFileManager.Creator getLockFileManagerCreator();

    public StorageExceptionHandler getExceptionHandler();

    public StorageEventLogger getEventLogger();

    public StorageWriteController writeController();

    public StorageWriteController getWriteController();

    public StorageHousekeepingBroker housekeepingBroker();

    public StorageHousekeepingBroker getHousekeepingBroker();

    public F setConfiguration(StorageConfiguration var1);

    public F setOperationControllerCreator(StorageOperationController.Creator var1);

    public F setInitialDataFileNumberProvider(StorageInitialDataFileNumberProvider var1);

    public F setRequestAcceptorCreator(StorageRequestAcceptor.Creator var1);

    public F setTaskBrokerCreator(StorageTaskBroker.Creator var1);

    public F setDataChunkValidatorProvider(StorageDataChunkValidator.Provider var1);

    public F setDataChunkValidatorProvider2(StorageDataChunkValidator.Provider2 var1);

    public F setChannelCreator(StorageChannelsCreator var1);

    public F setThreadNameProvider(StorageThreadNameProvider var1);

    public F setChannelThreadProvider(StorageChannelThreadProvider var1);

    public F setBackupThreadProvider(StorageBackupThreadProvider var1);

    public F setLockFileManagerThreadProvider(StorageLockFileManagerThreadProvider var1);

    public F setThreadProvider(StorageThreadProvider var1);

    public F setTaskCreator(StorageRequestTaskCreator var1);

    public F setTypeDictionary(StorageTypeDictionary var1);

    public F setRootTypeIdProvider(StorageRootTypeIdProvider var1);

    public F setTimestampProvider(StorageTimestampProvider var1);

    public F setObjectIdRangeEvaluator(StorageObjectIdRangeEvaluator var1);

    public F setWriterProvider(StorageFileWriter.Provider var1);

    public F setGCZombieOidHandler(StorageGCZombieOidHandler var1);

    public F setRootOidSelectorProvider(StorageRootOidSelector.Provider var1);

    public F setOidMarkQueueCreator(StorageObjectIdMarkQueue.Creator var1);

    public F setEntityMarkMonitorCreator(StorageEntityMarkMonitor.Creator var1);

    public F setDataFileValidatorCreator(StorageDataFileValidator.Creator var1);

    public F setEntityDataIteratorProvider(BinaryEntityRawDataIterator.Provider var1);

    public F setEntityDataValidatorCreator(StorageEntityDataValidator.Creator var1);

    public F setProcessIdentityProvider(ProcessIdentityProvider var1);

    public F setLockFileSetup(StorageLockFileSetup var1);

    public F setLockFileSetupProvider(StorageLockFileSetup.Provider var1);

    public F setLockFileManagerCreator(StorageLockFileManager.Creator var1);

    public F setExceptionHandler(StorageExceptionHandler var1);

    public F setEventLogger(StorageEventLogger var1);

    public F setWriteController(StorageWriteController var1);

    public F setHousekeepingBroker(StorageHousekeepingBroker var1);

    public StorageSystem createStorageSystem();

    public static class Default<F extends Default<?>>
    extends InstanceDispatcher.Default
    implements StorageFoundation<F>,
    Unpersistable {
        private StorageConfiguration configuration;
        private StorageOperationController.Creator operationControllerCreator;
        private StorageInitialDataFileNumberProvider initialDataFileNumberProvider;
        private StorageRequestAcceptor.Creator requestAcceptorCreator;
        private StorageTaskBroker.Creator taskBrokerCreator;
        private StorageDataChunkValidator.Provider dataChunkValidatorProvider;
        private StorageDataChunkValidator.Provider2 dataChunkValidatorProvider2;
        private StorageChannelsCreator channelCreator;
        private StorageThreadNameProvider threadNameProvider;
        private StorageChannelThreadProvider channelThreadProvider;
        private StorageBackupThreadProvider backupThreadProvider;
        private ProcessIdentityProvider processIdentityProvider;
        private StorageLockFileManagerThreadProvider lockFileManagerThreadProvider;
        private StorageThreadProvider threadProvider;
        private StorageRequestTaskCreator requestTaskCreator;
        private StorageTypeDictionary typeDictionary;
        private StorageRootTypeIdProvider rootTypeIdProvider;
        private StorageTimestampProvider timestampProvider;
        private StorageObjectIdRangeEvaluator objectIdRangeEvaluator;
        private StorageFileWriter.Provider writerProvider;
        private StorageGCZombieOidHandler gCZombieOidHandler;
        private StorageRootOidSelector.Provider rootOidSelectorProvider;
        private StorageObjectIdMarkQueue.Creator oidMarkQueueCreator;
        private StorageEntityMarkMonitor.Creator entityMarkMonitorCreator;
        private StorageDataFileValidator.Creator dataFileValidatorCreator;
        private BinaryEntityRawDataIterator.Provider entityDataIteratorProvider;
        private StorageEntityDataValidator.Creator entityDataValidatorCreator;
        private StorageLockFileSetup lockFileSetup;
        private StorageLockFileSetup.Provider lockFileSetupProvider;
        private StorageLockFileManager.Creator lockFileManagerCreator;
        private StorageExceptionHandler exceptionHandler;
        private StorageEventLogger eventLogger;
        private StorageWriteController writeController;
        private StorageHousekeepingBroker housekeepingBroker;

        protected final F $() {
            return (F)this;
        }

        protected StorageGCZombieOidHandler ensureStorageGCZombieOidHandler() {
            return new StorageGCZombieOidHandler.Default();
        }

        protected StorageConfiguration ensureConfiguration() {
            return Storage.Configuration();
        }

        protected StorageOperationController.Creator ensureOperationControllerCreator() {
            return StorageOperationController.Provider();
        }

        protected StorageInitialDataFileNumberProvider ensureInitialDataFileNumberProvider() {
            return new StorageInitialDataFileNumberProvider.Default(1);
        }

        protected StorageDataFileEvaluator ensureStorageConfiguration() {
            return this.getConfiguration().dataFileEvaluator();
        }

        protected StorageRequestAcceptor.Creator ensureRequestAcceptorCreator() {
            return new StorageRequestAcceptor.Creator.Default();
        }

        protected StorageTaskBroker.Creator ensureTaskBrokerCreator() {
            return new StorageTaskBroker.Creator.Default();
        }

        protected StorageDataChunkValidator.Provider ensureDataChunkValidatorProvider() {
            return this.getDataChunkValidatorProvider2().provideDataChunkValidatorProvider(this);
        }

        protected StorageDataChunkValidator.Provider2 ensureDataChunkValidatorProvider2() {
            return new StorageDataChunkValidator.NoOp();
        }

        protected StorageChannelsCreator ensureChannelCreator() {
            return new StorageChannelsCreator.Default();
        }

        protected StorageThreadNameProvider ensureThreadNameProvider() {
            return StorageThreadNameProvider.Prefixer(String.valueOf(Persistence.engineName()) + '-');
        }

        protected StorageChannelThreadProvider ensureChannelThreadProvider() {
            return new StorageChannelThreadProvider.Default();
        }

        protected StorageBackupThreadProvider ensureBackupThreadProvider() {
            return StorageBackupThreadProvider.New();
        }

        protected ProcessIdentityProvider ensureProcessIdentityProvider() {
            return ProcessIdentityProvider.New();
        }

        protected StorageLockFileManagerThreadProvider ensureLockFileManagerThreadProvider() {
            return StorageLockFileManagerThreadProvider.New();
        }

        protected StorageThreadProvider ensureThreadProvider() {
            return StorageThreadProvider.New(this.getThreadNameProvider(), this.getChannelThreadProvider(), this.getBackupThreadProvider(), this.getLockFileManagerThreadProvider());
        }

        protected StorageRequestTaskCreator ensureRequestTaskCreator() {
            return new StorageRequestTaskCreator.Default(this.getTimestampProvider());
        }

        protected StorageTypeDictionary ensureTypeDictionary() {
            return new StorageTypeDictionary.Default(this.isByteOrderMismatch());
        }

        protected StorageChannelCountProvider ensureChannelCountProvider(int channelCount) {
            return new StorageChannelCountProvider.Default(channelCount);
        }

        protected StorageRootTypeIdProvider ensureRootTypeIdProvider() {
            throw new MissingFoundationPartException(StorageRootTypeIdProvider.class);
        }

        protected StorageTimestampProvider ensureTimestampProvider() {
            return new StorageTimestampProvider.Default();
        }

        protected StorageObjectIdRangeEvaluator ensureObjectIdRangeEvaluator() {
            return new StorageObjectIdRangeEvaluator.Default();
        }

        protected StorageFileWriter.Provider ensureWriterProvider() {
            return new StorageFileWriter.Provider.Default();
        }

        protected StorageRootOidSelector.Provider ensureRootOidSelectorProvider() {
            return new StorageRootOidSelector.Provider.Default();
        }

        protected StorageObjectIdMarkQueue.Creator ensureOidMarkQueueCreator() {
            return new StorageObjectIdMarkQueue.Creator.Default();
        }

        protected StorageEntityMarkMonitor.Creator ensureEntityMarkMonitorCreator() {
            return StorageEntityMarkMonitor.Creator();
        }

        protected StorageDataFileValidator.Creator ensureDataFileValidatorCreator() {
            return StorageDataFileValidator.Creator(this.getEntityDataIteratorProvider(), this.getEntityDataValidatorCreator());
        }

        protected BinaryEntityRawDataIterator.Provider ensureEntityDataIteratorProvider() {
            return BinaryEntityRawDataIterator.Provider();
        }

        protected StorageEntityDataValidator.Creator ensureEntityDataValidatorCreator() {
            return StorageEntityDataValidator.Creator();
        }

        protected StorageExceptionHandler ensureExceptionHandler() {
            return StorageExceptionHandler.New();
        }

        protected StorageEventLogger ensureEventLogger() {
            return StorageEventLogger.Default();
        }

        protected StorageLockFileSetup provideLockFileSetup() {
            StorageLockFileSetup.Provider lockFileSetupProvider = this.getLockFileSetupProvider();
            return lockFileSetupProvider == null ? null : lockFileSetupProvider.provideLockFileSetup(this);
        }

        protected StorageLockFileManager.Creator ensureLockFileManagerCreator() {
            return StorageLockFileManager.Creator();
        }

        protected ByteOrder ensureTargetByteOrder() {
            return ByteOrder.nativeOrder();
        }

        protected StorageWriteController ensureWriteController() {
            return StorageWriteController.Wrap((WriteController)this.getConfiguration().fileProvider().fileSystem());
        }

        protected StorageHousekeepingBroker ensureHousekeepingBroker() {
            return StorageHousekeepingBroker.New();
        }

        @Override
        public StorageOperationController.Creator getOperationControllerCreator() {
            if (this.operationControllerCreator == null) {
                this.operationControllerCreator = (StorageOperationController.Creator)this.dispatch(this.ensureOperationControllerCreator());
            }
            return this.operationControllerCreator;
        }

        @Override
        public StorageInitialDataFileNumberProvider getInitialDataFileNumberProvider() {
            if (this.initialDataFileNumberProvider == null) {
                this.initialDataFileNumberProvider = (StorageInitialDataFileNumberProvider)this.dispatch(this.ensureInitialDataFileNumberProvider());
            }
            return this.initialDataFileNumberProvider;
        }

        @Override
        public StorageRequestAcceptor.Creator getRequestAcceptorCreator() {
            if (this.requestAcceptorCreator == null) {
                this.requestAcceptorCreator = (StorageRequestAcceptor.Creator)this.dispatch(this.ensureRequestAcceptorCreator());
            }
            return this.requestAcceptorCreator;
        }

        @Override
        public StorageTaskBroker.Creator getTaskBrokerCreator() {
            if (this.taskBrokerCreator == null) {
                this.taskBrokerCreator = (StorageTaskBroker.Creator)this.dispatch(this.ensureTaskBrokerCreator());
            }
            return this.taskBrokerCreator;
        }

        @Override
        public StorageDataChunkValidator.Provider getDataChunkValidatorProvider() {
            if (this.dataChunkValidatorProvider == null) {
                this.dataChunkValidatorProvider = (StorageDataChunkValidator.Provider)this.dispatch(this.ensureDataChunkValidatorProvider());
            }
            return this.dataChunkValidatorProvider;
        }

        @Override
        public StorageDataChunkValidator.Provider2 getDataChunkValidatorProvider2() {
            if (this.dataChunkValidatorProvider2 == null) {
                this.dataChunkValidatorProvider2 = (StorageDataChunkValidator.Provider2)this.dispatch(this.ensureDataChunkValidatorProvider2());
            }
            return this.dataChunkValidatorProvider2;
        }

        @Override
        public StorageChannelsCreator getChannelCreator() {
            if (this.channelCreator == null) {
                this.channelCreator = (StorageChannelsCreator)this.dispatch(this.ensureChannelCreator());
            }
            return this.channelCreator;
        }

        @Override
        public StorageThreadNameProvider getThreadNameProvider() {
            if (this.threadNameProvider == null) {
                this.threadNameProvider = (StorageThreadNameProvider)this.dispatch(this.ensureThreadNameProvider());
            }
            return this.threadNameProvider;
        }

        @Override
        public StorageChannelThreadProvider getChannelThreadProvider() {
            if (this.channelThreadProvider == null) {
                this.channelThreadProvider = (StorageChannelThreadProvider)this.dispatch(this.ensureChannelThreadProvider());
            }
            return this.channelThreadProvider;
        }

        @Override
        public StorageBackupThreadProvider getBackupThreadProvider() {
            if (this.backupThreadProvider == null) {
                this.backupThreadProvider = (StorageBackupThreadProvider)this.dispatch(this.ensureBackupThreadProvider());
            }
            return this.backupThreadProvider;
        }

        @Override
        public ProcessIdentityProvider getProcessIdentityProvider() {
            if (this.processIdentityProvider == null) {
                this.processIdentityProvider = (ProcessIdentityProvider)this.dispatch(this.ensureProcessIdentityProvider());
            }
            return this.processIdentityProvider;
        }

        @Override
        public StorageLockFileManagerThreadProvider getLockFileManagerThreadProvider() {
            if (this.lockFileManagerThreadProvider == null) {
                this.lockFileManagerThreadProvider = (StorageLockFileManagerThreadProvider)this.dispatch(this.ensureLockFileManagerThreadProvider());
            }
            return this.lockFileManagerThreadProvider;
        }

        @Override
        public StorageThreadProvider getThreadProvider() {
            if (this.threadProvider == null) {
                this.threadProvider = (StorageThreadProvider)this.dispatch(this.ensureThreadProvider());
            }
            return this.threadProvider;
        }

        @Override
        public StorageRequestTaskCreator getRequestTaskCreator() {
            if (this.requestTaskCreator == null) {
                this.requestTaskCreator = (StorageRequestTaskCreator)this.dispatch(this.ensureRequestTaskCreator());
            }
            return this.requestTaskCreator;
        }

        @Override
        public StorageTypeDictionary getTypeDictionary() {
            if (this.typeDictionary == null) {
                this.typeDictionary = (StorageTypeDictionary)this.dispatch(this.ensureTypeDictionary());
            }
            return this.typeDictionary;
        }

        @Override
        public StorageRootTypeIdProvider getRootTypeIdProvider() {
            if (this.rootTypeIdProvider == null) {
                this.rootTypeIdProvider = (StorageRootTypeIdProvider)this.dispatch(this.ensureRootTypeIdProvider());
            }
            return this.rootTypeIdProvider;
        }

        @Override
        public StorageConfiguration getConfiguration() {
            if (this.configuration == null) {
                this.configuration = (StorageConfiguration)this.dispatch(this.ensureConfiguration());
            }
            return this.configuration;
        }

        @Override
        public StorageTimestampProvider getTimestampProvider() {
            if (this.timestampProvider == null) {
                this.timestampProvider = (StorageTimestampProvider)this.dispatch(this.ensureTimestampProvider());
            }
            return this.timestampProvider;
        }

        @Override
        public StorageObjectIdRangeEvaluator getObjectIdRangeEvaluator() {
            if (this.objectIdRangeEvaluator == null) {
                this.objectIdRangeEvaluator = (StorageObjectIdRangeEvaluator)this.dispatch(this.ensureObjectIdRangeEvaluator());
            }
            return this.objectIdRangeEvaluator;
        }

        @Override
        public StorageFileWriter.Provider getWriterProvider() {
            if (this.writerProvider == null) {
                this.writerProvider = (StorageFileWriter.Provider)this.dispatch(this.ensureWriterProvider());
            }
            return this.writerProvider;
        }

        @Override
        public StorageGCZombieOidHandler getGCZombieOidHandler() {
            if (this.gCZombieOidHandler == null) {
                this.gCZombieOidHandler = (StorageGCZombieOidHandler)this.dispatch(this.ensureStorageGCZombieOidHandler());
            }
            return this.gCZombieOidHandler;
        }

        @Override
        public StorageRootOidSelector.Provider getRootOidSelectorProvider() {
            if (this.rootOidSelectorProvider == null) {
                this.rootOidSelectorProvider = (StorageRootOidSelector.Provider)this.dispatch(this.ensureRootOidSelectorProvider());
            }
            return this.rootOidSelectorProvider;
        }

        @Override
        public StorageObjectIdMarkQueue.Creator getOidMarkQueueCreator() {
            if (this.oidMarkQueueCreator == null) {
                this.oidMarkQueueCreator = (StorageObjectIdMarkQueue.Creator)this.dispatch(this.ensureOidMarkQueueCreator());
            }
            return this.oidMarkQueueCreator;
        }

        @Override
        public StorageEntityMarkMonitor.Creator getEntityMarkMonitorCreator() {
            if (this.entityMarkMonitorCreator == null) {
                this.entityMarkMonitorCreator = (StorageEntityMarkMonitor.Creator)this.dispatch(this.ensureEntityMarkMonitorCreator());
            }
            return this.entityMarkMonitorCreator;
        }

        @Override
        public StorageDataFileValidator.Creator getDataFileValidatorCreator() {
            if (this.dataFileValidatorCreator == null) {
                this.dataFileValidatorCreator = (StorageDataFileValidator.Creator)this.dispatch(this.ensureDataFileValidatorCreator());
            }
            return this.dataFileValidatorCreator;
        }

        @Override
        public BinaryEntityRawDataIterator.Provider getEntityDataIteratorProvider() {
            if (this.entityDataIteratorProvider == null) {
                this.entityDataIteratorProvider = (BinaryEntityRawDataIterator.Provider)this.dispatch(this.ensureEntityDataIteratorProvider());
            }
            return this.entityDataIteratorProvider;
        }

        @Override
        public StorageEntityDataValidator.Creator getEntityDataValidatorCreator() {
            if (this.entityDataValidatorCreator == null) {
                this.entityDataValidatorCreator = (StorageEntityDataValidator.Creator)this.dispatch(this.ensureEntityDataValidatorCreator());
            }
            return this.entityDataValidatorCreator;
        }

        @Override
        public StorageLockFileSetup getLockFileSetup() {
            if (this.lockFileSetup == null) {
                this.lockFileSetup = (StorageLockFileSetup)this.dispatch(this.provideLockFileSetup());
            }
            return this.lockFileSetup;
        }

        @Override
        public StorageLockFileSetup.Provider getLockFileSetupProvider() {
            return this.lockFileSetupProvider;
        }

        @Override
        public StorageLockFileManager.Creator getLockFileManagerCreator() {
            if (this.lockFileManagerCreator == null) {
                this.lockFileManagerCreator = (StorageLockFileManager.Creator)this.dispatch(this.ensureLockFileManagerCreator());
            }
            return this.lockFileManagerCreator;
        }

        @Override
        public StorageExceptionHandler getExceptionHandler() {
            if (this.exceptionHandler == null) {
                this.exceptionHandler = (StorageExceptionHandler)this.dispatch(this.ensureExceptionHandler());
            }
            return this.exceptionHandler;
        }

        @Override
        public StorageEventLogger getEventLogger() {
            if (this.eventLogger == null) {
                this.eventLogger = (StorageEventLogger)this.dispatch(this.ensureEventLogger());
            }
            return this.eventLogger;
        }

        @Override
        public StorageWriteController writeController() {
            return this.writeController;
        }

        @Override
        public StorageWriteController getWriteController() {
            if (this.writeController == null) {
                this.writeController = (StorageWriteController)this.dispatch(this.ensureWriteController());
            }
            return this.writeController;
        }

        @Override
        public StorageHousekeepingBroker housekeepingBroker() {
            return this.housekeepingBroker;
        }

        @Override
        public StorageHousekeepingBroker getHousekeepingBroker() {
            if (this.housekeepingBroker == null) {
                this.housekeepingBroker = (StorageHousekeepingBroker)this.dispatch(this.ensureHousekeepingBroker());
            }
            return this.housekeepingBroker;
        }

        @Override
        public F setOperationControllerCreator(StorageOperationController.Creator operationControllerCreator) {
            this.operationControllerCreator = operationControllerCreator;
            return this.$();
        }

        @Override
        public F setInitialDataFileNumberProvider(StorageInitialDataFileNumberProvider initialDataFileNumberProvider) {
            this.initialDataFileNumberProvider = initialDataFileNumberProvider;
            return this.$();
        }

        @Override
        public F setRequestAcceptorCreator(StorageRequestAcceptor.Creator requestAcceptorCreator) {
            this.requestAcceptorCreator = requestAcceptorCreator;
            return this.$();
        }

        @Override
        public F setTaskBrokerCreator(StorageTaskBroker.Creator taskBrokerCreator) {
            this.taskBrokerCreator = taskBrokerCreator;
            return this.$();
        }

        @Override
        public F setDataChunkValidatorProvider(StorageDataChunkValidator.Provider dataChunkValidatorProvider) {
            this.dataChunkValidatorProvider = dataChunkValidatorProvider;
            return this.$();
        }

        @Override
        public F setDataChunkValidatorProvider2(StorageDataChunkValidator.Provider2 dataChunkValidatorProvider2) {
            this.dataChunkValidatorProvider2 = dataChunkValidatorProvider2;
            return this.$();
        }

        @Override
        public F setChannelCreator(StorageChannelsCreator channelCreator) {
            this.channelCreator = channelCreator;
            return this.$();
        }

        @Override
        public F setThreadNameProvider(StorageThreadNameProvider threadNameProvider) {
            this.threadNameProvider = threadNameProvider;
            return this.$();
        }

        @Override
        public F setChannelThreadProvider(StorageChannelThreadProvider channelThreadProvider) {
            this.channelThreadProvider = channelThreadProvider;
            return this.$();
        }

        @Override
        public F setBackupThreadProvider(StorageBackupThreadProvider backupThreadProvider) {
            this.backupThreadProvider = backupThreadProvider;
            return this.$();
        }

        @Override
        public F setLockFileManagerThreadProvider(StorageLockFileManagerThreadProvider lockFileManagerThreadProvider) {
            this.lockFileManagerThreadProvider = lockFileManagerThreadProvider;
            return this.$();
        }

        @Override
        public F setThreadProvider(StorageThreadProvider threadProvider) {
            this.threadProvider = threadProvider;
            return this.$();
        }

        @Override
        public F setTaskCreator(StorageRequestTaskCreator taskCreator) {
            this.requestTaskCreator = taskCreator;
            return this.$();
        }

        @Override
        public F setTypeDictionary(StorageTypeDictionary typeDictionary) {
            this.typeDictionary = typeDictionary;
            return this.$();
        }

        @Override
        public F setRootTypeIdProvider(StorageRootTypeIdProvider rootTypeIdProvider) {
            this.rootTypeIdProvider = rootTypeIdProvider;
            return this.$();
        }

        @Override
        public F setConfiguration(StorageConfiguration configuration) {
            this.configuration = configuration;
            return this.$();
        }

        @Override
        public F setTimestampProvider(StorageTimestampProvider timestampProvider) {
            this.timestampProvider = timestampProvider;
            return this.$();
        }

        @Override
        public F setObjectIdRangeEvaluator(StorageObjectIdRangeEvaluator objectIdRangeEvaluator) {
            this.objectIdRangeEvaluator = objectIdRangeEvaluator;
            return this.$();
        }

        @Override
        public F setWriterProvider(StorageFileWriter.Provider writerProvider) {
            this.writerProvider = writerProvider;
            return this.$();
        }

        @Override
        public F setGCZombieOidHandler(StorageGCZombieOidHandler gCZombieOidHandler) {
            this.gCZombieOidHandler = gCZombieOidHandler;
            return this.$();
        }

        @Override
        public F setRootOidSelectorProvider(StorageRootOidSelector.Provider rootOidSelectorProvider) {
            this.rootOidSelectorProvider = rootOidSelectorProvider;
            return this.$();
        }

        @Override
        public F setOidMarkQueueCreator(StorageObjectIdMarkQueue.Creator oidMarkQueueCreator) {
            this.oidMarkQueueCreator = oidMarkQueueCreator;
            return this.$();
        }

        @Override
        public F setEntityMarkMonitorCreator(StorageEntityMarkMonitor.Creator entityMarkMonitorCreator) {
            this.entityMarkMonitorCreator = entityMarkMonitorCreator;
            return this.$();
        }

        @Override
        public F setDataFileValidatorCreator(StorageDataFileValidator.Creator dataFileValidatorCreator) {
            this.dataFileValidatorCreator = dataFileValidatorCreator;
            return this.$();
        }

        @Override
        public F setEntityDataIteratorProvider(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider) {
            this.entityDataIteratorProvider = entityDataIteratorProvider;
            return this.$();
        }

        @Override
        public F setEntityDataValidatorCreator(StorageEntityDataValidator.Creator entityDataValidatorCreator) {
            this.entityDataValidatorCreator = entityDataValidatorCreator;
            return this.$();
        }

        @Override
        public F setProcessIdentityProvider(ProcessIdentityProvider processIdentityProvider) {
            this.processIdentityProvider = processIdentityProvider;
            return this.$();
        }

        @Override
        public F setLockFileSetup(StorageLockFileSetup lockFileSetup) {
            this.lockFileSetup = lockFileSetup;
            return this.$();
        }

        @Override
        public F setLockFileSetupProvider(StorageLockFileSetup.Provider lockFileSetupProvider) {
            this.lockFileSetupProvider = lockFileSetupProvider;
            return this.$();
        }

        @Override
        public F setLockFileManagerCreator(StorageLockFileManager.Creator lockFileManagerCreator) {
            this.lockFileManagerCreator = lockFileManagerCreator;
            return this.$();
        }

        @Override
        public F setExceptionHandler(StorageExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this.$();
        }

        @Override
        public F setEventLogger(StorageEventLogger eventLogger) {
            this.eventLogger = eventLogger;
            return this.$();
        }

        @Override
        public F setWriteController(StorageWriteController writeController) {
            this.writeController = writeController;
            return this.$();
        }

        @Override
        public F setHousekeepingBroker(StorageHousekeepingBroker housekeepingBroker) {
            this.housekeepingBroker = housekeepingBroker;
            return this.$();
        }

        public final boolean isByteOrderMismatch() {
            return false;
        }

        @Override
        public StorageSystem createStorageSystem() {
            return new StorageSystem.Default(this.getConfiguration(), this.getOperationControllerCreator(), this.getDataFileValidatorCreator(), this.getWriteController(), this.getHousekeepingBroker(), this.getWriterProvider(), this.getInitialDataFileNumberProvider(), this.getRequestAcceptorCreator(), this.getTaskBrokerCreator(), this.getDataChunkValidatorProvider(), this.getChannelCreator(), this.getThreadProvider(), this.getRequestTaskCreator(), this.getTypeDictionary(), this.getRootTypeIdProvider(), this.getTimestampProvider(), this.getObjectIdRangeEvaluator(), this.getGCZombieOidHandler(), this.getRootOidSelectorProvider(), this.getOidMarkQueueCreator(), this.getEntityMarkMonitorCreator(), this.isByteOrderMismatch(), this.getLockFileSetup(), this.getLockFileManagerCreator(), this.getExceptionHandler(), this.getEventLogger());
        }
    }
}

