/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageHousekeepingExecutor;

public interface StorageHousekeepingBroker {
    public boolean performIssuedFileCleanupCheck(StorageHousekeepingExecutor var1, long var2);

    public boolean performIssuedGarbageCollection(StorageHousekeepingExecutor var1, long var2);

    public boolean performIssuedEntityCacheCheck(StorageHousekeepingExecutor var1, long var2, StorageEntityCacheEvaluator var4);

    public boolean performFileCleanupCheck(StorageHousekeepingExecutor var1, long var2);

    public boolean performGarbageCollection(StorageHousekeepingExecutor var1, long var2);

    public boolean performEntityCacheCheck(StorageHousekeepingExecutor var1, long var2);

    public static StorageHousekeepingBroker New() {
        return new Default();
    }

    public static final class Default
    implements StorageHousekeepingBroker {
        Default() {
        }

        @Override
        public boolean performIssuedFileCleanupCheck(StorageHousekeepingExecutor executor, long nanoTimeBudget) {
            return executor.performIssuedFileCleanupCheck(nanoTimeBudget);
        }

        @Override
        public boolean performIssuedGarbageCollection(StorageHousekeepingExecutor executor, long nanoTimeBudget) {
            return executor.performIssuedGarbageCollection(nanoTimeBudget);
        }

        @Override
        public boolean performIssuedEntityCacheCheck(StorageHousekeepingExecutor executor, long nanoTimeBudget, StorageEntityCacheEvaluator evaluator) {
            return executor.performIssuedEntityCacheCheck(nanoTimeBudget, evaluator);
        }

        @Override
        public boolean performFileCleanupCheck(StorageHousekeepingExecutor executor, long nanoTimeBudget) {
            return executor.performFileCleanupCheck(nanoTimeBudget);
        }

        @Override
        public boolean performGarbageCollection(StorageHousekeepingExecutor executor, long nanoTimeBudget) {
            return executor.performGarbageCollection(nanoTimeBudget);
        }

        @Override
        public boolean performEntityCacheCheck(StorageHousekeepingExecutor executor, long nanoTimeBudget) {
            return executor.performEntityCacheCheck(nanoTimeBudget);
        }
    }
}

