/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.XUtilsCollection;
import one.microstream.collections.types.XGettingTable;
import one.microstream.storage.exceptions.StorageExceptionExportFailed;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelSynchronizingTask;
import one.microstream.storage.types.StorageEntity;
import one.microstream.storage.types.StorageEntityTypeExportFileProvider;
import one.microstream.storage.types.StorageEntityTypeExportStatistics;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageRequestTask;
import one.microstream.typing.KeyValue;

public interface StorageRequestTaskExportEntitiesByType
extends StorageRequestTask {
    public StorageEntityTypeExportStatistics result();

    public static final class Default
    extends StorageChannelSynchronizingTask.AbstractCompletingTask<StorageEntityTypeExportStatistics.ChannelStatistic>
    implements StorageRequestTaskExportEntitiesByType {
        private final Predicate<? super StorageEntityTypeHandler> isExportType;
        private final Function<? super StorageEntityTypeHandler, Predicate<? super StorageEntity>> predicateEntityProvider;
        private final StorageEntityTypeExportFileProvider fileProvider;
        private final StorageEntityTypeExportStatistics.ChannelStatistic[] channelResults;
        private BulkList<ExportItem> exportTypes;
        private StorageEntityTypeExportStatistics result;

        Default(long timestamp, int channelCount, StorageEntityTypeExportFileProvider fileProvider, Predicate<? super StorageEntityTypeHandler> isExportType, Function<? super StorageEntityTypeHandler, Predicate<? super StorageEntity>> predicateEntityProvider) {
            super(timestamp, channelCount);
            this.fileProvider = (StorageEntityTypeExportFileProvider)X.notNull((Object)fileProvider);
            this.isExportType = isExportType != null ? isExportType : e -> !e.isPrimitiveType();
            this.predicateEntityProvider = predicateEntityProvider != null ? predicateEntityProvider : t -> null;
            this.channelResults = new StorageEntityTypeExportStatistics.ChannelStatistic[channelCount];
        }

        Default(long timestamp, int channelCount, StorageEntityTypeExportFileProvider fileProvider, Predicate<? super StorageEntityTypeHandler> isExportType) {
            this(timestamp, channelCount, fileProvider, isExportType, null);
        }

        Default(long timestamp, int channelCount, StorageEntityTypeExportFileProvider fileProvider) {
            this(timestamp, channelCount, fileProvider, null, null);
        }

        final void acceptExportType(StorageEntityTypeHandler type) {
            if (!this.isExportType.test(type)) {
                return;
            }
            this.exportTypes.add((Object)new ExportItem(this.channelCount(), type, this.fileProvider.provideExportFile(type), this.predicateEntityProvider.apply(type)));
        }

        private synchronized BulkList<ExportItem> getExportTypes(StorageChannel channel) {
            if (this.exportTypes == null) {
                this.exportTypes = new BulkList();
                channel.typeDictionary().iterateTypeHandlers(this::acceptExportType);
            }
            return this.exportTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final StorageEntityTypeExportStatistics.ChannelStatistic internalProcessBy(StorageChannel channel) {
            EqHashTable typeMap = EqHashTable.New();
            BulkList<ExportItem> exportItems = this.getExportTypes(channel);
            for (ExportItem exportItem : exportItems) {
                try {
                    KeyValue<Long, Long> result;
                    ExportItem exportItem2 = exportItem;
                    synchronized (exportItem2) {
                        while (!exportItem.isCurrentChannel(channel)) {
                            exportItem.wait();
                        }
                    }
                    long tStart = System.nanoTime();
                    KeyValue<Long, Long> keyValue = result = exportItem.predicateEntity == null ? channel.exportTypeEntities(exportItem.type, exportItem.file) : channel.exportTypeEntities(exportItem.type, exportItem.file, exportItem.predicateEntity);
                    if (exportItem.isLastChannel(channel)) {
                        exportItem.cleanUp();
                    }
                    exportItem.incrementProgress();
                    if ((Long)result.value() == 0L) continue;
                    StorageEntityTypeExportStatistics.TypeStatistic.Default ts = new StorageEntityTypeExportStatistics.TypeStatistic.Default(exportItem.type.typeId(), exportItem.type.typeName(), (AFile)exportItem.file);
                    ts.update((Long)result.value(), (Long)result.key(), tStart, System.nanoTime());
                    typeMap.add((Object)exportItem.type.typeId(), (Object)ts);
                }
                catch (Exception e) {
                    throw new StorageExceptionExportFailed("Problem while exporting " + exportItem.type.typeName(), e);
                }
            }
            return new StorageEntityTypeExportStatistics.ChannelStatistic.Default(channel.channelIndex(), (XGettingTable<Long, StorageEntityTypeExportStatistics.TypeStatistic.Default>)typeMap);
        }

        @Override
        protected synchronized void succeed(StorageChannel channel, StorageEntityTypeExportStatistics.ChannelStatistic result) {
            this.channelResults[channel.channelIndex()] = result;
        }

        @Override
        protected final synchronized void cleanUp(StorageChannel channel) {
            if (this.exportTypes == null) {
                return;
            }
            for (ExportItem item : this.exportTypes) {
                item.cleanUp();
            }
            this.exportTypes = null;
        }

        @Override
        public synchronized StorageEntityTypeExportStatistics result() {
            if (this.result == null) {
                this.result = new StorageEntityTypeExportStatistics.Default((XGettingTable<Integer, ? extends StorageEntityTypeExportStatistics.ChannelStatistic>)XUtilsCollection.toTable((Object[])this.channelResults));
            }
            return this.result;
        }
    }

    public static final class ExportItem {
        final int lastChannelIndex;
        final AWritableFile file;
        final StorageEntityTypeHandler type;
        final Predicate<? super StorageEntity> predicateEntity;
        private final AtomicInteger currentChannel = new AtomicInteger();

        ExportItem(int channelCount, StorageEntityTypeHandler type, AWritableFile file, Predicate<? super StorageEntity> predicateEntity) {
            this.lastChannelIndex = channelCount - 1;
            this.file = file;
            this.type = type;
            this.predicateEntity = predicateEntity;
        }

        final synchronized void incrementProgress() {
            this.currentChannel.incrementAndGet();
            this.notifyAll();
        }

        final boolean isCurrentChannel(StorageChannel channel) {
            return this.currentChannel.get() == channel.channelIndex();
        }

        final boolean isLastChannel(StorageChannel channel) {
            return this.lastChannelIndex == channel.channelIndex();
        }

        final synchronized void cleanUp() {
            if (!this.file.isOpen()) {
                return;
            }
            if (this.file.isEmpty()) {
                this.file.delete();
            } else {
                this.file.close();
            }
            this.file.release();
        }
    }
}

