/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import one.microstream.X;
import one.microstream.afs.types.AFileSystem;
import one.microstream.meta.XDebug;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.Unpersistable;
import one.microstream.storage.exceptions.StorageExceptionInitialization;
import one.microstream.storage.exceptions.StorageExceptionNotAcceptingTasks;
import one.microstream.storage.exceptions.StorageExceptionNotRunning;
import one.microstream.storage.types.StorageActivePart;
import one.microstream.storage.types.StorageBackupHandler;
import one.microstream.storage.types.StorageBackupSetup;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageChannelTaskInitialize;
import one.microstream.storage.types.StorageChannelTaskShutdown;
import one.microstream.storage.types.StorageChannelsCreator;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageController;
import one.microstream.storage.types.StorageDataChunkValidator;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageDataFileValidator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityMarkMonitor;
import one.microstream.storage.types.StorageEventLogger;
import one.microstream.storage.types.StorageExceptionHandler;
import one.microstream.storage.types.StorageFileWriter;
import one.microstream.storage.types.StorageGCZombieOidHandler;
import one.microstream.storage.types.StorageHousekeepingBroker;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageIdAnalysis;
import one.microstream.storage.types.StorageInitialDataFileNumberProvider;
import one.microstream.storage.types.StorageKillable;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageLockFileManager;
import one.microstream.storage.types.StorageLockFileSetup;
import one.microstream.storage.types.StorageObjectIdMarkQueue;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestAcceptor;
import one.microstream.storage.types.StorageRequestTaskCreator;
import one.microstream.storage.types.StorageRootOidSelector;
import one.microstream.storage.types.StorageRootTypeIdProvider;
import one.microstream.storage.types.StorageTaskBroker;
import one.microstream.storage.types.StorageThreadProvider;
import one.microstream.storage.types.StorageTimestampProvider;
import one.microstream.storage.types.StorageTypeDictionary;
import one.microstream.storage.types.StorageWriteController;

public interface StorageSystem
extends StorageController {
    public StorageRequestAcceptor createRequestAcceptor();

    public StorageTypeDictionary typeDictionary();

    public StorageOperationController operationController();

    default public StorageChannelCountProvider channelCountProvider() {
        return this.operationController().channelCountProvider();
    }

    public StorageConfiguration configuration();

    default public AFileSystem fileSystem() {
        return this.configuration().fileProvider().fileSystem();
    }

    @Override
    public StorageSystem start();

    public StorageIdAnalysis initializationIdAnalysis();

    @Override
    public boolean shutdown();

    public StorageObjectIdRangeEvaluator objectIdRangeEvaluator();

    public static final class Default
    implements StorageSystem,
    Unpersistable,
    StorageKillable {
        private final StorageConfiguration configuration;
        private final StorageInitialDataFileNumberProvider initialDataFileNumberProvider;
        private final StorageDataFileEvaluator fileDissolver;
        private final StorageLiveFileProvider fileProvider;
        private final StorageWriteController writeController;
        private final StorageFileWriter.Provider writerProvider;
        private final StorageRequestAcceptor.Creator requestAcceptorCreator;
        private final StorageTaskBroker.Creator taskBrokerCreator;
        private final StorageDataChunkValidator.Provider dataChunkValidatorProvider;
        private final StorageChannelsCreator channelCreator;
        private final StorageThreadProvider threadProvider;
        private final StorageEntityCacheEvaluator entityCacheEvaluator;
        private final StorageRequestTaskCreator requestTaskCreator;
        private final StorageTypeDictionary typeDictionary;
        private final StorageOperationController operationController;
        private final StorageRootTypeIdProvider rootTypeIdProvider;
        private final StorageExceptionHandler exceptionHandler;
        private final StorageHousekeepingController housekeepingController;
        private final StorageHousekeepingBroker housekeepingBroker;
        private final StorageTimestampProvider timestampProvider;
        private final StorageObjectIdRangeEvaluator objectIdRangeEvaluator;
        private final StorageGCZombieOidHandler zombieOidHandler;
        private final StorageRootOidSelector.Provider rootOidSelectorProvider;
        private final StorageObjectIdMarkQueue.Creator oidMarkQueueCreator;
        private final StorageEntityMarkMonitor.Creator entityMarkMonitorCreator;
        private final StorageDataFileValidator.Creator backupDataFileValidatorCreator;
        private final StorageBackupSetup backupSetup;
        private final StorageLockFileSetup lockFileSetup;
        private final StorageLockFileManager.Creator lockFileManagerCreator;
        private final StorageEventLogger eventLogger;
        private final boolean switchByteOrder;
        private AtomicBoolean isStartingUp = new AtomicBoolean();
        private AtomicBoolean isShuttingDown = new AtomicBoolean();
        private final Object stateLock = new Object();
        private AtomicLong initializationTime = new AtomicLong();
        private AtomicLong operationModeTime = new AtomicLong();
        private volatile StorageTaskBroker taskbroker;
        private final ChannelKeeper[] channelKeepers;
        private StorageBackupHandler backupHandler;
        private Thread backupThread;
        private Thread lockFileManagerThread;
        private StorageIdAnalysis initializationIdAnalysis;

        public Default(StorageConfiguration storageConfiguration, StorageOperationController.Creator ocCreator, StorageDataFileValidator.Creator backupDataFileValidatorCreator, StorageWriteController writeController, StorageHousekeepingBroker housekeepingBroker, StorageFileWriter.Provider writerProvider, StorageInitialDataFileNumberProvider initialDataFileNumberProvider, StorageRequestAcceptor.Creator requestAcceptorCreator, StorageTaskBroker.Creator taskBrokerCreator, StorageDataChunkValidator.Provider dataChunkValidatorProvider, StorageChannelsCreator channelCreator, StorageThreadProvider threadProvider, StorageRequestTaskCreator requestTaskCreator, StorageTypeDictionary typeDictionary, StorageRootTypeIdProvider rootTypeIdProvider, StorageTimestampProvider timestampProvider, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, StorageGCZombieOidHandler zombieOidHandler, StorageRootOidSelector.Provider rootOidSelectorProvider, StorageObjectIdMarkQueue.Creator oidMarkQueueCreator, StorageEntityMarkMonitor.Creator entityMarkMonitorCreator, boolean switchByteOrder, StorageLockFileSetup lockFileSetup, StorageLockFileManager.Creator lockFileManagerCreator, StorageExceptionHandler exceptionHandler, StorageEventLogger eventLogger) {
            StorageChannelCountProvider ccp = storageConfiguration.channelCountProvider();
            int channelCount = ccp.getChannelCount();
            StorageChannelCountProvider.validateChannelCount(channelCount);
            this.channelKeepers = new ChannelKeeper[channelCount];
            this.configuration = (StorageConfiguration)X.notNull((Object)storageConfiguration);
            this.operationController = (StorageOperationController)X.notNull((Object)ocCreator.createOperationController(ccp, this));
            this.initialDataFileNumberProvider = (StorageInitialDataFileNumberProvider)X.notNull((Object)initialDataFileNumberProvider);
            this.fileDissolver = storageConfiguration.dataFileEvaluator();
            this.fileProvider = storageConfiguration.fileProvider();
            this.entityCacheEvaluator = storageConfiguration.entityCacheEvaluator();
            this.housekeepingController = storageConfiguration.housekeepingController();
            this.housekeepingBroker = (StorageHousekeepingBroker)X.notNull((Object)housekeepingBroker);
            this.requestAcceptorCreator = (StorageRequestAcceptor.Creator)X.notNull((Object)requestAcceptorCreator);
            this.taskBrokerCreator = (StorageTaskBroker.Creator)X.notNull((Object)taskBrokerCreator);
            this.dataChunkValidatorProvider = (StorageDataChunkValidator.Provider)X.notNull((Object)dataChunkValidatorProvider);
            this.channelCreator = (StorageChannelsCreator)X.notNull((Object)channelCreator);
            this.threadProvider = (StorageThreadProvider)X.notNull((Object)threadProvider);
            this.requestTaskCreator = (StorageRequestTaskCreator)X.notNull((Object)requestTaskCreator);
            this.typeDictionary = (StorageTypeDictionary)X.notNull((Object)typeDictionary);
            this.rootTypeIdProvider = (StorageRootTypeIdProvider)X.notNull((Object)rootTypeIdProvider);
            this.timestampProvider = (StorageTimestampProvider)X.notNull((Object)timestampProvider);
            this.objectIdRangeEvaluator = (StorageObjectIdRangeEvaluator)X.notNull((Object)objectIdRangeEvaluator);
            this.writeController = (StorageWriteController)X.notNull((Object)writeController);
            this.writerProvider = (StorageFileWriter.Provider)X.notNull((Object)writerProvider);
            this.zombieOidHandler = (StorageGCZombieOidHandler)X.notNull((Object)zombieOidHandler);
            this.rootOidSelectorProvider = (StorageRootOidSelector.Provider)X.notNull((Object)rootOidSelectorProvider);
            this.oidMarkQueueCreator = (StorageObjectIdMarkQueue.Creator)X.notNull((Object)oidMarkQueueCreator);
            this.entityMarkMonitorCreator = (StorageEntityMarkMonitor.Creator)X.notNull((Object)entityMarkMonitorCreator);
            this.exceptionHandler = (StorageExceptionHandler)X.notNull((Object)exceptionHandler);
            this.lockFileSetup = (StorageLockFileSetup)X.mayNull((Object)lockFileSetup);
            this.lockFileManagerCreator = (StorageLockFileManager.Creator)X.notNull((Object)lockFileManagerCreator);
            this.backupSetup = (StorageBackupSetup)X.mayNull((Object)storageConfiguration.backupSetup());
            this.backupDataFileValidatorCreator = (StorageDataFileValidator.Creator)X.notNull((Object)backupDataFileValidatorCreator);
            this.eventLogger = (StorageEventLogger)X.notNull((Object)eventLogger);
            this.switchByteOrder = switchByteOrder;
        }

        @Override
        public final StorageConfiguration configuration() {
            return this.configuration;
        }

        @Override
        public final boolean isRunning() {
            return this.isChannelProcessingEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isActive() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.isRunning() || this.hasActiveChannels() || this.backupHandler != null && this.backupHandler.isActive();
            }
        }

        private boolean hasActiveChannels() {
            ChannelKeeper[] channelKeeperArray = this.channelKeepers;
            int n = this.channelKeepers.length;
            int n2 = 0;
            while (n2 < n) {
                ChannelKeeper keeper = channelKeeperArray[n2];
                if (keeper.isActive()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isChannelProcessingEnabled() {
            Object object = this.stateLock;
            synchronized (object) {
                block4: {
                    if (!this.operationController.isChannelProcessingEnabled()) break block4;
                    return true;
                }
                return false;
            }
        }

        @Override
        public final boolean isAcceptingTasks() {
            return this.isChannelProcessingEnabled();
        }

        @Override
        public final boolean isStartingUp() {
            return this.isStartingUp.get();
        }

        @Override
        public final boolean isShuttingDown() {
            return this.isShuttingDown.get();
        }

        @Override
        public final long initializationTime() {
            return this.initializationTime.get();
        }

        @Override
        public final long operationModeTime() {
            return this.operationModeTime.get();
        }

        private void ensureRunning() {
            if (this.isRunning()) {
                return;
            }
            throw new StorageExceptionNotRunning();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StorageIdAnalysis startThreads(StorageChannelTaskInitialize initializingTask) throws InterruptedException {
            StorageChannelTaskInitialize storageChannelTaskInitialize = initializingTask;
            synchronized (storageChannelTaskInitialize) {
                ChannelKeeper[] channelKeeperArray = this.channelKeepers;
                int n = this.channelKeepers.length;
                int n2 = 0;
                while (n2 < n) {
                    ChannelKeeper keeper = channelKeeperArray[n2];
                    keeper.channelThread.start();
                    ++n2;
                }
                initializingTask.waitOnCompletion();
            }
            return initializingTask.idAnalysis();
        }

        private StorageBackupHandler provideBackupHandler() {
            if (this.backupHandler == null && this.backupSetup != null) {
                StorageDataFileValidator validator = this.backupDataFileValidatorCreator.createDataFileValidator(this.typeDictionary);
                this.backupHandler = this.backupSetup.setupHandler(this.operationController, this.writeController, validator);
            }
            return this.backupHandler;
        }

        private void startBackupThread() {
            StorageBackupHandler backupHandler = this.provideBackupHandler();
            if (backupHandler == null) {
                return;
            }
            if (!this.writeController.isBackupEnabled()) {
                return;
            }
            backupHandler.start();
            this.backupThread = this.threadProvider.provideBackupThread(backupHandler);
            this.backupThread.start();
        }

        private void initializeLockFileManager() {
            if (this.lockFileSetup == null || this.lockFileSetup.updateInterval() == 0L) {
                return;
            }
            StorageLockFileManager lockFileManager = this.lockFileManagerCreator.createLockFileManager(this.lockFileSetup, this.operationController);
            lockFileManager.start();
            this.lockFileManagerThread = this.threadProvider.provideLockFileManagerThread(lockFileManager);
        }

        private void startLockFileManagerThread() {
            if (this.lockFileManagerThread == null) {
                return;
            }
            this.lockFileManagerThread.start();
        }

        private void createChannels() {
            StorageFileWriter.Provider effectiveWriterProvider = this.dispatchWriterProvider();
            StorageChannel[] channels = this.channelCreator.createChannels(this.channelCount(), this.initialDataFileNumberProvider, this.exceptionHandler, this.fileDissolver, this.fileProvider, this.entityCacheEvaluator, this.typeDictionary, this.taskbroker, this.operationController, this.housekeepingBroker, this.housekeepingController, this.timestampProvider, this.writeController, effectiveWriterProvider, this.zombieOidHandler, this.rootOidSelectorProvider, this.oidMarkQueueCreator, this.entityMarkMonitorCreator, this.provideBackupHandler(), this.eventLogger, this.switchByteOrder, this.rootTypeIdProvider.provideRootTypeId());
            ChannelKeeper[] keepers = this.channelKeepers;
            int i = 0;
            while (i < channels.length) {
                keepers[i] = new ChannelKeeper(i, channels[i], this.threadProvider.provideChannelThread(channels[i]));
                ++i;
            }
        }

        private StorageFileWriter.Provider dispatchWriterProvider() {
            if (this.backupSetup == null) {
                return this.writerProvider;
            }
            return this.backupSetup.setupWriterProvider(this.writerProvider);
        }

        private int channelCount() {
            return this.channelKeepers.length;
        }

        private void internalStartUp() throws InterruptedException {
            this.initializeLockFileManager();
            this.taskbroker = this.taskBrokerCreator.createTaskBroker(this, this.requestTaskCreator);
            StorageChannelTaskInitialize task = this.taskbroker.issueChannelInitialization(this.operationController);
            this.createChannels();
            StorageIdAnalysis idAnalysis = this.startThreads(task);
            Long maxOid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.OID);
            this.objectIdRangeEvaluator.evaluateObjectIdRange(0L, maxOid == null ? 0L : maxOid);
            this.initializationIdAnalysis = idAnalysis;
            this.startLockFileManagerThread();
            this.startBackupThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalShutdown() throws InterruptedException {
            StorageChannelTaskShutdown task;
            if (this.taskbroker == null) {
                XDebug.println((String)"taskbroker is null");
                return;
            }
            this.shutdownBackup();
            StorageChannelTaskShutdown storageChannelTaskShutdown = task = this.taskbroker.issueChannelShutdown(this.operationController);
            synchronized (storageChannelTaskShutdown) {
                task.waitOnCompletion();
            }
            this.taskbroker = null;
        }

        @Override
        public final void checkAcceptingTasks() {
            if (this.isAcceptingTasks()) {
                return;
            }
            throw new StorageExceptionNotAcceptingTasks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Default start() {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.isRunning()) {
                    throw new StorageExceptionInitialization("already starting");
                }
                this.isStartingUp.set(true);
                try {
                    try {
                        this.initializationTime.set(System.currentTimeMillis());
                        this.internalStartUp();
                        this.operationModeTime.set(System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        this.operationController.deactivate();
                        throw new StorageExceptionInitialization(e);
                    }
                    catch (Throwable t) {
                        this.operationController.deactivate();
                        throw t;
                    }
                }
                finally {
                    this.isStartingUp.set(false);
                }
            }
            return this;
        }

        @Override
        public final StorageIdAnalysis initializationIdAnalysis() {
            return this.initializationIdAnalysis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean shutdown() {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.internalShutdown();
                    return true;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }

        @Override
        public final StorageTypeDictionary typeDictionary() {
            return this.typeDictionary;
        }

        @Override
        public StorageOperationController operationController() {
            return this.operationController;
        }

        @Override
        public StorageObjectIdRangeEvaluator objectIdRangeEvaluator() {
            return this.objectIdRangeEvaluator;
        }

        @Override
        public final StorageRequestAcceptor createRequestAcceptor() {
            this.ensureRunning();
            return this.requestAcceptorCreator.createRequestAcceptor(this.dataChunkValidatorProvider.provideDataChunkValidator(this.typeDictionary), this.taskbroker);
        }

        @Override
        public void killStorage(Throwable cause) {
            this.operationController.deactivate();
            if (this.backupHandler != null) {
                this.backupHandler.setRunning(false);
            }
        }

        private void shutdownBackup() throws InterruptedException {
            if (this.backupHandler != null) {
                this.backupHandler.stop();
                this.backupThread.join();
            }
        }

        static final class ChannelKeeper
        implements StorageActivePart {
            final int channelIndex;
            final StorageChannel channel;
            final Thread channelThread;

            ChannelKeeper(int channelIndex, StorageChannel channel, Thread thread) {
                this.channelIndex = channelIndex;
                this.channel = channel;
                this.channelThread = thread;
            }

            @Override
            public final boolean isActive() {
                return this.channel.isActive();
            }
        }
    }
}

