/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.nio.types.NioFileSystem;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AFileSystem;
import one.microstream.persistence.internal.PersistenceTypeDictionaryFileHandler;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageBackupDataFile;
import one.microstream.storage.types.StorageBackupTransactionsFile;
import one.microstream.storage.types.StorageDataFile;
import one.microstream.storage.types.StorageDirectoryStructureProvider;
import one.microstream.storage.types.StorageFileNameProvider;
import one.microstream.storage.types.StorageFileProvider;

public interface StorageBackupFileProvider
extends StorageFileProvider {
    default public StorageBackupDataFile provideBackupDataFile(StorageDataFile dataFile) {
        return this.provideBackupDataFile(dataFile.channelIndex(), dataFile.number());
    }

    public StorageBackupDataFile provideBackupDataFile(int var1, long var2);

    public StorageBackupTransactionsFile provideBackupTransactionsFile(int var1);

    public static StorageBackupFileProvider New() {
        return Storage.BackupFileProviderBuilder().createFileProvider();
    }

    public static StorageBackupFileProvider New(ADirectory storageDirectory) {
        return ((Builder)Storage.BackupFileProviderBuilder(storageDirectory.fileSystem()).setDirectory(storageDirectory)).createFileProvider();
    }

    public static Default New(ADirectory baseDirectory, ADirectory deletionDirectory, ADirectory truncationDirectory, StorageDirectoryStructureProvider structureProvider, StorageFileNameProvider fileNameProvider, PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator) {
        return new Default((ADirectory)X.notNull((Object)baseDirectory), (ADirectory)X.mayNull((Object)deletionDirectory), (ADirectory)X.mayNull((Object)truncationDirectory), (StorageDirectoryStructureProvider)X.notNull((Object)structureProvider), (StorageFileNameProvider)X.notNull((Object)fileNameProvider), (PersistenceTypeDictionaryFileHandler.Creator)X.notNull((Object)fileHandlerCreator));
    }

    public static Builder<?> Builder() {
        NioFileSystem nfs = Storage.DefaultFileSystem();
        return StorageBackupFileProvider.Builder((AFileSystem)nfs);
    }

    public static Builder<?> Builder(AFileSystem fileSystem) {
        return new Builder.Default((AFileSystem)X.notNull((Object)fileSystem));
    }

    public static interface Builder<B extends Builder<?>>
    extends StorageFileProvider.Builder<B> {
        @Override
        public StorageBackupFileProvider createFileProvider();

        public static class Default
        extends StorageFileProvider.Builder.Abstract<Default>
        implements Builder<Default> {
            Default(AFileSystem fileSystem) {
                super(fileSystem);
            }

            @Override
            protected ADirectory getBaseDirectory() {
                if (this.directory() != null) {
                    return this.directory();
                }
                throw new NullPointerException("Missing backup directory.");
            }

            @Override
            public StorageBackupFileProvider createFileProvider() {
                return StorageBackupFileProvider.New(this.getBaseDirectory(), this.getDeletionDirectory(), this.getTruncationDirectory(), this.getDirectoryStructureProvider(), this.getFileNameProvider(), this.getTypeDictionaryFileHandler());
            }
        }
    }

    public static final class Default
    extends StorageFileProvider.Abstract
    implements StorageBackupFileProvider {
        Default(ADirectory baseDirectory, ADirectory deletionDirectory, ADirectory truncationDirectory, StorageDirectoryStructureProvider structureProvider, StorageFileNameProvider fileNameProvider, PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator) {
            super(baseDirectory, deletionDirectory, truncationDirectory, structureProvider, fileNameProvider, fileHandlerCreator);
        }

        @Override
        public StorageBackupDataFile provideBackupDataFile(int channelIndex, long fileNumber) {
            AFile file = this.provideDataFile(channelIndex, fileNumber);
            return StorageBackupDataFile.New(file, channelIndex, fileNumber);
        }

        @Override
        public StorageBackupTransactionsFile provideBackupTransactionsFile(int channelIndex) {
            AFile file = this.provideTransactionsFile(channelIndex);
            return StorageBackupTransactionsFile.New(file, channelIndex);
        }
    }
}

