/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.concurrent.atomic.AtomicBoolean;
import one.microstream.X;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageTask;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface StorageChannelTask
extends StorageTask {
    public void incrementCompletionProgress();

    public void addProblem(int var1, Throwable var2);

    public static abstract class Abstract<R>
    extends StorageTask.Abstract
    implements StorageChannelTask {
        private static final Logger logger = Logging.getLogger(StorageChannelTask.class);
        private int remainingForCompletion;
        private int remainingForProcessing;
        private final AtomicBoolean hasProblems = new AtomicBoolean();
        private final Throwable[] problems;
        protected final StorageOperationController controller;

        public Abstract(long timestamp, int channelCount, StorageOperationController controller) {
            super(timestamp);
            this.remainingForProcessing = channelCount;
            this.remainingForCompletion = channelCount;
            this.controller = (StorageOperationController)X.notNull((Object)controller);
            this.problems = new Throwable[channelCount];
        }

        private void checkForProblems() {
            if (this.controller.hasDisruptions()) {
                throw new StorageException("Aborting after: ", (Throwable)this.controller.disruptions().first());
            }
            if (!this.hasProblems.get()) {
                return;
            }
            int i = 0;
            while (i < this.problems.length) {
                if (this.problems[i] != null) {
                    throw new StorageException("Problem in channel #" + i, this.problems[i]);
                }
                ++i;
            }
        }

        protected abstract R internalProcessBy(StorageChannel var1);

        protected abstract void complete(StorageChannel var1, R var2) throws InterruptedException;

        protected void finishProcessing() {
            this.incrementProcessingProgress();
        }

        protected void cleanUp(StorageChannel channel) {
        }

        protected final int channelCount() {
            return this.problems.length;
        }

        @Override
        public final synchronized void incrementCompletionProgress() {
            --this.remainingForCompletion;
            this.notifyAll();
        }

        @Override
        public final synchronized boolean isComplete() {
            return this.remainingForCompletion == 0;
        }

        @Override
        public final synchronized void waitOnCompletion() throws InterruptedException {
            while (this.remainingForCompletion > 0) {
                this.checkForProblems();
                this.wait(100L);
            }
            this.checkForProblems();
        }

        @Override
        public final boolean hasProblems() {
            return this.hasProblems.get();
        }

        @Override
        public final Throwable[] problems() {
            return this.problems;
        }

        @Override
        public final Throwable problemForChannel(StorageChannel channel) {
            return this.problems[channel.channelIndex()];
        }

        @Override
        public final void addProblem(int hashIndex, Throwable problem) {
            logger.error("Error occured in storage channel#{}", (Object)hashIndex, (Object)problem);
            if (this.problems[hashIndex] == null) {
                this.problems[hashIndex] = problem;
                this.hasProblems.set(true);
            } else {
                this.problems[hashIndex].addSuppressed(problem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isProcessed() {
            Throwable[] throwableArray = this.problems;
            synchronized (this.problems) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.remainingForProcessing == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitOnProcessing() throws InterruptedException {
            Throwable[] throwableArray = this.problems;
            synchronized (this.problems) {
                while (this.remainingForProcessing > 0) {
                    this.problems.wait();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void incrementProcessingProgress() {
            Throwable[] throwableArray = this.problems;
            synchronized (this.problems) {
                --this.remainingForProcessing;
                this.problems.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public final void processBy(StorageChannel storageChannel) throws InterruptedException {
            try {
                try {
                    try {
                        R result = this.internalProcessBy(storageChannel);
                    }
                    catch (Throwable e) {
                        this.addProblem(storageChannel.channelIndex(), e);
                        this.incrementCompletionProgress();
                        this.finishProcessing();
                        this.cleanUp(storageChannel);
                        return;
                    }
                }
                finally {
                    this.finishProcessing();
                }
            }
            finally {
                this.cleanUp(storageChannel);
            }
        }
    }
}

