/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.XSort;
import one.microstream.persistence.types.Persistence;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelSynchronizingTask;
import one.microstream.storage.types.StorageChannelTask;
import one.microstream.storage.types.StorageIdAnalysis;
import one.microstream.storage.types.StorageInventory;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageTransactionsAnalysis;

public interface StorageChannelTaskInitialize
extends StorageChannelTask {
    public StorageIdAnalysis idAnalysis();

    public static final class Default
    extends StorageChannelSynchronizingTask.AbstractCompletingTask<StorageInventory[]>
    implements StorageChannelTaskInitialize {
        private final StorageOperationController operationController;
        private final StorageInventory[] result;
        private Long consistentStoreTimestamp;
        private Long commonTaskHeadFileTimestamp;
        private long maxEntityObjectOid;
        private long maxEntityConstantOid;
        private long maxEntityTypeOid;
        private final EqHashEnum<Long> occuringTypeIds = EqHashEnum.New();

        public Default(long timestamp, int channelCount, StorageOperationController operationController) {
            super(timestamp, channelCount, operationController);
            this.operationController = (StorageOperationController)X.notNull((Object)operationController);
            this.result = new StorageInventory[channelCount];
        }

        private synchronized long getConsistentStoreTimestamp() {
            if (this.consistentStoreTimestamp == null) {
                this.checkAllTransactionsFilesMissing();
                this.consistentStoreTimestamp = this.determineConsistentStoreTimestamp();
            }
            return this.consistentStoreTimestamp;
        }

        private synchronized long getCommonTaskHeadFileTimestamp() {
            if (this.commonTaskHeadFileTimestamp == null) {
                long maxResultFileCount = 0L;
                StorageInventory[] storageInventoryArray = this.result;
                int n = this.result.length;
                int n2 = 0;
                while (n2 < n) {
                    StorageInventory si = storageInventoryArray[n2];
                    if (si.dataFiles().size() > maxResultFileCount) {
                        maxResultFileCount = si.dataFiles().size();
                    }
                    ++n2;
                }
                this.commonTaskHeadFileTimestamp = this.timestamp() + maxResultFileCount;
            }
            return this.commonTaskHeadFileTimestamp;
        }

        private synchronized void updateIdAnalysis(StorageIdAnalysis idAnalysis) {
            Long typeMaxCid;
            Long typeMaxOid;
            Long typeMaxTid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.TID);
            if (typeMaxTid != null && typeMaxTid >= this.maxEntityTypeOid) {
                this.maxEntityTypeOid = typeMaxTid;
            }
            if ((typeMaxOid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.OID)) != null && typeMaxOid >= this.maxEntityObjectOid) {
                this.maxEntityObjectOid = typeMaxOid;
            }
            if ((typeMaxCid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.CID)) != null && typeMaxCid >= this.maxEntityConstantOid) {
                this.maxEntityConstantOid = typeMaxCid;
            }
            this.occuringTypeIds.addAll(idAnalysis.occuringTypeIds());
            this.occuringTypeIds.sort(XSort::compare);
        }

        private boolean checkAllTransactionsFilesMissing() {
            boolean firstIsNull = this.result[0].transactionsFileAnalysis() == null;
            int i = 1;
            while (i < this.result.length) {
                if (this.result[i].transactionsFileAnalysis() == null != firstIsNull) {
                    throw new StorageExceptionConsistency("Mixed (inconsistent) transactions file existances.");
                }
                ++i;
            }
            return firstIsNull;
        }

        private long determineConsistentStoreTimestamp() {
            if (this.checkAllTransactionsFilesMissing()) {
                return 0L;
            }
            long firstChannelLatestTimestamp = this.result[0].transactionsFileAnalysis().headFileLatestTimestamp();
            StorageInventory[] storageInventoryArray = this.result;
            int n = this.result.length;
            int n2 = 0;
            while (n2 < n) {
                StorageInventory inventory = storageInventoryArray[n2];
                if (!Default.isCompatibleTimestamp(firstChannelLatestTimestamp, inventory.transactionsFileAnalysis())) {
                    return this.fallbackDetermineConsistentStoreTimestamp();
                }
                ++n2;
            }
            return firstChannelLatestTimestamp;
        }

        private long fallbackDetermineConsistentStoreTimestamp() {
            long firstChannelLastTimestamp = this.result[0].transactionsFileAnalysis().headFileLastConsistentStoreTimestamp();
            StorageInventory[] storageInventoryArray = this.result;
            int n = this.result.length;
            int n2 = 0;
            while (n2 < n) {
                StorageInventory inventory = storageInventoryArray[n2];
                if (!Default.isCompatibleTimestamp(firstChannelLastTimestamp, inventory.transactionsFileAnalysis())) {
                    throw new StorageExceptionConsistency("Inconsistent store timestamps between channels");
                }
                ++n2;
            }
            return firstChannelLastTimestamp;
        }

        private static boolean isCompatibleTimestamp(long candidatetimestamp, StorageTransactionsAnalysis transactionsFile) {
            return transactionsFile.headFileLatestTimestamp() == candidatetimestamp || transactionsFile.headFileLastConsistentStoreTimestamp() == candidatetimestamp;
        }

        @Override
        protected final StorageInventory[] internalProcessBy(StorageChannel channel) {
            this.result[channel.channelIndex()] = channel.readStorage();
            return this.result;
        }

        @Override
        protected final void succeed(StorageChannel channel, StorageInventory[] result) {
            StorageIdAnalysis idAnalysis = channel.initializeStorage(this.getCommonTaskHeadFileTimestamp(), this.getConsistentStoreTimestamp(), result[channel.channelIndex()]);
            this.updateIdAnalysis(idAnalysis);
            this.operationController.activate();
        }

        @Override
        protected final void fail(StorageChannel channel, StorageInventory[] result) {
        }

        @Override
        public synchronized StorageIdAnalysis idAnalysis() {
            return StorageIdAnalysis.New(this.maxEntityTypeOid, this.maxEntityObjectOid, this.maxEntityConstantOid, this.occuringTypeIds);
        }
    }
}

