/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryEntityRawDataAcceptor;
import one.microstream.persistence.binary.types.BinaryEntityRawDataIterator;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.types.StorageEntityDataValidator;
import one.microstream.storage.types.StorageFoundation;
import one.microstream.storage.types.StorageTypeDictionary;

public interface StorageDataChunkValidator {
    public void validateDataChunk(Binary var1);

    public static StorageDataChunkValidator New(BinaryEntityRawDataIterator entityDataIterator, StorageEntityDataValidator entityDataValidator) {
        return new Default((BinaryEntityRawDataIterator)X.notNull((Object)entityDataIterator), (StorageEntityDataValidator)X.notNull((Object)entityDataValidator));
    }

    public static Provider Provider(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator) {
        return new Provider.Default((BinaryEntityRawDataIterator.Provider)X.notNull((Object)entityDataIteratorProvider), (StorageEntityDataValidator.Creator)X.notNull((Object)entityDataValidatorCreator));
    }

    public static Provider Wrap(StorageDataChunkValidator validator) {
        return new Provider.Transient((StorageDataChunkValidator)X.notNull((Object)validator));
    }

    public static Provider2 Wrap2(StorageDataChunkValidator validator) {
        return StorageDataChunkValidator.Wrap2(StorageDataChunkValidator.Wrap((StorageDataChunkValidator)X.notNull((Object)validator)));
    }

    public static Provider2 Wrap2(Provider provider) {
        return new Provider2.Transient((Provider)X.notNull((Object)provider));
    }

    public static Provider2 Provider2() {
        return new Provider2.Default();
    }

    public static final class Default
    implements StorageDataChunkValidator {
        private final BinaryEntityRawDataIterator entityDataIterator;
        private final StorageEntityDataValidator entityDataValidator;

        Default(BinaryEntityRawDataIterator entityDataIterator, StorageEntityDataValidator entityDataValidator) {
            this.entityDataIterator = entityDataIterator;
            this.entityDataValidator = entityDataValidator;
        }

        @Override
        public void validateDataChunk(Binary data) {
            data.iterateChannelChunks(this::iterateChannelChunk);
        }

        private void iterateChannelChunk(Binary cc) {
            BinaryEntityRawDataIterator iterator = this.entityDataIterator;
            StorageEntityDataValidator validator = this.entityDataValidator;
            ByteBuffer[] byteBufferArray = cc.buffers();
            int n = byteBufferArray.length;
            int n2 = 0;
            while (n2 < n) {
                ByteBuffer bb = byteBufferArray[n2];
                long remainingLength = iterator.iterateEntityRawData(XMemory.getDirectByteBufferAddress((ByteBuffer)bb), XMemory.getDirectByteBufferAddress((ByteBuffer)bb) + (long)bb.limit(), (BinaryEntityRawDataAcceptor)validator);
                if (remainingLength != 0L) {
                    throw new StorageExceptionConsistency("Entity data chunk inconsistency: " + remainingLength + " remaining bytes of " + bb.limit());
                }
                ++n2;
            }
        }
    }

    public static final class NoOp
    implements StorageDataChunkValidator,
    Provider,
    Provider2 {
        @Override
        public final StorageDataChunkValidator provideDataChunkValidator(StorageTypeDictionary typeDictionary) {
            return this;
        }

        @Override
        public final void validateDataChunk(Binary data) {
        }

        @Override
        public final Provider provideDataChunkValidatorProvider(StorageFoundation<?> foundation) {
            return this;
        }
    }

    public static interface Provider {
        public StorageDataChunkValidator provideDataChunkValidator(StorageTypeDictionary var1);

        public static final class Default
        implements Provider {
            private final BinaryEntityRawDataIterator.Provider entityDataIteratorProvider;
            private final StorageEntityDataValidator.Creator entityDataValidatorCreator;

            Default(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator) {
                this.entityDataIteratorProvider = entityDataIteratorProvider;
                this.entityDataValidatorCreator = entityDataValidatorCreator;
            }

            @Override
            public final StorageDataChunkValidator provideDataChunkValidator(StorageTypeDictionary typeDictionary) {
                return StorageDataChunkValidator.New(this.entityDataIteratorProvider.provideEntityDataIterator(), this.entityDataValidatorCreator.createDataFileValidator(typeDictionary));
            }
        }

        public static final class Transient
        implements Provider {
            private final StorageDataChunkValidator validator;

            Transient(StorageDataChunkValidator validator) {
                this.validator = validator;
            }

            @Override
            public StorageDataChunkValidator provideDataChunkValidator(StorageTypeDictionary typeDictionary) {
                return this.validator;
            }
        }
    }

    public static interface Provider2 {
        public Provider provideDataChunkValidatorProvider(StorageFoundation<?> var1);

        public static final class Default
        implements Provider2 {
            @Override
            public Provider provideDataChunkValidatorProvider(StorageFoundation<?> foundation) {
                return StorageDataChunkValidator.Provider(foundation.getEntityDataIteratorProvider(), foundation.getEntityDataValidatorCreator());
            }
        }

        public static final class Transient
        implements Provider2 {
            private final Provider provider;

            Transient(Provider provider) {
                this.provider = provider;
            }

            @Override
            public Provider provideDataChunkValidatorProvider(StorageFoundation<?> foundation) {
                return this.provider;
            }
        }
    }
}

