/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.persistence.binary.types.BinaryEntityRawDataIterator;
import one.microstream.storage.exceptions.StorageExceptionIncompleteValidation;
import one.microstream.storage.types.StorageDataFile;
import one.microstream.storage.types.StorageEntityDataValidator;
import one.microstream.storage.types.StorageFileEntityDataIterator;
import one.microstream.storage.types.StorageTypeDictionary;

public interface StorageDataFileValidator {
    public void validateFile(StorageDataFile var1, long var2, long var4);

    default public void validateFile(StorageDataFile file) {
        this.validateFile(file, 0L, file.size());
    }

    public static StorageDataFileValidator New(BinaryEntityRawDataIterator entityDataIterator, StorageEntityDataValidator entityDataValidator, StorageFileEntityDataIterator fileIterator) {
        return new Default((BinaryEntityRawDataIterator)X.notNull((Object)entityDataIterator), (StorageEntityDataValidator)X.notNull((Object)entityDataValidator), (StorageFileEntityDataIterator)X.notNull((Object)fileIterator));
    }

    public static Creator Creator(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator, StorageTypeDictionary storageTypeDictionary) {
        return new Creator.Default(entityDataIteratorProvider, entityDataValidatorCreator, storageTypeDictionary);
    }

    public static interface Creator {
        public StorageDataFileValidator createDataFileValidator();

        public static class Default
        implements Creator {
            private final BinaryEntityRawDataIterator.Provider entityDataIteratorProvider;
            private final StorageEntityDataValidator.Creator entityDataValidatorCreator;
            private final StorageTypeDictionary storageTypeDictionary;

            Default(BinaryEntityRawDataIterator.Provider entityDataIteratorProvider, StorageEntityDataValidator.Creator entityDataValidatorCreator, StorageTypeDictionary storageTypeDictionary) {
                this.entityDataIteratorProvider = entityDataIteratorProvider;
                this.entityDataValidatorCreator = entityDataValidatorCreator;
                this.storageTypeDictionary = storageTypeDictionary;
            }

            @Override
            public StorageDataFileValidator createDataFileValidator() {
                return StorageDataFileValidator.New(this.entityDataIteratorProvider.provideEntityDataIterator(), this.entityDataValidatorCreator.createDataFileValidator(this.storageTypeDictionary), StorageFileEntityDataIterator.New());
            }
        }
    }

    public static class Default
    implements StorageDataFileValidator {
        private final BinaryEntityRawDataIterator entityDataIterator;
        private final StorageEntityDataValidator entityDataValidator;
        private final StorageFileEntityDataIterator fileIterator;

        protected Default(BinaryEntityRawDataIterator entityDataIterator, StorageEntityDataValidator entityDataValidator, StorageFileEntityDataIterator fileIterator) {
            this.entityDataIterator = (BinaryEntityRawDataIterator)X.notNull((Object)entityDataIterator);
            this.entityDataValidator = (StorageEntityDataValidator)X.notNull((Object)entityDataValidator);
            this.fileIterator = (StorageFileEntityDataIterator)X.notNull((Object)fileIterator);
        }

        @Override
        public void validateFile(StorageDataFile file, long fileOffset, long iterationLength) {
            long remainingLength = this.fileIterator.iterateEntityData(file, fileOffset, iterationLength, this.entityDataIterator, this.entityDataValidator);
            if (remainingLength != 0L) {
                throw new StorageExceptionIncompleteValidation(String.valueOf(remainingLength) + " remaining bytes of " + iterationLength + " total cannot be validated" + " in file " + file.identifier() + " at offset " + fileOffset);
            }
        }
    }
}

