/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Supplier;
import one.microstream.chars.VarString;
import one.microstream.math.XMath;
import one.microstream.persistence.types.PersistenceObjectIdAcceptor;
import one.microstream.reference.Swizzling;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.types.StorageEntityCache;
import one.microstream.storage.types.StorageEventLogger;
import one.microstream.storage.types.StorageObjectIdMarkQueue;
import one.microstream.storage.types.StorageReferenceMarker;
import one.microstream.storage.types.StorageRootOidSelector;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface StorageEntityMarkMonitor
extends PersistenceObjectIdAcceptor {
    public void signalPendingStoreUpdate(StorageEntityCache<?> var1);

    public void resetCompletion();

    public void advanceMarking(StorageObjectIdMarkQueue var1, int var2);

    public void clearPendingStoreUpdate(StorageEntityCache<?> var1);

    public boolean isComplete(StorageEntityCache<?> var1);

    public boolean needsSweep(StorageEntityCache<?> var1);

    public boolean isPendingSweep(StorageEntityCache<?> var1);

    public void completeSweep(StorageEntityCache<?> var1, StorageRootOidSelector var2, long var3);

    public boolean isMarkingComplete();

    public StorageReferenceMarker provideReferenceMarker(StorageEntityCache<?> var1);

    public void enqueue(StorageObjectIdMarkQueue var1, long var2);

    public void reset();

    public static Creator Creator() {
        return StorageEntityMarkMonitor.Creator(Creator.Defaults.defaultReferenceCacheLength());
    }

    public static Creator Creator(int referenceCacheLength) {
        return new Creator.Default(XMath.positive((int)referenceCacheLength));
    }

    public static interface Creator {
        public StorageEntityMarkMonitor createEntityMarkMonitor(StorageObjectIdMarkQueue[] var1, StorageEventLogger var2);

        public static final class Default
        implements Creator {
            private final int referenceCacheLength;

            Default(int referenceCacheLength) {
                this.referenceCacheLength = referenceCacheLength;
            }

            @Override
            public StorageEntityMarkMonitor createEntityMarkMonitor(StorageObjectIdMarkQueue[] objectIdMarkQueues, StorageEventLogger eventLogger) {
                return new one.microstream.storage.types.StorageEntityMarkMonitor$Default((StorageObjectIdMarkQueue[])objectIdMarkQueues.clone(), eventLogger, this.referenceCacheLength);
            }
        }

        public static interface Defaults {
            public static int defaultReferenceCacheLength() {
                return 100;
            }
        }
    }

    public static final class Default
    implements StorageEntityMarkMonitor,
    StorageReferenceMarker {
        private static final Logger logger = Logging.getLogger(Default.class);
        private final StorageEventLogger eventLogger;
        private final int channelCount;
        private final int channelHash;
        private final int referenceCacheLength;
        private final StorageObjectIdMarkQueue[] oidMarkQueues;
        private final long[] channelRootOids;
        private final StorageReferenceMarker[] referenceMarkers;
        private long pendingMarksCount;
        private final boolean[] pendingStoreUpdates;
        private int pendingStoreUpdateCount;
        private final boolean[] needsSweep;
        private int sweepingChannelCount;
        private long sweepGeneration;
        private long lastSweepStart;
        private long lastSweepEnd;
        private long gcHotGeneration;
        private long gcColdGeneration;
        private long lastGcHotCompletion;
        private long lastGcColdCompletion;
        private boolean gcHotPhaseComplete;
        private boolean gcColdPhaseComplete;

        Default(StorageObjectIdMarkQueue[] oidMarkQueues, StorageEventLogger eventLogger, int referenceCacheLength) {
            this.eventLogger = eventLogger;
            this.oidMarkQueues = oidMarkQueues;
            this.referenceCacheLength = referenceCacheLength;
            this.channelCount = oidMarkQueues.length;
            this.channelHash = this.channelCount - 1;
            this.pendingStoreUpdates = new boolean[this.channelCount];
            this.needsSweep = new boolean[this.channelCount];
            this.channelRootOids = new long[this.channelCount];
            this.referenceMarkers = new StorageReferenceMarker[this.channelCount];
            this.initialize();
        }

        private void initializeMarkQueues() {
            int i = 0;
            while (i < this.oidMarkQueues.length) {
                this.oidMarkQueues[i].reset();
                ++i;
            }
        }

        private void initializeChannelRootIds() {
            int i = 0;
            while (i < this.channelRootOids.length) {
                this.channelRootOids[i] = Swizzling.nullId();
                ++i;
            }
        }

        private void initializePendingStoreUpdates() {
            int i = 0;
            while (i < this.pendingStoreUpdates.length) {
                this.pendingStoreUpdates[i] = false;
                ++i;
            }
            this.pendingMarksCount = 0L;
            this.pendingStoreUpdateCount = 0;
        }

        private void initializeSweepingState() {
            int i = 0;
            while (i < this.needsSweep.length) {
                this.needsSweep[i] = false;
                ++i;
            }
            this.sweepingChannelCount = 0;
        }

        private void initializeCompletionState() {
            this.gcHotPhaseComplete = true;
            this.gcColdPhaseComplete = true;
        }

        private void initializeGenerationalState() {
            this.sweepGeneration = 0L;
            this.lastSweepStart = 0L;
            this.lastSweepEnd = 0L;
            this.gcHotGeneration = 0L;
            this.gcColdGeneration = 0L;
            this.lastGcHotCompletion = 0L;
            this.lastGcColdCompletion = 0L;
        }

        private final void initialize() {
            this.initializeMarkQueues();
            this.initializeChannelRootIds();
            this.initializePendingStoreUpdates();
            this.initializeSweepingState();
            this.initializeGenerationalState();
            this.initializeCompletionState();
        }

        @Override
        public final synchronized void reset() {
            this.initialize();
            this.synchResetReferenceMarkers();
        }

        private void synchResetReferenceMarkers() {
            int i = 0;
            while (i < this.referenceMarkers.length) {
                if (this.referenceMarkers[i] != null) {
                    this.referenceMarkers[i].reset();
                }
                ++i;
            }
        }

        private synchronized void incrementPendingMarksCount() {
            ++this.pendingMarksCount;
        }

        @Override
        public final synchronized boolean isMarkingComplete() {
            return this.pendingMarksCount == 0L && this.pendingStoreUpdateCount == 0;
        }

        @Override
        public final synchronized void advanceMarking(StorageObjectIdMarkQueue oidMarkQueue, int amount) {
            if (this.pendingMarksCount < (long)amount) {
                throw new StorageException("pending marks count (" + this.pendingMarksCount + ") is smaller than the number to be advanced (" + amount + ").");
            }
            oidMarkQueue.advanceTail(amount);
            this.pendingMarksCount -= (long)amount;
        }

        @Override
        public final synchronized void signalPendingStoreUpdate(StorageEntityCache<?> channel) {
            if (!this.pendingStoreUpdates[channel.channelIndex()]) {
                this.pendingStoreUpdates[channel.channelIndex()] = true;
                ++this.pendingStoreUpdateCount;
            }
        }

        @Override
        public final synchronized void clearPendingStoreUpdate(StorageEntityCache<?> channel) {
            if (this.pendingStoreUpdates[channel.channelIndex()]) {
                this.pendingStoreUpdates[channel.channelIndex()] = false;
                --this.pendingStoreUpdateCount;
            }
        }

        private synchronized void advanceGcCompletion() {
            if (this.gcColdPhaseComplete) {
                logger.debug("GC not needed");
                this.eventLogger.logGarbageCollectorNotNeeded();
                return;
            }
            if (this.gcHotPhaseComplete) {
                this.gcColdPhaseComplete = true;
                this.lastGcColdCompletion = System.currentTimeMillis();
                ++this.gcColdGeneration;
                logger.debug("Storage GC completed #{} @ {}", (Object)this.gcColdGeneration, (Object)this.lastGcColdCompletion);
                this.eventLogger.logGarbageCollectorCompleted(this.gcColdGeneration, this.lastGcColdCompletion);
            } else {
                this.gcHotPhaseComplete = true;
                this.lastGcHotCompletion = System.currentTimeMillis();
                ++this.gcHotGeneration;
                logger.debug("Storage GC completed hot phase #{} @ {}", (Object)this.gcHotGeneration, (Object)this.lastGcHotCompletion);
                this.eventLogger.logGarbageCollectorCompletedHotPhase(this.gcHotGeneration, this.lastGcHotCompletion);
            }
        }

        private synchronized boolean callToSweepRequired() {
            if (this.sweepingChannelCount > 0) {
                return false;
            }
            if (!this.isMarkingComplete()) {
                return false;
            }
            this.lastSweepStart = System.currentTimeMillis();
            this.resetChannelRootIds();
            this.resetMarkQueues();
            this.initiateSweep();
            return true;
        }

        @Override
        public final synchronized boolean needsSweep(StorageEntityCache<?> channel) {
            return this.isPendingSweep(channel) || this.callToSweepRequired();
        }

        @Override
        public final synchronized boolean isPendingSweep(StorageEntityCache<?> channel) {
            return this.needsSweep[channel.channelIndex()];
        }

        @Override
        public final synchronized void completeSweep(StorageEntityCache<?> channel, StorageRootOidSelector rootOidSelector, long channelRootOid) {
            this.channelRootOids[channel.channelIndex()] = channelRootOid;
            this.needsSweep[channel.channelIndex()] = false;
            logger.debug("StorageChannel#{} completed sweeping", (Object)channel.channelIndex());
            this.eventLogger.logGarbageCollectorSweepingComplete(channel);
            if (--this.sweepingChannelCount == 0) {
                this.lastSweepEnd = System.currentTimeMillis();
                ++this.sweepGeneration;
                this.advanceGcCompletion();
                this.determineAndEnqueueRootOid(rootOidSelector);
            }
        }

        final synchronized void resetChannelRootIds() {
            this.initializeChannelRootIds();
        }

        final synchronized void resetMarkQueues() {
            int i = 0;
            while (i < this.oidMarkQueues.length) {
                if (this.oidMarkQueues[i].hasElements()) {
                    throw new StorageException("ObjectId mark queue for channel " + i + " still has elements.");
                }
                this.oidMarkQueues[i].reset();
                ++i;
            }
        }

        final synchronized void initiateSweep() {
            int i = 0;
            while (i < this.needsSweep.length) {
                this.needsSweep[i] = true;
                ++i;
            }
            this.sweepingChannelCount = this.needsSweep.length;
        }

        final synchronized void determineAndEnqueueRootOid(StorageRootOidSelector rootObjectIdSelector) {
            rootObjectIdSelector.resetGlobal();
            int i = 0;
            while (i < this.channelRootOids.length) {
                rootObjectIdSelector.acceptGlobal(this.channelRootOids[i]);
                ++i;
            }
            long currentMaxRootObjectId = rootObjectIdSelector.yieldGlobal();
            if (currentMaxRootObjectId == Swizzling.nullId()) {
                return;
            }
            this.acceptObjectId(currentMaxRootObjectId);
        }

        public final void acceptObjectId(long objectId) {
            if (objectId == Swizzling.nullId()) {
                return;
            }
            this.enqueue(this.oidMarkQueues[(int)(objectId & (long)this.channelHash)], objectId);
        }

        @Override
        public final void enqueue(StorageObjectIdMarkQueue objectIdMarkQueue, long objectId) {
            this.incrementPendingMarksCount();
            objectIdMarkQueue.enqueue(objectId);
        }

        @Override
        public final boolean tryFlush() {
            return false;
        }

        @Override
        public final StorageReferenceMarker provideReferenceMarker(StorageEntityCache<?> channel) {
            if (this.referenceMarkers[channel.channelIndex()] != null) {
                throw new StorageException(String.valueOf(StorageReferenceMarker.class.getSimpleName()) + " for channel #" + channel.channelIndex() + " already exists.");
            }
            CachingReferenceMarker cachingReferenceMarker = new CachingReferenceMarker(this, this.channelCount, this.referenceCacheLength);
            this.referenceMarkers[channel.channelIndex()] = cachingReferenceMarker;
            return cachingReferenceMarker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void enqueueBulk(ObjectIds[] oidsPerChannel) {
            Object e;
            long totalSize = 0L;
            ObjectIds[] objectIdsArray = oidsPerChannel;
            int n = oidsPerChannel.length;
            int n2 = 0;
            while (n2 < n) {
                e = objectIdsArray[n2];
                totalSize += (long)e.size();
                ++n2;
            }
            e = this;
            synchronized (e) {
                this.pendingMarksCount += totalSize;
            }
            StorageObjectIdMarkQueue[] oidMarkQueues = this.oidMarkQueues;
            int i = 0;
            while (i < oidsPerChannel.length) {
                if (oidsPerChannel[i].size() != 0) {
                    oidMarkQueues[i].enqueueBulk(oidsPerChannel[i].objectIds(), oidsPerChannel[i].size());
                }
                ++i;
            }
        }

        @Override
        public final synchronized void resetCompletion() {
            this.gcColdPhaseComplete = false;
            this.gcHotPhaseComplete = false;
        }

        @Override
        public final synchronized boolean isComplete(StorageEntityCache<?> channel) {
            return this.gcColdPhaseComplete || this.gcHotPhaseComplete && this.sweepingChannelCount > 0 && !this.needsSweep[channel.channelIndex()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized <T> T lockAllMarkQueues(int currentIndex, Supplier<T> logic) {
            if (currentIndex >= 0) {
                StorageObjectIdMarkQueue storageObjectIdMarkQueue = this.oidMarkQueues[currentIndex];
                synchronized (storageObjectIdMarkQueue) {
                    return this.lockAllMarkQueues(currentIndex - 1, logic);
                }
            }
            return logic.get();
        }

        public synchronized String DEBUG_state() {
            return this.lockAllMarkQueues(this.channelHash, () -> {
                VarString vs = VarString.New((String)"GC state");
                vs.lf().padLeft(Long.toString(this.pendingMarksCount), 10, ' ').add(" pending marks count");
                int i = 0;
                while (i < this.oidMarkQueues.length) {
                    vs.lf().padLeft(Long.toString(this.oidMarkQueues[i].size()), 10, ' ').add(" in channel #" + i);
                    ++i;
                }
                vs.lf().lf().add("Hot  complete: ").add(this.gcHotPhaseComplete).lf().add("Cold complete: ").add(this.gcColdPhaseComplete).lf().lf().add("sweepGeneration     : ").add(this.sweepGeneration).lf().add("lastSweepEnd        : ").add(this.lastSweepEnd).lf().add("lastSweepStart      : ").add(this.lastSweepStart).lf().add("gcHotGeneration     : ").add(this.gcHotGeneration).lf().add("gcColdGeneration    : ").add(this.gcColdGeneration).lf().add("lastGcColdCompletion: ").add(this.lastGcColdCompletion).lf().add("lastGcHotCompletion : ").add(this.lastGcHotCompletion).lf().lf().add("Needs sweep (").add(this.sweepingChannelCount).add("):");
                i = 0;
                while (i < this.needsSweep.length) {
                    vs.lf().blank().add(i).add(": ").add(this.needsSweep[i]);
                    ++i;
                }
                vs.lf().padLeft(Long.toString(this.pendingStoreUpdateCount), 10, ' ').blank().add("pending store updates");
                i = 0;
                while (i < this.pendingStoreUpdates.length) {
                    vs.lf().blank().add(i).add(": ").add(this.pendingStoreUpdates[i]);
                    ++i;
                }
                return vs.toString();
            });
        }

        static final class CachingReferenceMarker
        implements StorageReferenceMarker {
            private final Default markMonitor;
            private final int channelHash;
            private final int bufferLength;
            private final ChannelItem[] oidsPerChannel;

            CachingReferenceMarker(Default markMonitor, int channelCount, int bufferLength) {
                this.markMonitor = markMonitor;
                this.bufferLength = bufferLength;
                this.channelHash = channelCount - 1;
                this.oidsPerChannel = new ChannelItem[channelCount];
                int i = 0;
                while (i < channelCount) {
                    this.oidsPerChannel[i] = new ChannelItem(bufferLength);
                    ++i;
                }
            }

            public final void acceptObjectId(long objectId) {
                if (objectId == Swizzling.nullId()) {
                    return;
                }
                int i = (int)(objectId & (long)this.channelHash);
                if (this.oidsPerChannel[i].add(objectId) == this.bufferLength) {
                    this.flush();
                }
            }

            final void flush() {
                this.markMonitor.enqueueBulk(this.oidsPerChannel);
                this.resetOidsPerChannel();
            }

            final void resetOidsPerChannel() {
                int i = 0;
                while (i < this.oidsPerChannel.length) {
                    this.oidsPerChannel[i].reset();
                    ++i;
                }
            }

            @Override
            public final boolean tryFlush() {
                int i = 0;
                while (i < this.oidsPerChannel.length) {
                    if (!this.oidsPerChannel[i].isEmpty()) {
                        this.flush();
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public final void reset() {
                this.resetOidsPerChannel();
            }

            static final class ChannelItem
            implements ObjectIds {
                final long[] oids;
                int size;

                ChannelItem(int capacity) {
                    this.oids = new long[capacity];
                }

                final int add(long oid) {
                    this.oids[this.size] = oid;
                    return ++this.size;
                }

                final boolean isEmpty() {
                    return this.size == 0;
                }

                final void reset() {
                    this.size = 0;
                }

                @Override
                public final long[] objectIds() {
                    return this.oids;
                }

                @Override
                public final int size() {
                    return this.size;
                }
            }
        }
    }

    public static interface ObjectIds {
        public long[] objectIds();

        public int size();
    }
}

