/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.persistence.types.PersistenceTypeDefinition;

public interface StorageEntityTypeConversionFileProvider {
    public AWritableFile provideConversionFile(PersistenceTypeDefinition var1, AFile var2);

    public static final class Default
    implements StorageEntityTypeConversionFileProvider {
        private final ADirectory directory;
        private final String fileSuffix;

        public Default(ADirectory directory, String fileSuffix) {
            this.directory = (ADirectory)X.notNull((Object)directory);
            this.fileSuffix = fileSuffix;
        }

        public final String fileSuffix() {
            return this.fileSuffix;
        }

        @Override
        public AWritableFile provideConversionFile(PersistenceTypeDefinition typeDescription, AFile sourceFile) {
            String fileName = String.valueOf(typeDescription.typeName()) + "_" + typeDescription.typeId();
            AFile targetFile = this.directory.ensureFile(fileName, this.fileSuffix);
            targetFile.ensureExists();
            return targetFile.useWriting();
        }
    }
}

