/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.meta.XDebug;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageEntityCache;
import one.microstream.storage.types.StorageHashChannelPart;

public interface StorageEventLogger {
    default public void logChannelProcessingDisabled(StorageChannel channel) {
    }

    default public void logChannelStoppedWorking(StorageChannel channel) {
    }

    default public void logDisruption(StorageChannel channel, Throwable t) {
    }

    default public void logLiveCheckComplete(StorageEntityCache<?> entityCache) {
    }

    default public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
    }

    default public void logGarbageCollectorNotNeeded() {
    }

    default public void logGarbageCollectorCompletedHotPhase(long gcHotGeneration, long lastGcHotCompletion) {
    }

    default public void logGarbageCollectorCompleted(long gcColdGeneration, long lastGcColdCompletion) {
    }

    default public void logGarbageCollectorEncounteredZombieObjectId(long objectId) {
    }

    public static StorageEventLogger NoOp() {
        return new NoOp();
    }

    public static StorageEventLogger Default() {
        return new Default(Default::printString);
    }

    public static StorageEventLogger Default(Consumer<? super String> messageConsumer) {
        return new Default((Consumer)X.notNull(messageConsumer));
    }

    public static StorageEventLogger Debug() {
        return new Debug(Default::printString);
    }

    public static StorageEventLogger Debug(Consumer<? super String> messageConsumer) {
        return new Debug((Consumer)X.notNull(messageConsumer));
    }

    public static class Debug
    extends Default {
        Debug(Consumer<? super String> messageConsumer) {
            super(messageConsumer);
        }

        @Override
        public void logChannelProcessingDisabled(StorageChannel channel) {
            this.log(String.valueOf(Debug.toChannelIdentifier(channel)) + " processing disabled.");
        }

        @Override
        public void logChannelStoppedWorking(StorageChannel channel) {
            this.log(String.valueOf(Debug.toChannelIdentifier(channel)) + " stopped working.");
        }

        @Override
        public void logLiveCheckComplete(StorageEntityCache<?> entityCache) {
            this.log(String.valueOf(Debug.toChannelIdentifier(entityCache)) + " completed live check.");
        }

        @Override
        public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
            this.log(String.valueOf(Debug.toChannelIdentifier(entityCache)) + " completed sweeping.");
        }

        @Override
        public void logGarbageCollectorEncounteredZombieObjectId(long objectId) {
            this.log("GC marking encountered zombie ObjectId " + objectId);
        }

        @Override
        public void logGarbageCollectorNotNeeded() {
            this.log("not needed.");
        }

        @Override
        public void logGarbageCollectorCompletedHotPhase(long gcHotGeneration, long lastGcHotCompletion) {
            this.log("Completed GC Hot Phase #" + gcHotGeneration + " @ " + lastGcHotCompletion);
        }

        @Override
        public void logGarbageCollectorCompleted(long gcColdGeneration, long lastGcColdCompletion) {
            this.log("Storage-GC completed #" + gcColdGeneration + " @ " + lastGcColdCompletion);
        }
    }

    public static class Default
    implements StorageEventLogger {
        protected final Consumer<? super String> messageConsumer;

        public static void printString(String s) {
            XDebug.println((String)s, (int)4);
        }

        public static String toChannelIdentifier(StorageChannel channel) {
            return Default.toChannelPartIdentifier(channel);
        }

        public static String toChannelIdentifier(StorageEntityCache<?> entityCache) {
            return Default.toChannelPartIdentifier(entityCache);
        }

        public static String toChannelPartIdentifier(StorageHashChannelPart channelPart) {
            return String.valueOf(StorageChannel.class.getSimpleName()) + '#' + channelPart.channelIndex();
        }

        public static String stackTraceToString(Throwable t) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            t.printStackTrace(printWriter);
            return printWriter.toString();
        }

        Default(Consumer<? super String> messageConsumer) {
            this.messageConsumer = (Consumer)X.notNull(messageConsumer);
        }

        public void log(String s) {
            this.messageConsumer.accept(s);
        }

        @Override
        public void logDisruption(StorageChannel channel, Throwable t) {
            this.log(String.valueOf(Default.toChannelIdentifier(channel)) + " encountered disrupting exception " + t);
            t.printStackTrace();
        }
    }

    public static final class NoOp
    implements StorageEventLogger {
        NoOp() {
        }
    }
}

