/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.types.StorageChannel;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

@FunctionalInterface
public interface StorageExceptionHandler {
    public void handleException(Throwable var1, StorageChannel var2);

    public static void defaultHandleException(Throwable exception, StorageChannel channel) {
        if (exception instanceof StorageException) {
            throw (StorageException)((Object)exception);
        }
        throw new StorageException(exception);
    }

    public static StorageExceptionHandler New() {
        return new Default();
    }

    public static final class Default
    implements StorageExceptionHandler {
        private static final Logger logger = Logging.getLogger(Default.class);

        Default() {
        }

        @Override
        public void handleException(Throwable exception, StorageChannel channel) {
            logger.error("Exception occured in storage channel#{}", (Object)channel.channelIndex(), (Object)exception);
            StorageExceptionHandler.defaultHandleException(exception, channel);
        }
    }
}

