/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AReadableFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.io.BufferProvider;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.exceptions.StorageExceptionIoReading;

public interface StorageFile {
    default public String identifier() {
        return this.file().toPathString();
    }

    public AFile file();

    public long size();

    public boolean exists();

    public long readBytes(ByteBuffer var1);

    public long readBytes(ByteBuffer var1, long var2);

    public long readBytes(ByteBuffer var1, long var2, long var4);

    public long readBytes(BufferProvider var1);

    public long readBytes(BufferProvider var1, long var2);

    public long readBytes(BufferProvider var1, long var2, long var4);

    public long writeBytes(Iterable<? extends ByteBuffer> var1);

    public long copyTo(StorageFile var1);

    public long copyTo(StorageFile var1, long var2);

    public long copyTo(StorageFile var1, long var2, long var4);

    public long copyTo(AWritableFile var1);

    public long copyTo(AWritableFile var1, long var2);

    public long copyTo(AWritableFile var1, long var2, long var4);

    public long copyFrom(AReadableFile var1);

    public long copyFrom(AReadableFile var1, long var2);

    public long copyFrom(AReadableFile var1, long var2, long var4);

    public boolean delete();

    public void moveTo(AWritableFile var1);

    public static VarString assembleNameAndSize(VarString vs, StorageFile file) {
        return vs.add(String.valueOf(file.file().identifier()) + "[" + file.file().size() + "]");
    }

    public static abstract class Abstract
    implements StorageFile {
        private final AFile file;
        private AWritableFile writeAccess;
        private AReadableFile readAccess;

        protected Abstract(AFile file) {
            this.file = file;
        }

        @Override
        public AFile file() {
            return this.file;
        }

        @Override
        public final synchronized long size() {
            return this.file().size();
        }

        @Override
        public final synchronized boolean exists() {
            return this.file.exists();
        }

        @Override
        public final synchronized long readBytes(ByteBuffer targetBuffer) {
            try {
                return this.ensureReadable().readBytes(targetBuffer);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        @Override
        public final synchronized long readBytes(ByteBuffer targetBuffer, long position) {
            try {
                return this.ensureReadable().readBytes(targetBuffer, position);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        @Override
        public final synchronized long readBytes(ByteBuffer targetBuffer, long position, long length) {
            try {
                return this.ensureReadable().readBytes(targetBuffer, position, length);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        @Override
        public final synchronized long readBytes(BufferProvider bufferProvider) {
            try {
                return this.ensureReadable().readBytes(bufferProvider);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        @Override
        public final synchronized long readBytes(BufferProvider bufferProvider, long position) {
            try {
                return this.ensureReadable().readBytes(bufferProvider, position);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        @Override
        public final synchronized long readBytes(BufferProvider bufferProvider, long position, long length) {
            try {
                return this.ensureReadable().readBytes(bufferProvider, position, length);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        @Override
        public final synchronized long writeBytes(Iterable<? extends ByteBuffer> buffers) {
            try {
                return this.ensureWritable().writeBytes(buffers);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        @Override
        public final synchronized long copyTo(StorageFile target) {
            return target.copyFrom(this.ensureReadable());
        }

        @Override
        public final synchronized long copyTo(StorageFile target, long sourcePosition) {
            return target.copyFrom(this.ensureReadable(), sourcePosition);
        }

        @Override
        public final synchronized long copyTo(StorageFile target, long sourcePosition, long length) {
            return target.copyFrom(this.ensureReadable(), sourcePosition, length);
        }

        @Override
        public final synchronized long copyTo(AWritableFile target) {
            try {
                return target.copyFrom(this.ensureReadable());
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        @Override
        public final synchronized long copyTo(AWritableFile target, long sourcePosition) {
            try {
                return target.copyFrom(this.ensureReadable(), sourcePosition);
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        @Override
        public final synchronized long copyTo(AWritableFile target, long sourcePosition, long length) {
            try {
                target.ensureExists();
                return target.copyFrom(this.ensureReadable(), sourcePosition, length);
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        @Override
        public final synchronized long copyFrom(AReadableFile source) {
            try {
                return source.copyTo(this.ensureWritable());
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        @Override
        public final synchronized long copyFrom(AReadableFile source, long sourcePosition) {
            try {
                return source.copyTo(this.ensureWritable(), sourcePosition);
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        @Override
        public final synchronized long copyFrom(AReadableFile source, long sourcePosition, long length) {
            try {
                return source.copyTo(this.ensureWritable(), sourcePosition, length);
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        public final synchronized void truncate(long newLength) {
            this.ensureWritable().truncate(newLength);
        }

        @Override
        public final synchronized boolean delete() {
            return this.ensureWritable().delete();
        }

        @Override
        public final synchronized void moveTo(AWritableFile target) {
            this.ensureWritable().moveTo(target);
        }

        protected synchronized AReadableFile ensureReadable() {
            this.internalOpenReading();
            return this.readAccess;
        }

        protected synchronized AWritableFile ensureWritable() {
            this.internalOpenWriting();
            return this.writeAccess;
        }

        public synchronized boolean isOpen() {
            return this.writeAccess != null && this.writeAccess.isOpen();
        }

        public synchronized boolean close() {
            boolean result = false;
            if (this.writeAccess != null) {
                result = this.writeAccess.release();
                this.writeAccess = null;
            }
            if (this.readAccess != null) {
                result = this.readAccess.release();
                this.readAccess = null;
            }
            return result;
        }

        protected synchronized boolean internalOpenWriting() {
            try {
                if (this.writeAccess == null || this.writeAccess.isRetired()) {
                    this.writeAccess = this.file().useWriting();
                    this.readAccess = this.writeAccess;
                }
                return this.writeAccess.open();
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        protected synchronized boolean internalOpenReading() {
            try {
                if (this.readAccess == null || this.readAccess.isRetired()) {
                    this.writeAccess = null;
                    this.readAccess = this.file().useReading();
                }
                return this.readAccess.open();
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
        }

        public String toString() {
            return String.valueOf(XChars.systemString((Object)this)) + " (" + this.file + ")";
        }
    }
}

