/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.collections.ConstHashTable;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.persistence.types.Persistence;
import one.microstream.typing.KeyValue;

public interface StorageIdAnalysis {
    public XGettingTable<Persistence.IdType, Long> highestIdsPerType();

    public XGettingEnum<Long> occuringTypeIds();

    public static StorageIdAnalysis Empty() {
        return new Default((XGettingTable<Persistence.IdType, Long>)X.emptyTable(), null);
    }

    public static StorageIdAnalysis New(Long highestTid, Long highestOid, Long highestCid) {
        return StorageIdAnalysis.New(highestTid, highestOid, highestCid, null);
    }

    public static StorageIdAnalysis New(Long highestTid, Long highestOid, Long highestCid, XGettingEnum<Long> occuringTypeIds) {
        return StorageIdAnalysis.New((XGettingSequence<KeyValue<Persistence.IdType, Long>>)ConstHashTable.New((KeyValue[])new KeyValue[]{X.KeyValue((Object)Persistence.IdType.TID, (Object)highestTid), X.KeyValue((Object)Persistence.IdType.OID, (Object)highestOid), X.KeyValue((Object)Persistence.IdType.CID, (Object)highestCid)}), occuringTypeIds);
    }

    public static StorageIdAnalysis New(XGettingSequence<KeyValue<Persistence.IdType, Long>> values, XGettingEnum<Long> occuringTypeIds) {
        return new Default((XGettingTable<Persistence.IdType, Long>)ConstHashTable.New((XGettingCollection)((XGettingCollection)X.notNull(values))), (XGettingEnum<Long>)(occuringTypeIds == null ? X.empty() : EqHashEnum.New(occuringTypeIds)));
    }

    public static final class Default
    implements StorageIdAnalysis {
        final XGettingTable<Persistence.IdType, Long> highestIdsPerType;
        final XGettingEnum<Long> occuringTypeIds;

        Default(XGettingTable<Persistence.IdType, Long> highestIdsPerType, XGettingEnum<Long> occuringTypeIds) {
            this.highestIdsPerType = highestIdsPerType;
            this.occuringTypeIds = occuringTypeIds;
        }

        @Override
        public final XGettingTable<Persistence.IdType, Long> highestIdsPerType() {
            return this.highestIdsPerType;
        }

        @Override
        public final XGettingEnum<Long> occuringTypeIds() {
            return this.occuringTypeIds;
        }
    }
}

