/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.functional._longProcedure;

public interface StorageRootOidSelector
extends _longProcedure {
    public void reset();

    public long yield();

    default public void resetGlobal() {
        this.reset();
    }

    default public void acceptGlobal(long rootOid) {
        this.accept(rootOid);
    }

    default public long yieldGlobal() {
        return this.yield();
    }

    public static final class Default
    implements StorageRootOidSelector {
        private transient long currentMax;

        Default() {
        }

        public final void accept(long rootOid) {
            if (rootOid < this.currentMax) {
                return;
            }
            this.currentMax = rootOid;
        }

        @Override
        public final void reset() {
            this.currentMax = 0L;
        }

        @Override
        public final long yield() {
            return this.currentMax;
        }
    }

    public static interface Provider {
        public StorageRootOidSelector provideRootOidSelector(int var1);

        public static final class Default
        implements Provider {
            @Override
            public final StorageRootOidSelector provideRootOidSelector(int channelIndex) {
                return new one.microstream.storage.types.StorageRootOidSelector$Default();
            }
        }
    }
}

