/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.storage.types.StorageThreadProviding;

@FunctionalInterface
public interface StorageThreadNameProvider {
    public String provideThreadName(StorageThreadProviding var1, String var2);

    public static StorageThreadNameProvider NoOp() {
        return new NoOp();
    }

    public static StorageThreadNameProvider Prefixer(String prefix) {
        return new Prefixer((String)X.notNull((Object)prefix));
    }

    public static final class NoOp
    implements StorageThreadNameProvider {
        NoOp() {
        }

        @Override
        public String provideThreadName(StorageThreadProviding threadProvider, String definedThreadName) {
            return definedThreadName;
        }
    }

    public static final class Prefixer
    implements StorageThreadNameProvider {
        final String prefix;

        Prefixer(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final String provideThreadName(StorageThreadProviding threadProvider, String definedThreadName) {
            return String.valueOf(this.prefix) + definedThreadName;
        }
    }
}

