/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.exceptions.MultiCauseException;
import one.microstream.functional.ThrowingProcedure;
import one.microstream.util.UtilStackTrace;

public interface DisruptionCollector {
    default public void execute(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable d) {
            this.collectDisruption(d);
        }
    }

    default public <E> void execute(Consumer<? super E> logic, E element) {
        try {
            logic.accept(element);
        }
        catch (Throwable d) {
            this.collectDisruption(d);
        }
    }

    default public <E> void execute(ThrowingProcedure<? super E, ?> logic, E element) {
        try {
            logic.accept(element);
        }
        catch (Throwable d) {
            this.collectDisruption(d);
        }
    }

    default public <O> O execute(Supplier<O> logic) {
        try {
            return logic.get();
        }
        catch (Throwable d) {
            this.collectDisruption(d);
            return null;
        }
    }

    default public <I, O> O execute(Function<? super I, O> logic, I input) {
        try {
            return logic.apply(input);
        }
        catch (Throwable d) {
            this.collectDisruption(d);
            return null;
        }
    }

    public boolean hasDisruptions();

    public DisruptionCollector reset();

    public DisruptionCollector collectDisruption(Throwable var1);

    default public XGettingCollection<Throwable> yield() {
        return (XGettingCollection)this.yield(BulkList.New());
    }

    public <C extends Consumer<? super Throwable>> C yield(C var1);

    public MultiCauseException toMultiCauseException(int var1);

    public Throwable[] toArray();

    default public MultiCauseException toMultiCauseException() {
        return this.toMultiCauseException(1);
    }

    public static Supplier<? extends XCollection<Throwable>> defaultCollectionSupplier() {
        return BulkList::New;
    }

    public static DisruptionCollector New() {
        return new Default(DisruptionCollector.defaultCollectionSupplier(), null);
    }

    public static DisruptionCollector New(Supplier<? extends XCollection<Throwable>> collectionSupplier) {
        return new Default(collectionSupplier, null);
    }

    public static DisruptionCollector New(XCollection<Throwable> collection) {
        return new Default(null, collection);
    }

    public static class Default
    implements DisruptionCollector {
        private final Supplier<? extends XCollection<Throwable>> collectionSupplier;
        private XCollection<Throwable> disruptions;

        Default(Supplier<? extends XCollection<Throwable>> collectionSupplier, XCollection<Throwable> disruptions) {
            this.collectionSupplier = collectionSupplier;
            this.disruptions = disruptions;
        }

        @Override
        public final synchronized DisruptionCollector collectDisruption(Throwable disruption) {
            if (this.disruptions == null) {
                this.disruptions = this.collectionSupplier.get();
            }
            this.disruptions.add((Object)disruption);
            return this;
        }

        @Override
        public final synchronized <C extends Consumer<? super Throwable>> C yield(C target) {
            if (this.disruptions != null) {
                this.disruptions.iterate(target);
            }
            return target;
        }

        @Override
        public final synchronized boolean hasDisruptions() {
            return this.disruptions != null && !this.disruptions.isEmpty();
        }

        @Override
        public DisruptionCollector reset() {
            if (this.collectionSupplier != null) {
                this.disruptions = null;
            } else {
                this.disruptions.clear();
            }
            return this;
        }

        @Override
        public Throwable[] toArray() {
            Throwable[] array = this.disruptions == null ? null : (Throwable[])this.disruptions.toArray(Throwable.class);
            return array;
        }

        @Override
        public MultiCauseException toMultiCauseException(int stackTraceCutDepth) {
            MultiCauseException exception = new MultiCauseException(this.toArray());
            if (stackTraceCutDepth > 0) {
                UtilStackTrace.cutStacktraceByN((Throwable)exception, (int)(stackTraceCutDepth + 1));
            }
            return exception;
        }
    }
}

