/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelTask;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestTask;

public interface StorageChannelSynchronizingTask
extends StorageChannelTask {
    public boolean isProcessed();

    public void incrementProcessingProgress();

    public void waitOnProcessing() throws InterruptedException;

    public static abstract class AbstractCompletingTask<R>
    extends StorageChannelTask.Abstract<R>
    implements StorageChannelSynchronizingTask {
        public AbstractCompletingTask(long timestamp, int channelCount, StorageOperationController controller) {
            super(timestamp, channelCount, controller);
        }

        protected void succeed(StorageChannel channel, R result) {
        }

        protected void fail(StorageChannel channel, R result) {
        }

        protected void postCompletionSuccess(StorageChannel channel, R result) throws InterruptedException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void synchronizedComplete(StorageChannel channel, R result) {
            try {
                if (this.hasProblems()) {
                    this.fail(channel, result);
                } else {
                    this.succeed(channel, result);
                }
            }
            catch (Throwable t) {
                this.addProblem(channel.channelIndex(), t);
            }
            finally {
                this.incrementCompletionProgress();
            }
        }

        @Override
        protected R internalProcessBy(StorageChannel channel) {
            return null;
        }

        @Override
        protected final void complete(StorageChannel channel, R result) throws InterruptedException {
            try {
                this.waitOnProcessing();
            }
            catch (InterruptedException e) {
                this.addProblem(channel.channelIndex(), e);
                throw e;
            }
            finally {
                this.synchronizedComplete(channel, result);
                if (!this.hasProblems()) {
                    this.postCompletionSuccess(channel, result);
                }
            }
        }

        public static final class Dummy
        extends AbstractCompletingTask<Void>
        implements StorageRequestTask {
            public Dummy(int channelCount, StorageOperationController controller) {
                super(0L, channelCount, controller);
            }
        }
    }
}

