/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.XSort;
import one.microstream.persistence.types.Persistence;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelSynchronizingTask;
import one.microstream.storage.types.StorageChannelTask;
import one.microstream.storage.types.StorageIdAnalysis;
import one.microstream.storage.types.StorageInventory;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageTransactionsAnalysis;

public interface StorageChannelTaskInitialize
extends StorageChannelTask {
    public StorageIdAnalysis idAnalysis();

    public static final class Default
    extends StorageChannelSynchronizingTask.AbstractCompletingTask<StorageInventory[]>
    implements StorageChannelTaskInitialize {
        private final StorageOperationController operationController;
        private final StorageInventory[] result;
        private Long consistentStoreTimestamp;
        private Long commonTaskHeadFileTimestamp;
        private long maxEntityObjectOid;
        private long maxEntityConstantOid;
        private long maxEntityTypeOid;
        private final EqHashEnum<Long> occuringTypeIds = EqHashEnum.New();

        public Default(long timestamp, int channelCount, StorageOperationController operationController) {
            super(timestamp, channelCount, operationController);
            this.operationController = (StorageOperationController)X.notNull((Object)operationController);
            this.result = new StorageInventory[channelCount];
        }

        private synchronized long getConsistentStoreTimestamp() {
            if (this.consistentStoreTimestamp == null) {
                this.checkAllTransactionsFilesMissing();
                this.consistentStoreTimestamp = this.determineConsistentStoreTimestamp();
            }
            return this.consistentStoreTimestamp;
        }

        private synchronized long getCommonTaskHeadFileTimestamp() {
            if (this.commonTaskHeadFileTimestamp == null) {
                long maxResultFileCount = 0L;
                for (StorageInventory si : this.result) {
                    if (si.dataFiles().size() <= maxResultFileCount) continue;
                    maxResultFileCount = si.dataFiles().size();
                }
                this.commonTaskHeadFileTimestamp = this.timestamp() + maxResultFileCount;
            }
            return this.commonTaskHeadFileTimestamp;
        }

        private synchronized void updateIdAnalysis(StorageIdAnalysis idAnalysis) {
            Long typeMaxCid;
            Long typeMaxOid;
            Long typeMaxTid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.TID);
            if (typeMaxTid != null && typeMaxTid >= this.maxEntityTypeOid) {
                this.maxEntityTypeOid = typeMaxTid;
            }
            if ((typeMaxOid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.OID)) != null && typeMaxOid >= this.maxEntityObjectOid) {
                this.maxEntityObjectOid = typeMaxOid;
            }
            if ((typeMaxCid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.CID)) != null && typeMaxCid >= this.maxEntityConstantOid) {
                this.maxEntityConstantOid = typeMaxCid;
            }
            this.occuringTypeIds.addAll(idAnalysis.occuringTypeIds());
            this.occuringTypeIds.sort(XSort::compare);
        }

        private boolean checkAllTransactionsFilesMissing() {
            boolean firstIsNull = this.result[0].transactionsFileAnalysis() == null;
            for (int i = 1; i < this.result.length; ++i) {
                if (this.result[i].transactionsFileAnalysis() == null == firstIsNull) continue;
                throw new StorageExceptionConsistency("Mixed (inconsistent) transactions file existances.");
            }
            return firstIsNull;
        }

        private long determineConsistentStoreTimestamp() {
            if (this.checkAllTransactionsFilesMissing()) {
                return 0L;
            }
            long firstChannelLatestTimestamp = this.result[0].transactionsFileAnalysis().headFileLatestTimestamp();
            for (StorageInventory inventory : this.result) {
                if (Default.isCompatibleTimestamp(firstChannelLatestTimestamp, inventory.transactionsFileAnalysis())) continue;
                return this.fallbackDetermineConsistentStoreTimestamp();
            }
            return firstChannelLatestTimestamp;
        }

        private long fallbackDetermineConsistentStoreTimestamp() {
            long firstChannelLastTimestamp = this.result[0].transactionsFileAnalysis().headFileLastConsistentStoreTimestamp();
            for (StorageInventory inventory : this.result) {
                if (Default.isCompatibleTimestamp(firstChannelLastTimestamp, inventory.transactionsFileAnalysis())) continue;
                throw new StorageExceptionConsistency("Inconsistent store timestamps between channels");
            }
            return firstChannelLastTimestamp;
        }

        private static boolean isCompatibleTimestamp(long candidatetimestamp, StorageTransactionsAnalysis transactionsFile) {
            return transactionsFile.headFileLatestTimestamp() == candidatetimestamp || transactionsFile.headFileLastConsistentStoreTimestamp() == candidatetimestamp;
        }

        @Override
        protected final StorageInventory[] internalProcessBy(StorageChannel channel) {
            this.result[channel.channelIndex()] = channel.readStorage();
            return this.result;
        }

        @Override
        protected final void succeed(StorageChannel channel, StorageInventory[] result) {
            StorageIdAnalysis idAnalysis = channel.initializeStorage(this.getCommonTaskHeadFileTimestamp(), this.getConsistentStoreTimestamp(), result[channel.channelIndex()]);
            this.updateIdAnalysis(idAnalysis);
            this.operationController.activate();
        }

        @Override
        protected final void fail(StorageChannel channel, StorageInventory[] result) {
        }

        @Override
        public synchronized StorageIdAnalysis idAnalysis() {
            return StorageIdAnalysis.New(this.maxEntityTypeOid, this.maxEntityObjectOid, this.maxEntityConstantOid, this.occuringTypeIds);
        }
    }
}

