/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.exceptions.StorageExceptionShutdown;
import one.microstream.storage.types.StorageActivePart;

public interface StorageController
extends StorageActivePart,
AutoCloseable {
    public StorageController start();

    public boolean shutdown();

    public boolean isAcceptingTasks();

    public boolean isRunning();

    public boolean isStartingUp();

    public boolean isShuttingDown();

    default public boolean isShutdown() {
        return !this.isRunning();
    }

    public void checkAcceptingTasks();

    public long initializationTime();

    public long operationModeTime();

    default public long initializationDuration() {
        return this.operationModeTime() - this.initializationTime();
    }

    @Override
    default public void close() throws StorageExceptionShutdown {
        boolean success;
        try {
            success = this.shutdown();
        }
        catch (Exception e) {
            throw new StorageExceptionShutdown("Shutdown failed.", e);
        }
        if (!success) {
            throw new StorageExceptionShutdown("Shutdown failed.");
        }
    }
}

