/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.chars.XChars;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.types.StorageEntityTypeHandler;

public interface StorageEntityTypeExportFileProvider {
    public AWritableFile provideExportFile(StorageEntityTypeHandler var1);

    public static String uniqueTypeFileNameSeparator() {
        return "_";
    }

    public static String toUniqueTypeFileName(PersistenceTypeDefinition type) {
        return StorageEntityTypeExportFileProvider.toUniqueTypeFileName(type.typeName(), type.typeId());
    }

    public static String toUniqueTypeFileName(String typeName, long typeId) {
        return typeName + StorageEntityTypeExportFileProvider.uniqueTypeFileNameSeparator() + typeId;
    }

    public static long getTypeIdFromUniqueTypeFileName(String uniqueTypeFileName) {
        int lastIndexOfSeparator = uniqueTypeFileName.lastIndexOf(StorageEntityTypeExportFileProvider.uniqueTypeFileNameSeparator());
        if (lastIndexOfSeparator < 0) {
            throw new StorageException("UniqueTypeFileNameSeparator '" + StorageEntityTypeExportFileProvider.uniqueTypeFileNameSeparator() + "' was not found in file name \"" + uniqueTypeFileName + "\".");
        }
        String typeIdString = uniqueTypeFileName.substring(lastIndexOfSeparator + 1);
        try {
            return Long.parseLong(typeIdString);
        }
        catch (NumberFormatException e) {
            throw new StorageException("Invalid TypeId String in file name \"" + uniqueTypeFileName + "\".", e);
        }
    }

    public static StorageEntityTypeExportFileProvider New(ADirectory directory) {
        return StorageEntityTypeExportFileProvider.New(directory, Defaults.defaultFileSuffix());
    }

    public static StorageEntityTypeExportFileProvider New(ADirectory directory, String fileSuffix) {
        return new Default((ADirectory)X.notNull((Object)directory), (String)XChars.notEmpty((CharSequence)fileSuffix));
    }

    public static final class Default
    implements StorageEntityTypeExportFileProvider {
        private final ADirectory directory;
        private final String fileSuffix;

        public Default(ADirectory directory, String fileSuffix) {
            this.directory = (ADirectory)X.notNull((Object)directory);
            this.fileSuffix = fileSuffix;
        }

        public final String fileSuffix() {
            return this.fileSuffix;
        }

        @Override
        public final AWritableFile provideExportFile(StorageEntityTypeHandler entityType) {
            String name = StorageEntityTypeExportFileProvider.toUniqueTypeFileName(entityType);
            AFile file = this.directory.ensureFile(null, name, this.fileSuffix);
            AWritableFile wFile = file.useWriting();
            return wFile;
        }
    }

    public static interface Defaults {
        public static String defaultFileSuffix() {
            return "bin";
        }
    }
}

