/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.BinaryEntityRawDataIterator;
import one.microstream.storage.types.StorageChannelImportBatch;
import one.microstream.storage.types.StorageImportSource;
import one.microstream.storage.types.StorageImportSourceByteBuffer;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestTaskImportData;

public interface StorageRequestTaskImportDataByteBuffers
extends StorageRequestTaskImportData<ByteBuffer> {

    public static final class Default
    extends StorageRequestTaskImportData.Abstract<ByteBuffer>
    implements StorageRequestTaskImportDataByteBuffers {
        Default(long timestamp, int channelCount, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, XGettingEnum<ByteBuffer> importData, StorageOperationController controller) {
            super(timestamp, channelCount, controller, objectIdRangeEvaluator, importData);
        }

        @Override
        protected StorageImportSource.Abstract createImportSource(int channelIndex, ByteBuffer buffer, StorageChannelImportBatch.Default headBatch) {
            return new StorageImportSourceByteBuffer.Default(channelIndex, buffer, headBatch);
        }

        @Override
        protected void iterateSource(ByteBuffer buffer, StorageRequestTaskImportData.Abstract.ItemAcceptor itemAcceptor) {
            long address = XMemory.getDirectByteBufferAddress((ByteBuffer)buffer);
            BinaryEntityRawDataIterator.New().iterateEntityRawData(address, address + (long)buffer.limit(), (entityStartAddress, dataBoundAddress) -> itemAcceptor.accept(entityStartAddress, dataBoundAddress - entityStartAddress));
        }
    }
}

