/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import one.microstream.chars.VarString;
import one.microstream.meta.XDebug;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.Chunk;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelSynchronizingTask;
import one.microstream.storage.types.StorageChannelTaskStoreEntities;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestTask;
import one.microstream.typing.KeyValue;
import one.microstream.util.UtilStackTrace;

public interface StorageRequestTaskStoreEntities
extends StorageRequestTask {

    public static final class Default
    extends StorageChannelSynchronizingTask.AbstractCompletingTask<KeyValue<ByteBuffer[], long[]>>
    implements StorageRequestTaskStoreEntities,
    StorageChannelTaskStoreEntities {
        private final Binary data;

        Default(long timestamp, Binary data, StorageOperationController controller) {
            super(timestamp, data.channelCount(), controller);
            this.data = data;
        }

        @Override
        protected final KeyValue<ByteBuffer[], long[]> internalProcessBy(StorageChannel channel) {
            return channel.storeEntities(this.timestamp(), (Chunk)this.data.channelChunk(channel.channelIndex()));
        }

        public final void DEBUG_Print(StorageChannel channel) {
            VarString vs = VarString.New();
            if (channel != null) {
                vs.add(channel.channelIndex()).add(" processing");
            } else {
                vs.add("Issued");
            }
            vs.add(" store task ").add(System.identityHashCode(this)).add(" @").add(this.timestamp());
            if (channel == null) {
                vs.add(" Stacktrace:");
                for (StackTraceElement e : UtilStackTrace.cutStacktraceByN((Throwable)new Throwable(), (int)2).getStackTrace()) {
                    vs.lf().add(e.toString());
                }
            }
            XDebug.println((String)vs.toString(), (int)1);
        }

        @Override
        protected final void succeed(StorageChannel channel, KeyValue<ByteBuffer[], long[]> result) {
            channel.commitChunkStorage();
        }

        @Override
        protected final void postCompletionSuccess(StorageChannel channel, KeyValue<ByteBuffer[], long[]> result) throws InterruptedException {
            channel.postStoreUpdateEntityCache((ByteBuffer[])result.key(), (long[])result.value());
        }

        @Override
        protected final void fail(StorageChannel channel, KeyValue<ByteBuffer[], long[]> result) {
            channel.rollbackChunkStorage();
        }

        @Override
        protected final void cleanUp(StorageChannel channel) {
            channel.cleanupStore();
        }
    }
}

