/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AFile;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.exceptions.StorageExceptionNotRunning;
import one.microstream.storage.types.StorageChannelSynchronizingTask;
import one.microstream.storage.types.StorageChannelTaskInitialize;
import one.microstream.storage.types.StorageChannelTaskShutdown;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityTypeExportFileProvider;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestTask;
import one.microstream.storage.types.StorageRequestTaskCacheCheck;
import one.microstream.storage.types.StorageRequestTaskCreateStatistics;
import one.microstream.storage.types.StorageRequestTaskCreator;
import one.microstream.storage.types.StorageRequestTaskExportChannels;
import one.microstream.storage.types.StorageRequestTaskExportEntitiesByType;
import one.microstream.storage.types.StorageRequestTaskFileCheck;
import one.microstream.storage.types.StorageRequestTaskGarbageCollection;
import one.microstream.storage.types.StorageRequestTaskImportDataByteBuffers;
import one.microstream.storage.types.StorageRequestTaskImportDataFiles;
import one.microstream.storage.types.StorageRequestTaskLoadByOids;
import one.microstream.storage.types.StorageRequestTaskLoadByTids;
import one.microstream.storage.types.StorageRequestTaskLoadRoots;
import one.microstream.storage.types.StorageRequestTaskStoreEntities;
import one.microstream.storage.types.StorageSystem;
import one.microstream.storage.types.StorageTask;
import one.microstream.util.UtilStackTrace;

public interface StorageTaskBroker {
    public StorageTask currentTask();

    public StorageRequestTaskLoadRoots enqueueRootsLoadTask() throws InterruptedException;

    public StorageRequestTaskLoadByTids enqueueLoadTaskByTids(PersistenceIdSet var1) throws InterruptedException;

    public StorageRequestTaskLoadByOids enqueueLoadTaskByOids(PersistenceIdSet[] var1) throws InterruptedException;

    public StorageRequestTaskStoreEntities enqueueStoreTask(Binary var1) throws InterruptedException;

    default public StorageRequestTaskExportEntitiesByType enqueueExportTypesTask(StorageEntityTypeExportFileProvider exportFileProvider) throws InterruptedException {
        return this.enqueueExportTypesTask(exportFileProvider, null);
    }

    public StorageRequestTaskExportEntitiesByType enqueueExportTypesTask(StorageEntityTypeExportFileProvider var1, Predicate<? super StorageEntityTypeHandler> var2) throws InterruptedException;

    public StorageRequestTask enqueueExportChannelsTask(StorageLiveFileProvider var1, boolean var2) throws InterruptedException;

    public StorageRequestTask enqueueImportFromFilesTask(XGettingEnum<AFile> var1) throws InterruptedException;

    public StorageRequestTask enqueueImportFromByteBuffersTask(XGettingEnum<ByteBuffer> var1) throws InterruptedException;

    public StorageRequestTaskCreateStatistics enqueueCreateRawFileStatisticsTask() throws InterruptedException;

    public StorageChannelTaskInitialize issueChannelInitialization(StorageOperationController var1) throws InterruptedException;

    public StorageChannelTaskShutdown issueChannelShutdown(StorageOperationController var1) throws InterruptedException;

    public StorageRequestTaskGarbageCollection issueGarbageCollection(long var1) throws InterruptedException;

    public StorageRequestTaskFileCheck issueFileCheck(long var1) throws InterruptedException;

    public StorageRequestTaskCacheCheck issueCacheCheck(long var1, StorageEntityCacheEvaluator var3) throws InterruptedException;

    public StorageOperationController operationController();

    public static interface Creator {
        public StorageTaskBroker createTaskBroker(StorageSystem var1, StorageRequestTaskCreator var2);

        public static final class Default
        implements Creator {
            @Override
            public StorageTaskBroker createTaskBroker(StorageSystem storageSystem, StorageRequestTaskCreator taskCreator) {
                return new one.microstream.storage.types.StorageTaskBroker$Default(taskCreator, storageSystem.operationController(), storageSystem.configuration().dataFileEvaluator(), storageSystem.objectIdRangeEvaluator(), storageSystem.channelCountProvider().getChannelCount());
            }
        }
    }

    public static final class Default
    implements StorageTaskBroker {
        private final StorageOperationController operationController;
        private final StorageDataFileEvaluator fileEvaluator;
        private final StorageObjectIdRangeEvaluator objectIdRangeEvaluator;
        private final StorageRequestTaskCreator taskCreator;
        private final int channelCount;
        private volatile StorageTask currentHead;

        Default(StorageRequestTaskCreator taskCreator, StorageOperationController operationController, StorageDataFileEvaluator fileEvaluator, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, int channelCount) {
            this.taskCreator = (StorageRequestTaskCreator)X.notNull((Object)taskCreator);
            this.operationController = (StorageOperationController)X.notNull((Object)operationController);
            this.fileEvaluator = (StorageDataFileEvaluator)X.notNull((Object)fileEvaluator);
            this.objectIdRangeEvaluator = (StorageObjectIdRangeEvaluator)X.notNull((Object)objectIdRangeEvaluator);
            this.channelCount = channelCount;
            this.currentHead = new StorageTask.DummyTask();
        }

        private StorageRequestTaskGarbageCollection enqueueTaskPrependingFullGc(StorageTask task, long nanoTimeBudget) throws InterruptedException {
            StorageRequestTaskGarbageCollection.Default gcTask = new StorageRequestTaskGarbageCollection.Default(task.timestamp() - 1L, this.channelCount, nanoTimeBudget, task, this.operationController);
            this.enqueueTasksAndNotifyAll(gcTask, task);
            return gcTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void enqueueTasksAndNotifyAll(StorageTask firstTask, StorageTask secondTask) throws InterruptedException {
            StorageTask currentHead;
            StorageTask storageTask = currentHead = this.enqueueTask(firstTask, secondTask);
            synchronized (storageTask) {
                currentHead.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueueTaskAndNotifyAll(StorageTask task) throws InterruptedException {
            StorageTask currentHead;
            StorageTask storageTask = currentHead = this.enqueueTask(task);
            synchronized (storageTask) {
                currentHead.notifyAll();
            }
        }

        private StorageTask enqueueTask(StorageTask task) {
            return this.enqueueTask(task, task);
        }

        private StorageTask enqueueTask(StorageTask nextTask, StorageTask newHeadTask) {
            if (!this.operationController.checkProcessingEnabled()) {
                throw new StorageExceptionNotRunning("Storage is shut down.");
            }
            return this.uncheckedEnqueueTask(nextTask, newHeadTask);
        }

        private StorageTask uncheckedEnqueueTask(StorageTask nextTask, StorageTask newHeadTask) {
            StorageTask currentHead = this.currentHead;
            currentHead.setNext(nextTask);
            this.currentHead = newHeadTask;
            return currentHead;
        }

        @Override
        public final StorageTask currentTask() {
            return this.currentHead;
        }

        @Override
        public final synchronized StorageRequestTaskGarbageCollection issueGarbageCollection(long nanoTimeBudget) throws InterruptedException {
            StorageChannelSynchronizingTask.AbstractCompletingTask.Dummy dummy = new StorageChannelSynchronizingTask.AbstractCompletingTask.Dummy(this.channelCount, this.operationController);
            StorageRequestTaskGarbageCollection gcTask = this.enqueueTaskPrependingFullGc(dummy, nanoTimeBudget);
            return gcTask;
        }

        @Override
        public final synchronized StorageRequestTaskCacheCheck issueCacheCheck(long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator) throws InterruptedException {
            StorageRequestTaskCacheCheck task = this.taskCreator.createFullCacheCheckTask(this.channelCount, nanoTimeBudget, entityEvaluator, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public final synchronized StorageRequestTaskFileCheck issueFileCheck(long nanoTimeBudget) throws InterruptedException {
            StorageRequestTaskFileCheck task = this.taskCreator.createFullFileCheckTask(this.channelCount, nanoTimeBudget, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public final synchronized StorageRequestTask enqueueExportChannelsTask(StorageLiveFileProvider fileProvider, boolean performGarbageCollection) throws InterruptedException {
            StorageRequestTaskExportChannels task = this.taskCreator.createTaskExportChannels(this.channelCount, fileProvider, this.operationController);
            if (performGarbageCollection) {
                this.enqueueTaskPrependingFullGc(task, Long.MAX_VALUE);
            } else {
                this.enqueueTaskAndNotifyAll(task);
            }
            return task;
        }

        @Override
        public StorageRequestTask enqueueImportFromFilesTask(XGettingEnum<AFile> importFiles) throws InterruptedException {
            StorageRequestTaskImportDataFiles task = this.taskCreator.createImportFromFilesTask(this.channelCount, this.fileEvaluator, this.objectIdRangeEvaluator, importFiles, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public StorageRequestTask enqueueImportFromByteBuffersTask(XGettingEnum<ByteBuffer> importData) throws InterruptedException {
            StorageRequestTaskImportDataByteBuffers task = this.taskCreator.createImportFromByteBuffersTask(this.channelCount, this.fileEvaluator, this.objectIdRangeEvaluator, importData, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public StorageRequestTaskCreateStatistics enqueueCreateRawFileStatisticsTask() throws InterruptedException {
            StorageRequestTaskCreateStatistics task = this.taskCreator.createCreateRawFileStatisticsTask(this.channelCount, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public final synchronized StorageRequestTaskExportEntitiesByType enqueueExportTypesTask(StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType) throws InterruptedException {
            StorageRequestTaskExportEntitiesByType task = this.taskCreator.createExportTypesTask(this.channelCount, exportFileProvider, isExportType, this.operationController);
            this.enqueueTaskPrependingFullGc(task, Long.MAX_VALUE);
            return task;
        }

        private void validateChannelCount(int channelCount) {
            if (channelCount != this.channelCount) {
                throw (StorageException)((Object)UtilStackTrace.cutStacktraceByOne((Throwable)((Object)new StorageException("Invalid channel count, given: " + channelCount + ", expected: " + this.channelCount))));
            }
        }

        @Override
        public final synchronized StorageRequestTaskStoreEntities enqueueStoreTask(Binary data) throws InterruptedException {
            this.validateChannelCount(data.channelCount());
            StorageRequestTaskStoreEntities task = this.taskCreator.createSaveTask(data, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public final synchronized StorageRequestTaskLoadByOids enqueueLoadTaskByOids(PersistenceIdSet[] loadOids) throws InterruptedException {
            this.validateChannelCount(loadOids.length);
            StorageRequestTaskLoadByOids task = this.taskCreator.createLoadTaskByOids(loadOids, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public final synchronized StorageRequestTaskLoadRoots enqueueRootsLoadTask() throws InterruptedException {
            StorageRequestTaskLoadRoots task = this.taskCreator.createRootsLoadTask(this.channelCount, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public final synchronized StorageRequestTaskLoadByTids enqueueLoadTaskByTids(PersistenceIdSet loadTids) throws InterruptedException {
            StorageRequestTaskLoadByTids task = this.taskCreator.createLoadTaskByTids(loadTids, this.channelCount, this.operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final synchronized StorageChannelTaskInitialize issueChannelInitialization(StorageOperationController operationController) throws InterruptedException {
            StorageTask currentHead;
            StorageChannelTaskInitialize task = this.taskCreator.createInitializationTask(this.channelCount, operationController);
            StorageTask storageTask = currentHead = this.uncheckedEnqueueTask(task, task);
            synchronized (storageTask) {
                currentHead.notifyAll();
            }
            return task;
        }

        @Override
        public final synchronized StorageChannelTaskShutdown issueChannelShutdown(StorageOperationController operationController) throws InterruptedException {
            StorageChannelTaskShutdown task = this.taskCreator.createShutdownTask(this.channelCount, operationController);
            this.enqueueTaskAndNotifyAll(task);
            return task;
        }

        @Override
        public StorageOperationController operationController() {
            return this.operationController;
        }
    }
}

