/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.types.Storage;

public interface StorageTimestampProvider {
    public long currentNanoTimestamp();

    public static final class Default
    implements StorageTimestampProvider {
        private long lastTimeMillis;
        private long currentOffset;

        @Override
        public synchronized long currentNanoTimestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis == this.lastTimeMillis) {
                return Storage.millisecondsToNanoseconds(currentTimeMillis) + ++this.currentOffset;
            }
            if (this.currentOffset != 0L) {
                this.currentOffset = 0L;
            }
            this.lastTimeMillis = currentTimeMillis;
            return Storage.millisecondsToNanoseconds(this.lastTimeMillis);
        }
    }
}

