/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import one.microstream.afs.nio.types.NioFileSystem;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFileSystem;
import one.microstream.storage.types.StorageBackupFileProvider;
import one.microstream.storage.types.StorageBackupSetup;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageConnection;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageLockFileSetup;

public final class Storage {
    private static final long ONE_MILLION = 1000000L;

    static final long millisecondsToNanoseconds(long milliseconds) {
        return milliseconds * 1000000L;
    }

    static final long nanosecondsToMilliseconds(long nanoseconds) {
        return nanoseconds / 1000000L;
    }

    static final long millisecondsToSeconds(long milliseconds) {
        return milliseconds / 1000000L;
    }

    public static NioFileSystem DefaultFileSystem() {
        return NioFileSystem.New();
    }

    public static ADirectory defaultStorageDirectory() {
        return Storage.defaultStorageDirectory((AFileSystem)Storage.DefaultFileSystem());
    }

    public static ADirectory defaultStorageDirectory(AFileSystem fileSystem) {
        return fileSystem.ensureRoot(StorageLiveFileProvider.Defaults.defaultStorageDirectory());
    }

    public static final StorageLiveFileProvider FileProvider() {
        return StorageLiveFileProvider.New();
    }

    public static final StorageLiveFileProvider FileProvider(Path storageDirectory) {
        NioFileSystem nfs = NioFileSystem.New((FileSystem)storageDirectory.getFileSystem());
        ADirectory dir = nfs.ensureDirectory((Object)storageDirectory);
        return StorageLiveFileProvider.New(dir);
    }

    public static final StorageLiveFileProvider FileProvider(ADirectory storageDirectory) {
        return StorageLiveFileProvider.New(storageDirectory);
    }

    public static final StorageLiveFileProvider.Builder<?> FileProviderBuilder() {
        return StorageLiveFileProvider.Builder();
    }

    public static final StorageLiveFileProvider.Builder<?> FileProviderBuilder(AFileSystem fileSystem) {
        return StorageLiveFileProvider.Builder(fileSystem);
    }

    public static final StorageBackupFileProvider BackupFileProvider() {
        return StorageBackupFileProvider.New();
    }

    @Deprecated
    public static final StorageBackupFileProvider BackupFileProvider(File storageDirectory) {
        return Storage.BackupFileProvider(storageDirectory.toPath());
    }

    public static final StorageBackupFileProvider BackupFileProvider(Path storageDirectory) {
        NioFileSystem nfs = NioFileSystem.New((FileSystem)storageDirectory.getFileSystem());
        ADirectory dir = nfs.resolveDirectory((Object)storageDirectory);
        return StorageBackupFileProvider.New(dir);
    }

    public static final StorageBackupFileProvider BackupFileProvider(ADirectory storageDirectory) {
        return StorageBackupFileProvider.New(storageDirectory);
    }

    public static final StorageBackupFileProvider.Builder<?> BackupFileProviderBuilder() {
        return StorageBackupFileProvider.Builder();
    }

    public static final StorageBackupFileProvider.Builder<?> BackupFileProviderBuilder(AFileSystem fileSystem) {
        return StorageBackupFileProvider.Builder(fileSystem);
    }

    public static final StorageConfiguration Configuration() {
        return StorageConfiguration.New();
    }

    public static final StorageConfiguration Configuration(StorageLiveFileProvider fileProvider) {
        return StorageConfiguration.New(fileProvider);
    }

    public static final StorageConfiguration.Builder<?> ConfigurationBuilder() {
        return StorageConfiguration.Builder();
    }

    public static final StorageHousekeepingController HousekeepingController() {
        return StorageHousekeepingController.New();
    }

    public static final StorageHousekeepingController HousekeepingController(long housekeepingIntervalMs, long housekeepingTimeBudgetNs) {
        return StorageHousekeepingController.New(housekeepingIntervalMs, housekeepingTimeBudgetNs);
    }

    public static final StorageEntityCacheEvaluator EntityCacheEvaluator() {
        return StorageEntityCacheEvaluator.New();
    }

    public static final StorageEntityCacheEvaluator EntityCacheEvaluator(long timeoutMs) {
        return StorageEntityCacheEvaluator.New(timeoutMs);
    }

    public static final StorageEntityCacheEvaluator EntityCacheEvaluator(long timeoutMs, long threshold) {
        return StorageEntityCacheEvaluator.New(timeoutMs, threshold);
    }

    public static final StorageChannelCountProvider ChannelCountProvider() {
        return StorageChannelCountProvider.New();
    }

    public static final StorageChannelCountProvider ChannelCountProvider(int channelCount) {
        return StorageChannelCountProvider.New(channelCount);
    }

    public static final StorageDataFileEvaluator DataFileEvaluator() {
        return StorageDataFileEvaluator.New();
    }

    public static final StorageDataFileEvaluator DataFileEvaluator(int fileMinimumSize, int fileMaximumSize) {
        return StorageDataFileEvaluator.New(fileMinimumSize, fileMaximumSize);
    }

    public static final StorageDataFileEvaluator DataFileEvaluator(int fileMinimumSize, int fileMaximumSize, double minimumUseRatio) {
        return StorageDataFileEvaluator.New(fileMinimumSize, fileMaximumSize, minimumUseRatio);
    }

    public static final StorageDataFileEvaluator DataFileEvaluator(int fileMinimumSize, int fileMaximumSize, double minimumUseRatio, boolean cleanUpHeadFile) {
        return StorageDataFileEvaluator.New(fileMinimumSize, fileMaximumSize, minimumUseRatio, cleanUpHeadFile);
    }

    public static final StorageBackupSetup BackupSetup(Path backupDirectory) {
        NioFileSystem nfs = NioFileSystem.New((FileSystem)backupDirectory.getFileSystem());
        ADirectory dir = nfs.ensureDirectory((Object)backupDirectory);
        return Storage.BackupSetup(dir);
    }

    public static final StorageBackupSetup BackupSetup(ADirectory backupDirectory) {
        return StorageBackupSetup.New(backupDirectory);
    }

    public static final StorageBackupSetup BackupSetup(String backupDirectoryPath) {
        return Storage.BackupSetup(Paths.get(backupDirectoryPath, new String[0]));
    }

    public static final StorageBackupSetup BackupSetup(StorageBackupFileProvider backupFileProvider) {
        return StorageBackupSetup.New(backupFileProvider);
    }

    public static StorageLockFileSetup.Provider LockFileSetupProvider() {
        return StorageLockFileSetup.Provider();
    }

    public static StorageLockFileSetup.Provider LockFileSetupProvider(Charset charset) {
        return StorageLockFileSetup.Provider(charset);
    }

    public static StorageLockFileSetup.Provider LockFileSetupProvider(long updateInterval) {
        return StorageLockFileSetup.Provider(updateInterval);
    }

    public static StorageLockFileSetup.Provider LockFileSetupProvider(Charset charset, long updateInterval) {
        return StorageLockFileSetup.Provider(charset, updateInterval);
    }

    public static final <C extends StorageConnection> C consolidate(C storageConnection, StorageEntityCacheEvaluator entityEvaluator) {
        storageConnection.issueFullGarbageCollection();
        storageConnection.issueFullFileCheck();
        storageConnection.issueFullCacheCheck(entityEvaluator);
        return storageConnection;
    }

    public static final <C extends StorageConnection> C consolidate(C storageConnection) {
        return Storage.consolidate(storageConnection, null);
    }

    private Storage() {
        throw new UnsupportedOperationException();
    }
}

