/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageBackupSetup;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.typing.Immutable;

public interface StorageConfiguration {
    public StorageChannelCountProvider channelCountProvider();

    public StorageHousekeepingController housekeepingController();

    public StorageEntityCacheEvaluator entityCacheEvaluator();

    public StorageLiveFileProvider fileProvider();

    public StorageDataFileEvaluator dataFileEvaluator();

    public StorageBackupSetup backupSetup();

    public static StorageConfiguration New() {
        return StorageConfiguration.Builder().createConfiguration();
    }

    public static StorageConfiguration New(StorageLiveFileProvider fileProvider) {
        return StorageConfiguration.Builder().setStorageFileProvider(fileProvider).createConfiguration();
    }

    public static StorageConfiguration New(StorageChannelCountProvider channelCountProvider, StorageHousekeepingController housekeepingController, StorageLiveFileProvider fileProvider, StorageDataFileEvaluator dataFileEvaluator, StorageEntityCacheEvaluator entityCacheEvaluator, StorageBackupSetup backupSetup) {
        return new Default((StorageChannelCountProvider)X.notNull((Object)channelCountProvider), (StorageHousekeepingController)X.notNull((Object)housekeepingController), (StorageLiveFileProvider)X.notNull((Object)fileProvider), (StorageDataFileEvaluator)X.notNull((Object)dataFileEvaluator), (StorageEntityCacheEvaluator)X.notNull((Object)entityCacheEvaluator), (StorageBackupSetup)X.mayNull((Object)backupSetup));
    }

    public static Builder<?> Builder() {
        return new Builder.Default();
    }

    public static interface Builder<B extends Builder<?>> {
        public StorageChannelCountProvider channelCountProvider();

        public B setChannelCountProvider(StorageChannelCountProvider var1);

        public StorageHousekeepingController housekeepingController();

        public B setHousekeepingController(StorageHousekeepingController var1);

        public StorageLiveFileProvider storagefileProvider();

        public B setStorageFileProvider(StorageLiveFileProvider var1);

        public StorageBackupSetup backupSetup();

        public B setBackupSetup(StorageBackupSetup var1);

        public StorageDataFileEvaluator dataFileEvaluator();

        public B setDataFileEvaluator(StorageDataFileEvaluator var1);

        public StorageEntityCacheEvaluator entityCacheEvaluator();

        public B setEntityCacheEvaluator(StorageEntityCacheEvaluator var1);

        public StorageConfiguration createConfiguration();

        public static class Default<B extends Default<?>>
        implements Builder<B> {
            private StorageChannelCountProvider channelCountProvider = this.initializeChannelCountProvider();
            private StorageHousekeepingController housekeepingController = this.initializeHousekeepingController();
            private StorageLiveFileProvider storageFileProvider = this.initializeLiveFileProvider();
            private StorageDataFileEvaluator dataFileEvaluator = this.initializeDataFileEvaluator();
            private StorageEntityCacheEvaluator entityCacheEvaluator = this.initializeEntityCacheEvaluator();
            private StorageBackupSetup backupSetup;

            Default() {
            }

            protected StorageChannelCountProvider initializeChannelCountProvider() {
                return Storage.ChannelCountProvider();
            }

            protected StorageHousekeepingController initializeHousekeepingController() {
                return Storage.HousekeepingController();
            }

            protected StorageLiveFileProvider initializeLiveFileProvider() {
                return Storage.FileProvider();
            }

            protected StorageDataFileEvaluator initializeDataFileEvaluator() {
                return Storage.DataFileEvaluator();
            }

            protected StorageEntityCacheEvaluator initializeEntityCacheEvaluator() {
                return Storage.EntityCacheEvaluator();
            }

            protected final B $() {
                return (B)this;
            }

            @Override
            public StorageChannelCountProvider channelCountProvider() {
                return this.channelCountProvider;
            }

            @Override
            public B setChannelCountProvider(StorageChannelCountProvider channelCountProvider) {
                this.channelCountProvider = channelCountProvider == null ? this.initializeChannelCountProvider() : channelCountProvider;
                return this.$();
            }

            @Override
            public StorageHousekeepingController housekeepingController() {
                return this.housekeepingController;
            }

            @Override
            public B setHousekeepingController(StorageHousekeepingController housekeepingController) {
                this.housekeepingController = housekeepingController == null ? this.initializeHousekeepingController() : housekeepingController;
                return this.$();
            }

            @Override
            public StorageLiveFileProvider storagefileProvider() {
                return this.storageFileProvider;
            }

            @Override
            public B setStorageFileProvider(StorageLiveFileProvider liveFileProvider) {
                this.storageFileProvider = liveFileProvider == null ? this.initializeLiveFileProvider() : liveFileProvider;
                return this.$();
            }

            @Override
            public StorageBackupSetup backupSetup() {
                return this.backupSetup;
            }

            @Override
            public B setBackupSetup(StorageBackupSetup backupSetup) {
                this.backupSetup = backupSetup;
                return this.$();
            }

            @Override
            public StorageDataFileEvaluator dataFileEvaluator() {
                return this.dataFileEvaluator;
            }

            @Override
            public B setDataFileEvaluator(StorageDataFileEvaluator dataFileEvaluator) {
                this.dataFileEvaluator = dataFileEvaluator == null ? this.initializeDataFileEvaluator() : dataFileEvaluator;
                return this.$();
            }

            @Override
            public StorageEntityCacheEvaluator entityCacheEvaluator() {
                return this.entityCacheEvaluator;
            }

            @Override
            public B setEntityCacheEvaluator(StorageEntityCacheEvaluator entityCacheEvaluator) {
                this.entityCacheEvaluator = entityCacheEvaluator == null ? this.initializeEntityCacheEvaluator() : entityCacheEvaluator;
                return this.$();
            }

            @Override
            public StorageConfiguration createConfiguration() {
                return StorageConfiguration.New(this.channelCountProvider, this.housekeepingController, this.storageFileProvider, this.dataFileEvaluator, this.entityCacheEvaluator, this.backupSetup);
            }
        }
    }

    public static class Default
    implements StorageConfiguration,
    Immutable {
        private final StorageChannelCountProvider channelCountProvider;
        private final StorageHousekeepingController housekeepingController;
        private final StorageLiveFileProvider fileProvider;
        private final StorageDataFileEvaluator dataFileEvaluator;
        private final StorageEntityCacheEvaluator entityCacheEvaluator;
        private final StorageBackupSetup backupSetup;

        Default(StorageChannelCountProvider channelCountProvider, StorageHousekeepingController housekeepingController, StorageLiveFileProvider fileProvider, StorageDataFileEvaluator dataFileEvaluator, StorageEntityCacheEvaluator entityCacheEvaluator, StorageBackupSetup backupSetup) {
            this.channelCountProvider = channelCountProvider;
            this.housekeepingController = housekeepingController;
            this.entityCacheEvaluator = entityCacheEvaluator;
            this.fileProvider = fileProvider;
            this.dataFileEvaluator = dataFileEvaluator;
            this.backupSetup = backupSetup;
        }

        @Override
        public StorageChannelCountProvider channelCountProvider() {
            return this.channelCountProvider;
        }

        @Override
        public StorageHousekeepingController housekeepingController() {
            return this.housekeepingController;
        }

        @Override
        public StorageEntityCacheEvaluator entityCacheEvaluator() {
            return this.entityCacheEvaluator;
        }

        @Override
        public StorageLiveFileProvider fileProvider() {
            return this.fileProvider;
        }

        @Override
        public StorageDataFileEvaluator dataFileEvaluator() {
            return this.dataFileEvaluator;
        }

        @Override
        public StorageBackupSetup backupSetup() {
            return this.backupSetup;
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().add((Object)this.channelCountProvider).lf().add((Object)this.fileProvider).lf().add((Object)this.housekeepingController).lf().add((Object)this.entityCacheEvaluator).lf().add((Object)this.dataFileEvaluator).lf().add(this.backupSetup == null ? StorageBackupSetup.class.getName() + ": null" : this.backupSetup).lf().toString();
        }
    }
}

