/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.chars.VarString;
import one.microstream.storage.types.StorageEntity;

@FunctionalInterface
public interface StorageEntityCacheEvaluator {
    public boolean clearEntityCache(long var1, long var3, StorageEntity var5);

    default public boolean initiallyCacheEntity(long totalCacheSize, long evaluationTime, StorageEntity entity) {
        return !this.clearEntityCache(totalCacheSize, evaluationTime, entity);
    }

    public static StorageEntityCacheEvaluator New() {
        return StorageEntityCacheEvaluator.New(Defaults.defaultTimeoutMs(), Defaults.defaultCacheThreshold());
    }

    public static StorageEntityCacheEvaluator New(long timeoutMs) {
        return StorageEntityCacheEvaluator.New(timeoutMs, Defaults.defaultCacheThreshold());
    }

    public static StorageEntityCacheEvaluator New(long timeoutMs, long threshold) {
        Validation.validateParameters(timeoutMs, threshold);
        return new Default(timeoutMs, threshold);
    }

    public static final class Default
    implements StorageEntityCacheEvaluator {
        private static final int C16 = 16;
        private final long timeoutMs;
        private final long threshold;

        Default(long timeoutMs, long threshold) {
            this.timeoutMs = timeoutMs;
            this.threshold = threshold;
        }

        public long timeout() {
            return this.timeoutMs;
        }

        public long threshold() {
            return this.threshold;
        }

        @Override
        public final boolean clearEntityCache(long cacheSize, long evalTime, StorageEntity e) {
            long ageInMs = evalTime - e.lastTouched();
            return ageInMs >= this.timeoutMs || this.threshold - cacheSize < e.cachedDataLength() * (ageInMs >> 16) << (e.hasReferences() ? 0 : 1);
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().blank().add("threshold ").tab().add('=').blank().add(this.threshold).lf().blank().add("timeout   ").tab().add('=').blank().add(this.timeoutMs).toString();
        }
    }

    public static interface Validation {
        public static long minimumTimeoutMs() {
            return 1L;
        }

        public static long minimumThreshold() {
            return 1L;
        }

        public static void validateParameters(long timeoutMs, long threshold) throws IllegalArgumentException {
            if (timeoutMs < Validation.minimumTimeoutMs()) {
                throw new IllegalArgumentException("Specified millisecond timeout of " + timeoutMs + " is lower than the minimum value " + Validation.minimumTimeoutMs() + ".");
            }
            if (threshold < Validation.minimumThreshold()) {
                throw new IllegalArgumentException("Specified threshold of " + threshold + " is lower than the minimum value " + Validation.minimumThreshold() + ".");
            }
        }
    }

    public static interface Defaults {
        public static long defaultCacheThreshold() {
            return 1000000000L;
        }

        public static long defaultTimeoutMs() {
            return 86400000L;
        }
    }
}

