/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.storage.exceptions.StorageExceptionIo;
import one.microstream.storage.exceptions.StorageExceptionIoWriting;
import one.microstream.storage.types.StorageChannelFile;
import one.microstream.storage.types.StorageFile;
import one.microstream.storage.types.StorageFileProvider;
import one.microstream.storage.types.StorageImportSource;
import one.microstream.storage.types.StorageLiveChannelFile;
import one.microstream.storage.types.StorageLiveDataFile;
import one.microstream.storage.types.StorageLiveTransactionsFile;
import one.microstream.storage.types.StorageTruncatableChannelFile;
import one.microstream.storage.types.StorageWriteController;

public interface StorageFileWriter {
    public static long validateIoByteCount(long specifiedByteCount, long actualByteCount) {
        if (specifiedByteCount == actualByteCount) {
            return actualByteCount;
        }
        throw new StorageExceptionIoWriting("Inconsistent IO operation: actual byte count " + actualByteCount + " does not match the specified byte count if  " + specifiedByteCount + ".");
    }

    default public long write(StorageFile file, Iterable<? extends ByteBuffer> buffers) {
        return file.writeBytes(buffers);
    }

    default public long writeStore(StorageLiveDataFile targetFile, Iterable<? extends ByteBuffer> byteBuffers) {
        return this.write(targetFile, byteBuffers);
    }

    default public long writeImport(StorageImportSource source, long sourceOffset, long copyLength, StorageLiveDataFile targetFile) {
        return source.copyTo(targetFile, sourceOffset, copyLength);
    }

    default public long writeTransfer(StorageLiveDataFile sourceFile, long sourceOffset, long copyLength, StorageLiveDataFile targetFile) {
        return sourceFile.copyTo(targetFile, sourceOffset, copyLength);
    }

    default public long writeTransactionEntryCreate(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile) {
        return this.write(transactionFile, byteBuffers);
    }

    default public long writeTransactionEntryStore(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile, long dataFileOffset, long storeLength) {
        return this.write(transactionFile, byteBuffers);
    }

    default public long writeTransactionEntryTransfer(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile, long dataFileOffset, long storeLength) {
        return this.write(transactionFile, byteBuffers);
    }

    default public long writeTransactionEntryDelete(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile) {
        return this.write(transactionFile, byteBuffers);
    }

    default public long writeTransactionEntryTruncate(StorageLiveTransactionsFile transactionFile, Iterable<? extends ByteBuffer> byteBuffers, StorageLiveDataFile dataFile, long newFileLength) {
        return this.write(transactionFile, byteBuffers);
    }

    default public void truncate(StorageLiveChannelFile<?> file, long newLength, StorageFileProvider fileProvider) {
        StorageFileWriter.truncateFile(file, newLength, fileProvider);
    }

    public static void truncateFile(StorageTruncatableChannelFile file, long newLength, StorageFileProvider fileProvider) {
        AFile truncationTargetFile = fileProvider.provideTruncationTargetFile(file, newLength);
        if (truncationTargetFile != null) {
            StorageFileWriter.createFileFullCopy(file, truncationTargetFile);
        }
        try {
            file.truncate(newLength);
        }
        catch (Exception e) {
            throw new StorageExceptionIoWriting(e);
        }
    }

    default public void delete(StorageLiveDataFile file, StorageWriteController writeController, StorageFileProvider fileProvider) {
        StorageFileWriter.deleteFile(file, writeController, fileProvider);
    }

    public static void deleteFile(StorageChannelFile file, StorageWriteController writeController, StorageFileProvider fileProvider) {
        writeController.validateIsFileDeletionEnabled();
        if (StorageFileWriter.rescueFromDeletion(file, writeController, fileProvider)) {
            return;
        }
        file.delete();
    }

    public static void createFileFullCopy(StorageFile sourceFile, AFile targetFile) {
        try {
            if (!sourceFile.exists()) {
                throw new IOException("Copying source file does not exist: " + sourceFile);
            }
            if (targetFile.exists()) {
                throw new IOException("Copying target already exist: " + targetFile);
            }
            AFS.executeWriting((AFile)targetFile, wf -> sourceFile.copyTo((AWritableFile)wf));
        }
        catch (Exception e) {
            throw new StorageExceptionIoWriting(e);
        }
    }

    public static boolean rescueFromDeletion(StorageChannelFile file, StorageWriteController writeController, StorageFileProvider fileProvider) {
        if (!writeController.isDeletionDirectoryEnabled()) {
            return false;
        }
        AFile deletionTargetFile = fileProvider.provideDeletionTargetFile(file);
        if (deletionTargetFile == null) {
            return false;
        }
        if (deletionTargetFile.exists()) {
            throw new StorageExceptionIo("Moving target already exist: " + deletionTargetFile);
        }
        try {
            writeController.validateIsDeletionDirectoryEnabled();
            AFS.executeWriting((AFile)deletionTargetFile, wf -> file.moveTo((AWritableFile)wf));
        }
        catch (Exception e) {
            throw new StorageExceptionIoWriting(e);
        }
        return true;
    }

    @FunctionalInterface
    public static interface Provider {
        public StorageFileWriter provideWriter();

        default public StorageFileWriter provideWriter(int channelIndex) {
            return this.provideWriter();
        }

        public static final class Default
        implements Provider {
            @Override
            public StorageFileWriter provideWriter() {
                return new one.microstream.storage.types.StorageFileWriter$Default();
            }
        }
    }

    public static final class Default
    implements StorageFileWriter {
    }
}

