/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.chars.VarString;

public interface StorageHousekeepingController {
    public long housekeepingIntervalMs();

    public long housekeepingTimeBudgetNs();

    public long garbageCollectionTimeBudgetNs();

    public long liveCheckTimeBudgetNs();

    public long fileCheckTimeBudgetNs();

    public static StorageHousekeepingController New() {
        return new Default(Defaults.defaultHousekeepingIntervalMs(), Defaults.defaultHousekeepingTimeBudgetNs());
    }

    public static StorageHousekeepingController New(long housekeepingIntervalMs, long housekeepingTimeBudgetNs) {
        Validation.validateParameters(housekeepingIntervalMs, housekeepingTimeBudgetNs);
        return new Default(housekeepingIntervalMs, housekeepingTimeBudgetNs);
    }

    public static final class Default
    implements StorageHousekeepingController {
        private final long intervalMs;
        private final long nanoTimeBudget;

        Default(long intervalMs, long nanoTimeBudget) {
            this.intervalMs = intervalMs;
            this.nanoTimeBudget = nanoTimeBudget;
        }

        @Override
        public final long housekeepingIntervalMs() {
            return this.intervalMs;
        }

        @Override
        public final long housekeepingTimeBudgetNs() {
            return this.nanoTimeBudget;
        }

        @Override
        public final long garbageCollectionTimeBudgetNs() {
            return this.housekeepingTimeBudgetNs();
        }

        @Override
        public final long liveCheckTimeBudgetNs() {
            return this.housekeepingTimeBudgetNs();
        }

        @Override
        public final long fileCheckTimeBudgetNs() {
            return this.housekeepingTimeBudgetNs();
        }

        public String toString() {
            return VarString.New().add(this.getClass().getName()).add(':').lf().blank().add("house keeping interval").tab().add('=').blank().add(this.intervalMs).lf().blank().add("house keeping nano time budget").tab().add('=').blank().add(this.nanoTimeBudget).toString();
        }
    }

    public static interface Defaults {
        public static long defaultHousekeepingIntervalMs() {
            return 1000L;
        }

        public static long defaultHousekeepingTimeBudgetNs() {
            return 10000000L;
        }
    }

    public static interface Validation {
        public static long minimumHousekeepingIntervalMs() {
            return 1L;
        }

        public static long minimumHousekeepingTimeBudgetNs() {
            return 0L;
        }

        public static void validateParameters(long housekeepingIntervalMs, long housekeepingTimeBudgetNs) throws IllegalArgumentException {
            if (housekeepingIntervalMs < Validation.minimumHousekeepingIntervalMs()) {
                throw new IllegalArgumentException("Specified housekeeping millisecond interval of " + housekeepingIntervalMs + " is lower than the minimum value " + Validation.minimumHousekeepingIntervalMs() + ".");
            }
            if (housekeepingTimeBudgetNs < Validation.minimumHousekeepingTimeBudgetNs()) {
                throw new IllegalArgumentException("Specified housekeeping nanosecond time budget of " + housekeepingTimeBudgetNs + " is lower than the minimum value " + Validation.minimumHousekeepingTimeBudgetNs() + ".");
            }
        }
    }
}

