/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.afs.types.AFile;
import one.microstream.math.XMath;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.types.StorageBackupDataFile;
import one.microstream.storage.types.StorageBackupInventory;
import one.microstream.storage.types.StorageCreatableFile;
import one.microstream.storage.types.StorageDataFile;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageDataInventoryFile;
import one.microstream.storage.types.StorageEntity;
import one.microstream.storage.types.StorageEntityType;
import one.microstream.storage.types.StorageFileManager;
import one.microstream.storage.types.StorageFileUser;
import one.microstream.storage.types.StorageLiveChannelFile;
import one.microstream.storage.types.StorageLiveFile;
import one.microstream.storage.types.TypeInFile;

public interface StorageLiveDataFile
extends StorageDataFile,
StorageLiveChannelFile<StorageLiveDataFile>,
StorageCreatableFile {
    public long totalLength();

    public long dataLength();

    public double dataFillRatio();

    public boolean isHeadFile();

    public boolean hasSingleEntity();

    @Override
    default public StorageBackupDataFile ensureBackupFile(StorageBackupInventory backupInventory) {
        return backupInventory.ensureDataFile(this);
    }

    public static Default New(StorageFileManager.Default parent, StorageDataInventoryFile inventoryFile) {
        return new Default((StorageFileManager.Default)X.notNull((Object)parent), (AFile)X.notNull((Object)inventoryFile.file()), XMath.notNegative((int)inventoryFile.channelIndex()), XMath.notNegative((long)inventoryFile.number()));
    }

    public static class Default
    extends StorageLiveFile.Abstract<StorageLiveDataFile>
    implements StorageLiveDataFile {
        private static final int INITIAL_TYPE_IN_FILE_ARRAY_LENGTH = 8;
        private final int channelIndex;
        private final long number;
        private final StorageFileManager.Default parent;
        final StorageEntity.Default head = StorageEntity.Default.createDummy();
        final StorageEntity.Default tail = StorageEntity.Default.createDummy();
        private long fileTotalLength;
        private long fileDataLength;
        Default next;
        Default prev;
        private TypeInFile[] typeInFileSlots = new TypeInFile[8];
        private int typeInFileRange = this.typeInFileSlots.length - 1;
        private int typeInFileCount;

        protected Default(StorageFileManager.Default parent, AFile file, int channelIndex, long number) {
            super(file);
            this.channelIndex = channelIndex;
            this.number = number;
            this.parent = parent;
            this.head.fileNext = this.tail;
            this.tail.filePrev = this.head;
            this.registerUsage(parent);
        }

        @Override
        public final int channelIndex() {
            return this.channelIndex;
        }

        @Override
        public final long number() {
            return this.number;
        }

        @Override
        public long dataLength() {
            return this.fileDataLength;
        }

        @Override
        public long totalLength() {
            return this.fileTotalLength;
        }

        final TypeInFile typeInFile(StorageEntityType.Default type) {
            TypeInFile t = this.typeInFileSlots[System.identityHashCode(type) & this.typeInFileRange];
            while (t != null) {
                if (t.type == type) {
                    return t;
                }
                t = t.hashNext;
            }
            return this.createTypeInFile(type);
        }

        private TypeInFile createTypeInFile(StorageEntityType.Default type) {
            if (this.typeInFileCount == this.typeInFileRange) {
                this.rebuildTypeInFileTable();
            }
            TypeInFile typeInFile = new TypeInFile(type, this, this.typeInFileSlots[System.identityHashCode(type) & this.typeInFileRange]);
            this.typeInFileSlots[System.identityHashCode((Object)type) & this.typeInFileRange] = typeInFile;
            TypeInFile newInstance = typeInFile;
            ++this.typeInFileCount;
            return newInstance;
        }

        private void rebuildTypeInFileTable() {
            int newModulo = (this.typeInFileRange + 1 << 1) - 1;
            TypeInFile[] newSlots = new TypeInFile[newModulo + 1];
            for (TypeInFile entries : this.typeInFileSlots) {
                while (entries != null) {
                    TypeInFile next = entries.hashNext;
                    entries.hashNext = newSlots[System.identityHashCode(entries) & newModulo];
                    newSlots[System.identityHashCode((Object)entries) & newModulo] = entries;
                    entries = next;
                }
            }
            this.typeInFileSlots = newSlots;
            this.typeInFileRange = newModulo;
        }

        final void detach() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }

        final void registerGapLength(long length) {
            this.fileTotalLength += length;
        }

        final boolean needsRetirement(StorageDataFileEvaluator configuration) {
            return configuration.needsRetirement(this.fileTotalLength);
        }

        final boolean hasNoDataBytes() {
            return this.fileDataLength == 0L;
        }

        final boolean hasNoBytes() {
            return this.fileTotalLength == 0L;
        }

        final boolean hasOnlyGapBytes() {
            return this.fileDataLength == 0L && this.fileTotalLength > 0L;
        }

        final boolean hasContent() {
            return this.fileDataLength != 0L;
        }

        final void increaseContentLength(long byteCount) {
            this.fileTotalLength += byteCount;
            this.fileDataLength += byteCount;
        }

        public boolean executeIfUnsuedData(Consumer<? super Default> action) {
            return this.executeIfUnsued(file -> action.accept(this));
        }

        public final boolean unregisterUsageClosingData(StorageFileUser fileUser, Consumer<? super Default> closingAction) {
            return this.unregisterUsageClosing(fileUser, file -> closingAction.accept(this));
        }

        @Override
        protected synchronized boolean internalOpenWriting() {
            boolean wasNewlyOpened = super.internalOpenWriting();
            if (!wasNewlyOpened) {
                return false;
            }
            long expectedSize = this.totalLength();
            if (expectedSize == 0L) {
                return true;
            }
            long actualSize = this.ensureReadable().size();
            if (actualSize != expectedSize) {
                throw new StorageExceptionConsistency("Reopened file has inconsistent size: Expected size " + expectedSize + " != actual size " + actualSize + ".");
            }
            return true;
        }

        @Override
        public final double dataFillRatio() {
            return (double)this.fileDataLength / (double)this.fileTotalLength;
        }

        @Override
        public final boolean hasSingleEntity() {
            return (long)this.head.fileNext.length == this.fileDataLength;
        }

        public final void remove(StorageEntity.Default entity) {
            entity.fileNext.filePrev = entity.filePrev;
            entity.filePrev.fileNext = entity.fileNext;
            this.decrementDataLength(entity.length);
        }

        final void removeHeadBoundChain(StorageEntity.Default newFirst, long copylength) {
            if (newFirst == this.tail) {
                if (copylength != this.dataLength()) {
                    throw new StorageExceptionConsistency("Inconsistent file clearing transfer length of " + copylength + " in " + this);
                }
            } else if (copylength >= this.dataLength()) {
                throw new StorageExceptionConsistency("Inconsistent file partial transfer length of " + copylength + " in " + this);
            }
            this.decrementDataLength(copylength);
            this.head.fileNext = newFirst;
            newFirst.filePrev = this.head;
        }

        final void addChainToTail(StorageEntity.Default first, StorageEntity.Default last) {
            this.tail.filePrev.fileNext = first;
            first.filePrev = this.tail.filePrev;
            this.tail.filePrev = last;
            last.fileNext = this.tail;
        }

        final void decrementDataLength(long value) {
            this.fileDataLength -= value;
        }

        public final void prependEntry(StorageEntity.Default entry) {
            entry.typeInFile = this.typeInFile(entry.typeInFile.type);
            entry.filePrev = this.head;
            entry.fileNext = this.head.fileNext;
            this.head.fileNext = this.head.fileNext.filePrev = entry;
        }

        public final void appendEntry(StorageEntity.Default entry) {
            entry.typeInFile = this.typeInFile(entry.typeInFile.type);
            entry.fileNext = this.tail;
            entry.filePrev = this.tail.filePrev;
            this.tail.filePrev = this.tail.filePrev.fileNext = entry;
        }

        public final void loadEntityData(StorageEntity.Default entity, long length, long cacheChange) {
            this.parent.loadData(this, entity, length, cacheChange);
        }

        @Override
        public boolean isHeadFile() {
            return this.parent.isHeadFile(this);
        }

        @Override
        public final String toString() {
            return this.getClass().getSimpleName() + " " + this.file().identifier() + " (" + this.fileDataLength + " / " + this.fileTotalLength + ", " + XMath.fractionToPercent((double)this.dataFillRatio()) + ")";
        }
    }
}

