/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.lang.ref.WeakReference;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.storage.exceptions.StorageExceptionDisruptingExceptions;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageSystem;

public interface StorageOperationController {
    public StorageChannelCountProvider channelCountProvider();

    public boolean isChannelProcessingEnabled();

    public boolean checkProcessingEnabled() throws StorageExceptionDisruptingExceptions;

    public void registerDisruption(Throwable var1);

    public XGettingSequence<Throwable> disruptions();

    default public boolean hasDisruptions() {
        return !this.disruptions().isEmpty();
    }

    public void setChannelProcessingEnabled(boolean var1);

    public void activate();

    public void deactivate();

    public static StorageOperationController New(StorageSystem storageSystem, StorageChannelCountProvider channelCountProvider) {
        return new Default(new WeakReference<StorageSystem>(storageSystem), channelCountProvider);
    }

    public static Creator Provider() {
        return new Creator.Default();
    }

    public static interface Creator {
        public StorageOperationController createOperationController(StorageChannelCountProvider var1, StorageSystem var2);

        public static final class Default
        implements Creator {
            Default() {
            }

            @Override
            public final StorageOperationController createOperationController(StorageChannelCountProvider channelCountProvider, StorageSystem storageSystem) {
                return StorageOperationController.New(storageSystem, channelCountProvider);
            }
        }
    }

    public static final class Default
    implements StorageOperationController {
        private final WeakReference<StorageSystem> storageSystemReference;
        private final StorageChannelCountProvider channelCountProvider;
        private final BulkList<Throwable> disruptions = BulkList.New();
        private boolean hasDisruptions;
        private boolean channelProcessingEnabled;

        Default(WeakReference<StorageSystem> storageSystemReference, StorageChannelCountProvider channelCountProvider) {
            this.storageSystemReference = storageSystemReference;
            this.channelCountProvider = channelCountProvider;
        }

        @Override
        public final synchronized void setChannelProcessingEnabled(boolean enabled) {
            this.channelProcessingEnabled = enabled;
        }

        @Override
        public final synchronized boolean isChannelProcessingEnabled() {
            return this.channelProcessingEnabled;
        }

        @Override
        public final StorageChannelCountProvider channelCountProvider() {
            return this.channelCountProvider;
        }

        @Override
        public final synchronized void activate() {
            this.channelProcessingEnabled = true;
        }

        @Override
        public final synchronized void deactivate() {
            this.channelProcessingEnabled = false;
        }

        @Override
        public final synchronized boolean checkProcessingEnabled() throws StorageExceptionDisruptingExceptions {
            if (this.hasDisruptions) {
                throw new StorageExceptionDisruptingExceptions((XGettingSequence<Throwable>)this.disruptions.immure());
            }
            if (this.storageSystemReference.get() == null) {
                this.deactivate();
            }
            return this.channelProcessingEnabled;
        }

        @Override
        public final synchronized void registerDisruption(Throwable disruption) {
            this.disruptions.add((Object)disruption);
            this.hasDisruptions = true;
            this.channelProcessingEnabled = false;
        }

        @Override
        public final synchronized XGettingSequence<Throwable> disruptions() {
            return this.disruptions.immure();
        }

        @Override
        public final synchronized boolean hasDisruptions() {
            return this.hasDisruptions;
        }
    }
}

