/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AReadableFile;
import one.microstream.chars.VarString;
import one.microstream.collections.ConstList;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.exceptions.IndexBoundsException;
import one.microstream.memory.XMemory;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.exceptions.StorageExceptionIoReading;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageLiveTransactionsFile;
import one.microstream.storage.types.StorageTransactionEntry;
import one.microstream.storage.types.StorageTransactionsEntryType;

public interface StorageTransactionsAnalysis {
    public long headFileLastConsistentStoreLength();

    public long headFileLastConsistentStoreTimestamp();

    public long headFileLatestLength();

    public long headFileLatestTimestamp();

    public StorageLiveTransactionsFile transactionsFile();

    public XGettingTable<Long, ? extends StorageTransactionEntry> transactionsFileEntries();

    default public boolean isEmpty() {
        return this.transactionsFileEntries().isEmpty();
    }

    public static final class Default
    implements StorageTransactionsAnalysis {
        private final StorageLiveTransactionsFile transactionsFile;
        private final XGettingTable<Long, ? extends StorageTransactionEntry> transactionsFileEntries;
        private final long headFileLastConsistentStoreLength;
        private final long headFileLastConsistentStoreTimestamp;
        private final long headFileLatestLength;
        private final long headFileLatestTimestamp;

        Default(StorageLiveTransactionsFile transactionsFile, XGettingTable<Long, ? extends StorageTransactionEntry> transactionsFileEntries, long headFileLastConsistentStoreLength, long headFileLastConsistentStoreTimestamp, long headFileLatestLength, long headFileLatestTimestamp) {
            this.transactionsFile = (StorageLiveTransactionsFile)X.notNull((Object)transactionsFile);
            this.transactionsFileEntries = transactionsFileEntries;
            this.headFileLastConsistentStoreLength = headFileLastConsistentStoreLength;
            this.headFileLastConsistentStoreTimestamp = headFileLastConsistentStoreTimestamp;
            this.headFileLatestLength = headFileLatestLength;
            this.headFileLatestTimestamp = headFileLatestTimestamp;
        }

        @Override
        public final StorageLiveTransactionsFile transactionsFile() {
            return this.transactionsFile;
        }

        @Override
        public final XGettingTable<Long, ? extends StorageTransactionEntry> transactionsFileEntries() {
            return this.transactionsFileEntries;
        }

        @Override
        public final long headFileLastConsistentStoreLength() {
            return this.headFileLastConsistentStoreLength;
        }

        @Override
        public final long headFileLastConsistentStoreTimestamp() {
            return this.headFileLastConsistentStoreTimestamp;
        }

        @Override
        public final long headFileLatestLength() {
            return this.headFileLatestLength;
        }

        @Override
        public final long headFileLatestTimestamp() {
            return this.headFileLatestTimestamp;
        }
    }

    public static final class EntryAggregator
    implements EntryIterator {
        private final EqHashTable<Long, StorageTransactionEntry.Default> files = EqHashTable.New();
        private final int hashIndex;
        private long lastConsistentStoreLength;
        private long lastConsistentStoreTimestamp;
        private long currentStoreLength;
        private long currentStoreTimestamp;
        private long currentFileNumber = -1L;

        public EntryAggregator(int hashIndex) {
            this.hashIndex = hashIndex;
        }

        @Override
        public boolean accept(long address, long availableItemLength) {
            if (availableItemLength < 0L) {
                return true;
            }
            switch (Logic.getEntryType(address)) {
                case 0: {
                    return this.handleEntryFileCreation(address, availableItemLength);
                }
                case 1: {
                    return this.handleEntryStore(address, availableItemLength);
                }
                case 2: {
                    return this.handleEntryTransfer(address, availableItemLength);
                }
                case 3: {
                    return this.handleEntryFileTruncation(address, availableItemLength);
                }
                case 4: {
                    return this.handleEntryFileDeletion(address, availableItemLength);
                }
            }
            throw new StorageException("Unknown transactions entry type: " + Logic.getEntryType(address));
        }

        private boolean handleEntryFileCreation(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_FILE_CREATION) {
                return false;
            }
            long number = Logic.getFileNumber(address);
            if (number <= this.currentFileNumber) {
                throw new StorageExceptionConsistency(this.hashIndex + " Inconsistent file number order of new file: " + number + " <= " + this.currentFileNumber);
            }
            long fileLength = Logic.getFileLength(address);
            if (fileLength < 0L) {
                throw new StorageExceptionConsistency(this.hashIndex + " Inconsistent file length of new file " + number + ": " + fileLength);
            }
            this.registerCurrentFile();
            this.lastConsistentStoreTimestamp = this.currentStoreTimestamp;
            this.lastConsistentStoreLength = this.currentStoreLength = fileLength;
            this.currentFileNumber = number;
            return true;
        }

        private void registerCurrentFile() {
            if (this.currentFileNumber < 0L) {
                return;
            }
            this.files.add((Object)this.currentFileNumber, (Object)new StorageTransactionEntry.Default(this.currentFileNumber, this.currentStoreLength));
        }

        private boolean handleEntryStore(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_STORE) {
                return false;
            }
            long fileLength = Logic.getFileLength(address);
            if (fileLength < this.currentStoreLength) {
                throw new StorageExceptionConsistency(this.hashIndex + " Inconsistent file length of file " + this.currentFileNumber + ": " + fileLength + " < " + this.currentStoreLength);
            }
            long timestamp = Logic.getEntryTimestamp(address);
            if (timestamp <= this.currentStoreTimestamp) {
                throw new StorageExceptionConsistency(this.hashIndex + " Inconsistent timestamp of file " + this.currentFileNumber + ": " + timestamp + " <= " + this.currentStoreTimestamp);
            }
            this.lastConsistentStoreTimestamp = this.currentStoreTimestamp;
            this.lastConsistentStoreLength = this.currentStoreLength;
            this.currentStoreTimestamp = timestamp;
            this.currentStoreLength = fileLength;
            return true;
        }

        private boolean handleEntryTransfer(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_TRANSFER) {
                return false;
            }
            long fileLength = Logic.getFileLength(address);
            if (fileLength < this.currentStoreLength) {
                throw new StorageExceptionConsistency(this.hashIndex + " Inconsistent file length of file " + this.currentFileNumber + ": " + fileLength + " < " + this.currentStoreLength);
            }
            this.lastConsistentStoreLength = this.currentStoreLength = fileLength;
            return true;
        }

        private boolean handleEntryFileTruncation(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_FILE_TRUNCATION) {
                return false;
            }
            long fileNumber = Logic.getFileNumber(address);
            if (fileNumber != this.currentFileNumber) {
                throw new StorageException(this.hashIndex + " Invalid truncation file number: " + fileNumber + " (file " + this.currentFileNumber + ")");
            }
            long newLength = Logic.getFileLength(address);
            if (newLength < 0L || newLength > this.currentStoreLength) {
                throw new StorageExceptionConsistency("Inconsistent new length in truncation entry: " + newLength + " vs. " + this.currentStoreLength + " (file " + this.currentFileNumber + ")");
            }
            this.lastConsistentStoreLength = this.currentStoreLength = newLength;
            return true;
        }

        private boolean handleEntryFileDeletion(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_FILE_DELETION) {
                return false;
            }
            long number = Logic.getFileNumber(address);
            StorageTransactionEntry.Default file = (StorageTransactionEntry.Default)this.files.get((Object)number);
            if (file == null) {
                throw new StorageException(this.hashIndex + " No file found in entries with number " + number);
            }
            file.isDeleted = true;
            return true;
        }

        final StorageTransactionsAnalysis yield(StorageLiveTransactionsFile transactionsFile) {
            this.registerCurrentFile();
            return new Default(transactionsFile, (XGettingTable<Long, ? extends StorageTransactionEntry>)this.files, this.lastConsistentStoreLength, this.lastConsistentStoreTimestamp, this.currentStoreLength, this.currentStoreTimestamp);
        }
    }

    public static final class EntryAssembler
    implements EntryIterator {
        private final VarString vs;
        private long currentHeadFileNumber;
        private long lastFileLength;
        private long lastTimestamp;

        private static String formateTimeStamp(Date timestamp) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").format(timestamp);
        }

        public static XGettingSequence<String> header() {
            return ConstList.New((Object[])new String[]{"Type", "Timestamp", "Time Delta (ms)", "Resulting Length", "Length Change", "Current Head File", "Significant File", "Special Offset"});
        }

        public static VarString assembleHeader(VarString vs, String separator) {
            X.notNull((Object)separator);
            for (String s : EntryAssembler.header()) {
                vs.add(s).add(separator);
            }
            vs.deleteLast(separator.length());
            return vs;
        }

        public EntryAssembler(VarString vs) {
            this.vs = vs;
        }

        public VarString content() {
            return this.vs;
        }

        @Override
        public boolean accept(long address, long availableEntryLength) {
            if (availableEntryLength < 0L) {
                return this.assembleGap(address, -availableEntryLength);
            }
            switch (Logic.getEntryType(address)) {
                case 0: {
                    return this.assembleEntryFileCreation(address, availableEntryLength);
                }
                case 1: {
                    return this.assembleEntryStore(address, availableEntryLength);
                }
                case 2: {
                    return this.assembleEntryTransfer(address, availableEntryLength);
                }
                case 3: {
                    return this.assembleEntryFileTruncation(address, availableEntryLength);
                }
                case 4: {
                    return this.assembleEntryFileDeletion(address, availableEntryLength);
                }
            }
            throw new StorageException("Unknown transactions entry type: " + Logic.getEntryType(address));
        }

        private boolean assembleGap(long address, long availableItemLength) {
            char[] array = new char[(int)availableItemLength >> 1];
            XMemory.copyRangeToArray((long)address, (char[])array);
            this.vs.add(array);
            return true;
        }

        private void addCommonTimestampPart(long address) {
            long timestamp = Logic.getEntryTimestamp(address);
            this.vs.add(EntryAssembler.formateTimeStamp(new Date(Storage.millisecondsToSeconds(timestamp)))).tab().add(Storage.millisecondsToSeconds(timestamp - this.lastTimestamp)).tab();
            this.lastTimestamp = timestamp;
        }

        private void addCommonFileLengthDifference(long address) {
            this.vs.add(Logic.getFileLength(address)).tab().add(Logic.getFileLength(address) - this.lastFileLength).tab();
            this.lastFileLength = Logic.getFileLength(address);
        }

        private void addCommonCurrentHeadFile() {
            this.vs.add(this.currentHeadFileNumber).tab();
        }

        private boolean assembleEntryFileCreation(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_FILE_CREATION) {
                return false;
            }
            this.lastFileLength = 0L;
            this.vs.add(StorageTransactionsEntryType.FILE_CREATION.typeName()).tab();
            this.addCommonTimestampPart(address);
            this.addCommonFileLengthDifference(address);
            this.addCommonCurrentHeadFile();
            this.currentHeadFileNumber = Logic.getFileNumber(address);
            this.vs.add(this.currentHeadFileNumber).lf();
            return true;
        }

        private boolean assembleEntryStore(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_STORE) {
                return false;
            }
            this.vs.add(StorageTransactionsEntryType.DATA_STORE.typeName()).tab();
            this.addCommonTimestampPart(address);
            this.addCommonFileLengthDifference(address);
            this.addCommonCurrentHeadFile();
            this.vs.deleteLast().lf();
            return true;
        }

        private boolean assembleEntryTransfer(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_TRANSFER) {
                return false;
            }
            this.vs.add(StorageTransactionsEntryType.DATA_TRANSFER.typeName()).tab();
            this.addCommonTimestampPart(address);
            this.addCommonFileLengthDifference(address);
            this.addCommonCurrentHeadFile();
            this.vs.add(Logic.getFileNumber(address)).tab().add(Logic.getSpecialOffset(address)).lf();
            return true;
        }

        private boolean assembleEntryFileTruncation(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_FILE_TRUNCATION) {
                return false;
            }
            this.vs.add(StorageTransactionsEntryType.FILE_TRUNCATION.typeName()).tab();
            this.addCommonTimestampPart(address);
            this.addCommonFileLengthDifference(address);
            this.addCommonCurrentHeadFile();
            this.vs.add(Logic.getFileNumber(address)).tab().add(Logic.getSpecialOffset(address)).lf();
            return true;
        }

        private boolean assembleEntryFileDeletion(long address, long availableItemLength) {
            if (availableItemLength < (long)Logic.LENGTH_FILE_DELETION) {
                return false;
            }
            this.vs.add(StorageTransactionsEntryType.FILE_DELETION.typeName()).tab();
            this.addCommonTimestampPart(address);
            this.vs.add('0').tab().add(-Logic.getFileLength(address)).tab();
            this.addCommonCurrentHeadFile();
            this.vs.add(Logic.getFileNumber(address)).lf();
            return true;
        }
    }

    @FunctionalInterface
    public static interface EntryIterator {
        public boolean accept(long var1, long var3);
    }

    public static final class Logic {
        static final byte LENGTH_ENTRY_LENGTH = (byte)XMemory.byteSize_byte();
        static final byte LENGTH_ENTRY_TYPE = (byte)XMemory.byteSize_byte();
        static final byte LENGTH_ENTRY_TIMESTAMP = (byte)XMemory.byteSize_long();
        static final byte LENGTH_FILE_LENGTH = (byte)XMemory.byteSize_long();
        static final byte LENGTH_FILE_NUMBER = (byte)XMemory.byteSize_long();
        static final byte TYPE_FILE_CREATION = 0;
        static final byte TYPE_STORE = 1;
        static final byte TYPE_TRANSFER = 2;
        static final byte TYPE_FILE_TRUNCATION = 3;
        static final byte TYPE_FILE_DELETION = 4;
        static final byte OFFSET_COMMON_LENGTH = 0;
        static final byte OFFSET_COMMON_TYPE = (byte)(0 + LENGTH_ENTRY_LENGTH);
        static final byte OFFSET_COMMON_TIMESTAMP = (byte)(OFFSET_COMMON_TYPE + LENGTH_ENTRY_TYPE);
        static final byte OFFSET_COMMON_FILE_LENGTH = (byte)(OFFSET_COMMON_TIMESTAMP + LENGTH_FILE_LENGTH);
        static final byte LENGTH_COMMON;
        static final byte OFFSET_COMMON_FILE_NUMBER;
        static final byte LENGTH_COMMON_NUMBERED;
        static final byte OFFSET_COMMON_SPECIAL_OFFSET;
        static final byte LENGTH_COMMON_MAXIMUM;
        static final byte LENGTH_FILE_CREATION;
        static final byte LENGTH_STORE;
        static final byte LENGTH_TRANSFER;
        static final byte LENGTH_FILE_TRUNCATION;
        static final byte LENGTH_FILE_DELETION;

        public static byte entryLengthFileCreation() {
            return LENGTH_FILE_CREATION;
        }

        public static byte entryLengthStore() {
            return LENGTH_STORE;
        }

        public static byte entryLengthTransfer() {
            return LENGTH_TRANSFER;
        }

        public static byte entryLengthFileTruncation() {
            return LENGTH_FILE_TRUNCATION;
        }

        public static byte entryLengthFileDeletion() {
            return LENGTH_FILE_DELETION;
        }

        public static void initializeEntry(long address, byte length, byte type) {
            XMemory.set_byte((long)(address + 0L), (byte)length);
            XMemory.set_byte((long)(address + (long)OFFSET_COMMON_TYPE), (byte)type);
        }

        public static void initializeEntryFileCreation(long address) {
            Logic.initializeEntry(address, Logic.entryLengthFileCreation(), (byte)0);
        }

        public static void initializeEntryStore(long address) {
            Logic.initializeEntry(address, Logic.entryLengthStore(), (byte)1);
        }

        public static void initializeEntryTransfer(long address) {
            Logic.initializeEntry(address, Logic.entryLengthTransfer(), (byte)2);
        }

        public static void initializeEntryFileDeletion(long address) {
            Logic.initializeEntry(address, Logic.entryLengthFileDeletion(), (byte)4);
        }

        public static void initializeEntryFileTruncation(long address) {
            Logic.initializeEntry(address, Logic.entryLengthFileTruncation(), (byte)3);
        }

        public static void setEntryCommon(long address, long fileLength, long timestamp) {
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_FILE_LENGTH), (long)fileLength);
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_TIMESTAMP), (long)timestamp);
        }

        public static void setEntryFileCreation(long address, long fileLength, long timestamp, long fileNumber) {
            Logic.setEntryCommon(address, fileLength, timestamp);
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_FILE_NUMBER), (long)fileNumber);
        }

        public static byte getEntryLength(long address) {
            return XMemory.get_byte((long)(address + 0L));
        }

        public static final StorageTransactionsEntryType mapEntryType(byte entryTypeKey) {
            switch (entryTypeKey) {
                case 0: {
                    return StorageTransactionsEntryType.FILE_CREATION;
                }
                case 1: {
                    return StorageTransactionsEntryType.DATA_STORE;
                }
                case 2: {
                    return StorageTransactionsEntryType.DATA_TRANSFER;
                }
                case 3: {
                    return StorageTransactionsEntryType.FILE_TRUNCATION;
                }
                case 4: {
                    return StorageTransactionsEntryType.FILE_DELETION;
                }
            }
            throw new StorageException("Unknown transactions entry type: " + entryTypeKey);
        }

        public static byte getEntryType(long address) {
            return XMemory.get_byte((long)(address + (long)OFFSET_COMMON_TYPE));
        }

        public static StorageTransactionsEntryType resolveEntryType(long address) {
            return Logic.mapEntryType(Logic.getEntryType(address));
        }

        public static long getEntryTimestamp(long address) {
            return XMemory.get_long((long)(address + (long)OFFSET_COMMON_TIMESTAMP));
        }

        public static long getFileLength(long address) {
            return XMemory.get_long((long)(address + (long)OFFSET_COMMON_FILE_LENGTH));
        }

        public static long getFileNumber(long address) {
            return XMemory.get_long((long)(address + (long)OFFSET_COMMON_FILE_NUMBER));
        }

        public static long getSpecialOffset(long address) {
            return XMemory.get_long((long)(address + (long)OFFSET_COMMON_SPECIAL_OFFSET));
        }

        public static void setEntryStore(long address, long fileLength, long timestamp) {
            Logic.setEntryCommon(address, fileLength, timestamp);
        }

        public static void setEntryTransfer(long address, long fileLength, long timestamp, long sourcefileNumber, long sourcefileOffset) {
            Logic.setEntryCommon(address, fileLength, timestamp);
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_FILE_NUMBER), (long)sourcefileNumber);
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_SPECIAL_OFFSET), (long)sourcefileOffset);
        }

        public static void setEntryFileDeletion(long address, long fileLength, long timestamp, long fileNumber) {
            Logic.setEntryCommon(address, fileLength, timestamp);
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_FILE_NUMBER), (long)fileNumber);
        }

        public static void setEntryFileTruncation(long address, long fileLength, long timestamp, long fileNumber, long oldLength) {
            Logic.setEntryCommon(address, fileLength, timestamp);
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_FILE_NUMBER), (long)fileNumber);
            XMemory.set_long((long)(address + (long)OFFSET_COMMON_SPECIAL_OFFSET), (long)oldLength);
        }

        public static <P extends EntryIterator> P processInputFile(AReadableFile file, P entryProcessor) {
            return Logic.processInputFile(file, 0L, file.size(), entryProcessor);
        }

        public static <P extends EntryIterator> P processInputFile(AReadableFile file, long startPosition, long length, P entryProcessor) {
            long actualFileLength = file.size();
            long boundPosition = startPosition + length;
            long currentFilePosition = startPosition;
            if (currentFilePosition < 0L || currentFilePosition > actualFileLength) {
                throw new IndexBoundsException(actualFileLength, currentFilePosition);
            }
            if (boundPosition < 0L || boundPosition > actualFileLength) {
                throw new IndexBoundsException(actualFileLength, boundPosition);
            }
            ByteBuffer buffer = XMemory.allocateDirectNativeDefault();
            long address = XMemory.getDirectByteBufferAddress((ByteBuffer)buffer);
            while (currentFilePosition < boundPosition) {
                buffer.clear();
                if (currentFilePosition + (long)buffer.limit() >= boundPosition) {
                    buffer.limit((int)(boundPosition - currentFilePosition));
                }
                file.readBytes(buffer, currentFilePosition);
                long progress = Logic.processBufferedEntities(address, buffer.limit(), entryProcessor);
                currentFilePosition += progress;
            }
            return entryProcessor;
        }

        private static long processBufferedEntities(long startAddress, long bufferDataLength, EntryIterator entityProcessor) {
            long bufferBound = startAddress + bufferDataLength;
            long entityStartBound = bufferBound - (long)LENGTH_ENTRY_LENGTH;
            long address = startAddress;
            byte entryLength = 0;
            do {
                if ((entryLength = Logic.getEntryLength(address)) == 0) {
                    throw new StorageException("Zero length transactions entry.");
                }
                if (entityProcessor.accept(address, bufferBound - address)) continue;
                return address - startAddress;
            } while ((address += (long)Math.abs(entryLength)) <= entityStartBound);
            return address - startAddress;
        }

        public static VarString parseFile(AFile file) {
            return Logic.parseFile(file, VarString.New());
        }

        public static VarString parseFile(AFile file, VarString vs) {
            IOException suppressed = null;
            AReadableFile rFile = file.useReading();
            try {
                if (!rFile.exists()) {
                    VarString varString = vs;
                    return varString;
                }
                VarString varString = Logic.parseFile(rFile, vs);
                return varString;
            }
            catch (IOException e) {
                suppressed = e;
                throw new StorageExceptionIoReading(e);
            }
            finally {
                AFS.close((AReadableFile)rFile, (Throwable)suppressed);
            }
        }

        public static VarString parseFile(AReadableFile file, VarString vs) throws IOException {
            Logic.processInputFile(file, new EntryAssembler(vs));
            return vs;
        }

        private Logic() {
            throw new UnsupportedOperationException();
        }

        static {
            OFFSET_COMMON_FILE_NUMBER = LENGTH_COMMON = (byte)(OFFSET_COMMON_FILE_LENGTH + LENGTH_FILE_LENGTH);
            OFFSET_COMMON_SPECIAL_OFFSET = LENGTH_COMMON_NUMBERED = (byte)(OFFSET_COMMON_FILE_NUMBER + LENGTH_FILE_NUMBER);
            LENGTH_COMMON_MAXIMUM = (byte)(OFFSET_COMMON_SPECIAL_OFFSET + LENGTH_FILE_LENGTH);
            LENGTH_FILE_CREATION = LENGTH_COMMON_NUMBERED;
            LENGTH_STORE = LENGTH_COMMON;
            LENGTH_TRANSFER = LENGTH_COMMON_MAXIMUM;
            LENGTH_FILE_TRUNCATION = LENGTH_COMMON_MAXIMUM;
            LENGTH_FILE_DELETION = LENGTH_COMMON_NUMBERED;
        }
    }
}

