/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.lang.ref.WeakReference;
import one.microstream.chars.XChars;
import one.microstream.persistence.types.Persister;
import one.microstream.persistence.types.Storer;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.exceptions.StorageExceptionInitialization;
import one.microstream.storage.exceptions.StorageExceptionNotActive;
import one.microstream.storage.types.DatabasePart;
import one.microstream.storage.types.StorageManager;

public interface Database
extends DatabasePart,
Persister {
    default public String toIdentifyingString() {
        return XChars.systemString((Object)this) + " \"" + this.databaseName() + "\"";
    }

    public StorageManager storage();

    public StorageManager setStorage(StorageManager var1);

    default public boolean hasStorage() {
        return this.storage() != null;
    }

    public Database guaranteeNoActiveStorage();

    public StorageManager guaranteeActiveStorage();

    public static Database New(String databaseName) {
        return new Default(databaseName, new WeakReference<Object>(null));
    }

    public static final class Default
    implements Database {
        private final String name;
        private WeakReference<StorageManager> storageReference;

        Default(String identifier, WeakReference<StorageManager> storageReference) {
            this.name = identifier;
            this.storageReference = storageReference;
        }

        @Override
        public final String databaseName() {
            return this.name;
        }

        @Override
        public final synchronized StorageManager storage() {
            return (StorageManager)this.storageReference.get();
        }

        @Override
        public final synchronized Database guaranteeNoActiveStorage() {
            StorageManager existingStorage = this.storage();
            if (existingStorage != null && existingStorage.isRunning()) {
                throw new StorageExceptionInitialization("Active storage for " + this.toIdentifyingString() + " already exists.");
            }
            return this;
        }

        @Override
        public final synchronized StorageManager guaranteeActiveStorage() {
            StorageManager existingStorage = this.storage();
            if (existingStorage == null) {
                throw new StorageExceptionInitialization("No storage for " + this.toIdentifyingString() + " exists.");
            }
            if (!existingStorage.isRunning()) {
                throw new StorageExceptionNotActive("Storage for " + this.toIdentifyingString() + " is not active.");
            }
            return existingStorage;
        }

        @Override
        public final synchronized StorageManager setStorage(StorageManager storage) {
            this.guaranteeNoActiveStorage();
            Database associatedDatabase = storage.database();
            if (associatedDatabase != this) {
                throw new StorageExceptionConsistency("Inconsistent database association: the passed " + StorageManager.class.getSimpleName() + " belongs to " + associatedDatabase.toIdentifyingString() + ", which is incompatible to this: " + this.toIdentifyingString() + ".");
            }
            this.storageReference = new WeakReference<StorageManager>(storage);
            return storage;
        }

        public final Object getObject(long objectId) {
            StorageManager storage = this.guaranteeActiveStorage();
            return storage.getObject(objectId);
        }

        public final long store(Object instance) {
            StorageManager storage = this.guaranteeActiveStorage();
            return storage.store(instance);
        }

        public final long[] storeAll(Object ... instances) {
            StorageManager storage = this.guaranteeActiveStorage();
            return storage.storeAll(instances);
        }

        public final void storeAll(Iterable<?> instances) {
            StorageManager storage = this.guaranteeActiveStorage();
            storage.storeAll(instances);
        }

        public final Storer createLazyStorer() {
            StorageManager storage = this.guaranteeActiveStorage();
            return storage.createLazyStorer();
        }

        public final Storer createStorer() {
            StorageManager storage = this.guaranteeActiveStorage();
            return storage.createStorer();
        }

        public final Storer createEagerStorer() {
            StorageManager storage = this.guaranteeActiveStorage();
            return storage.createEagerStorer();
        }
    }
}

