/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AWritableFile;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingTable;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryExporter;
import one.microstream.persistence.types.PersistenceTypeDictionaryStorer;
import one.microstream.storage.exceptions.StorageExceptionBackup;
import one.microstream.storage.exceptions.StorageExceptionBackupCopying;
import one.microstream.storage.exceptions.StorageExceptionBackupEmptyStorageBackupAhead;
import one.microstream.storage.exceptions.StorageExceptionBackupEmptyStorageForNonEmptyBackup;
import one.microstream.storage.exceptions.StorageExceptionBackupInconsistentFileLength;
import one.microstream.storage.types.DisruptionCollectorExecuting;
import one.microstream.storage.types.StorageActivePart;
import one.microstream.storage.types.StorageBackupChannelFile;
import one.microstream.storage.types.StorageBackupDataFile;
import one.microstream.storage.types.StorageBackupFile;
import one.microstream.storage.types.StorageBackupFileProvider;
import one.microstream.storage.types.StorageBackupInventory;
import one.microstream.storage.types.StorageBackupItemQueue;
import one.microstream.storage.types.StorageBackupSetup;
import one.microstream.storage.types.StorageBackupTransactionsFile;
import one.microstream.storage.types.StorageChannelFile;
import one.microstream.storage.types.StorageDataFile;
import one.microstream.storage.types.StorageDataFileValidator;
import one.microstream.storage.types.StorageDataInventoryFile;
import one.microstream.storage.types.StorageFile;
import one.microstream.storage.types.StorageFileWriter;
import one.microstream.storage.types.StorageHashChannelPart;
import one.microstream.storage.types.StorageInventory;
import one.microstream.storage.types.StorageLiveChannelFile;
import one.microstream.storage.types.StorageLiveTransactionsFile;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageTransactionsAnalysis;
import one.microstream.storage.types.StorageTransactionsFile;
import one.microstream.storage.types.StorageTypeDictionary;
import one.microstream.storage.types.StorageWriteController;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface StorageBackupHandler
extends Runnable,
StorageActivePart {
    public StorageBackupSetup setup();

    public void initialize(int var1);

    public void synchronize(StorageInventory var1);

    public void copyFilePart(StorageLiveChannelFile<?> var1, long var2, long var4);

    public void truncateFile(StorageLiveChannelFile<?> var1, long var2);

    public void deleteFile(StorageLiveChannelFile<?> var1);

    public StorageBackupHandler start();

    default public StorageBackupHandler stop() {
        this.setRunning(false);
        return this;
    }

    public boolean isRunning();

    @Override
    public boolean isActive();

    public StorageBackupHandler setRunning(boolean var1);

    public static StorageBackupHandler New(StorageBackupSetup backupSetup, int channelCount, StorageBackupItemQueue itemQueue, StorageOperationController operationController, StorageWriteController writeController, StorageDataFileValidator.Creator validatorCreator, StorageTypeDictionary typeDictionary) {
        StorageBackupFileProvider backupFileProvider = backupSetup.backupFileProvider();
        Default.ChannelInventory[] cis = (Default.ChannelInventory[])X.Array(Default.ChannelInventory.class, (int)channelCount, i -> new Default.ChannelInventory(i, backupFileProvider));
        return new Default(cis, (StorageBackupSetup)X.notNull((Object)backupSetup), (StorageBackupItemQueue)X.notNull((Object)itemQueue), (StorageOperationController)X.notNull((Object)operationController), (StorageWriteController)X.notNull((Object)writeController), (StorageDataFileValidator.Creator)X.notNull((Object)validatorCreator), (StorageTypeDictionary)X.notNull((Object)typeDictionary));
    }

    public static final class Default
    implements StorageBackupHandler,
    StorageBackupInventory,
    PersistenceTypeDictionaryStorer {
        private static final Logger logger = Logging.getLogger(Default.class);
        private final StorageBackupSetup backupSetup;
        private final ChannelInventory[] channelInventories;
        private final StorageBackupItemQueue itemQueue;
        private final StorageOperationController operationController;
        private final StorageWriteController writeController;
        private final StorageDataFileValidator.Creator validatorCreator;
        private final StorageTypeDictionary typeDictionary;
        private final PersistenceTypeDictionaryExporter typeDictionaryExporter;
        private boolean running;
        private boolean active;
        private boolean shutdown;

        Default(ChannelInventory[] channelInventories, StorageBackupSetup backupSetup, StorageBackupItemQueue itemQueue, StorageOperationController operationController, StorageWriteController writeController, StorageDataFileValidator.Creator validatorCreator, StorageTypeDictionary typeDictionary) {
            this.channelInventories = channelInventories;
            this.backupSetup = backupSetup;
            this.itemQueue = itemQueue;
            this.operationController = operationController;
            this.writeController = writeController;
            this.validatorCreator = validatorCreator;
            this.typeDictionary = typeDictionary;
            this.typeDictionaryExporter = PersistenceTypeDictionaryExporter.New((PersistenceTypeDictionaryStorer)this);
        }

        @Override
        public final StorageBackupSetup setup() {
            return this.backupSetup;
        }

        @Override
        public final synchronized boolean isRunning() {
            return this.running && (!this.shutdown || !this.itemQueue.isEmpty());
        }

        @Override
        public final synchronized boolean isActive() {
            return this.active;
        }

        @Override
        public final StorageBackupHandler start() {
            this.ensureTypeDictionaryBackup();
            this.setRunning(true);
            return this;
        }

        @Override
        public synchronized StorageBackupHandler stop() {
            this.shutdown = true;
            return this;
        }

        @Override
        public final synchronized StorageBackupHandler setRunning(boolean running) {
            this.running = running;
            return this;
        }

        @Override
        public StorageBackupDataFile ensureDataFile(StorageDataFile file) {
            return this.channelInventories[file.channelIndex()].ensureBackupFile(file);
        }

        @Override
        public StorageBackupTransactionsFile ensureTransactionsFile(StorageTransactionsFile file) {
            return this.channelInventories[file.channelIndex()].ensureTransactionsFile();
        }

        @Override
        public void initialize(int channelIndex) {
            logger.debug("Initializing backup for channel #{}", (Object)channelIndex);
            try {
                this.tryInitialize(channelIndex);
            }
            catch (RuntimeException e) {
                this.operationController.registerDisruption(e);
                throw e;
            }
        }

        @Override
        public void synchronize(StorageInventory storageInventory) {
            logger.debug("Synchronizing backup with storage");
            try {
                this.trySynchronize(storageInventory);
                logger.debug("Backup synchronized successfully");
            }
            catch (RuntimeException e) {
                this.operationController.registerDisruption(e);
                throw e;
            }
        }

        public void storeTypeDictionary(String typeDictionaryString) {
            this.setup().backupFileProvider().provideTypeDictionaryIoHandler().storeTypeDictionary(typeDictionaryString);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            logger.info("Starting backup handler");
            try {
                this.active = true;
                while (this.isRunning() && this.operationController.checkProcessingEnabled()) {
                    try {
                        this.itemQueue.processNextItem(this, 10000L);
                    }
                    catch (InterruptedException e) {
                        this.stop();
                    }
                    catch (RuntimeException e) {
                        this.operationController.registerDisruption(e);
                        throw e;
                        return;
                    }
                }
            }
            finally {
                this.closeAllDataFiles();
                this.active = false;
                logger.info("Backup handler stopped");
            }
        }

        private void ensureTypeDictionaryBackup() {
            if (!this.setup().backupFileProvider().provideTypeDictionaryFile().exists()) {
                logger.debug("Creating new type dictionary backup");
                this.typeDictionaryExporter.exportTypeDictionary((PersistenceTypeDictionary)this.typeDictionary);
            } else {
                logger.debug("Existing type dictionary backup found");
            }
        }

        private void tryInitialize(int channelIndex) {
            ChannelInventory backupInventory = this.channelInventories[channelIndex];
            backupInventory.ensureRegisteredFiles();
        }

        private void trySynchronize(StorageInventory storageInventory) {
            ChannelInventory backupInventory = this.channelInventories[storageInventory.channelIndex()];
            if (backupInventory.dataFiles.isEmpty()) {
                this.fillEmptyBackup(storageInventory, backupInventory);
            } else {
                this.updateExistingBackup(storageInventory, backupInventory);
            }
        }

        final void fillEmptyBackup(StorageInventory storageInventory, ChannelInventory backupInventory) {
            for (StorageDataInventoryFile storageFile : storageInventory.dataFiles().values()) {
                StorageBackupDataFile backupTargetFile = storageFile.ensureBackupFile(this);
                this.copyFile(storageFile, backupTargetFile);
            }
            StorageLiveTransactionsFile transactionFile = storageInventory.transactionsFileAnalysis().transactionsFile();
            StorageBackupTransactionsFile backupTransactionFile = transactionFile.ensureBackupFile(this);
            this.copyFile(transactionFile, backupTransactionFile);
        }

        private void validateStorageInventoryForExistingBackup(StorageInventory storageInventory, ChannelInventory backupInventory) {
            if (!storageInventory.dataFiles().isEmpty()) {
                return;
            }
            throw new StorageExceptionBackupEmptyStorageForNonEmptyBackup((long)backupInventory.channelIndex(), (XGettingTable<Long, StorageBackupDataFile>)backupInventory.dataFiles());
        }

        private void validateBackupFileProgress(StorageInventory storageInventory, ChannelInventory backupInventory) {
            long lastStorageFileNumber = (Long)storageInventory.dataFiles().keys().last();
            long lastBackupFileNumber = (Long)backupInventory.dataFiles().keys().last();
            if (lastBackupFileNumber <= lastStorageFileNumber) {
                return;
            }
            throw new StorageExceptionBackupEmptyStorageBackupAhead(storageInventory, (XGettingTable<Long, StorageBackupDataFile>)backupInventory.dataFiles());
        }

        final void updateExistingBackup(StorageInventory storageInventory, ChannelInventory backupInventory) {
            this.validateStorageInventoryForExistingBackup(storageInventory, backupInventory);
            this.validateBackupFileProgress(storageInventory, backupInventory);
            long lastBackupFileNumber = (Long)backupInventory.dataFiles().keys().last();
            for (StorageDataInventoryFile dataFile : storageInventory.dataFiles().values()) {
                long backupTargetFileLength;
                StorageBackupDataFile backupTargetFile = dataFile.ensureBackupFile(this);
                if (!backupTargetFile.exists()) {
                    this.copyFile(dataFile, backupTargetFile);
                    continue;
                }
                long storageFileLength = dataFile.size();
                if (storageFileLength == (backupTargetFileLength = backupTargetFile.size())) continue;
                if (backupTargetFile.number() == lastBackupFileNumber) {
                    if (storageFileLength <= backupTargetFileLength) continue;
                    this.copyFilePart(dataFile, backupTargetFileLength, storageFileLength - backupTargetFileLength, backupTargetFile);
                    continue;
                }
                if (backupTargetFile.number() > lastBackupFileNumber && backupTargetFileLength == 0L) {
                    this.copyFilePart(dataFile, backupTargetFileLength, storageFileLength - backupTargetFileLength, backupTargetFile);
                    continue;
                }
                throw new StorageExceptionBackupInconsistentFileLength(storageInventory, (XGettingTable<Long, StorageBackupDataFile>)backupInventory.dataFiles(), dataFile, storageFileLength, backupTargetFile, backupTargetFileLength);
            }
            this.synchronizeTransactionFile(storageInventory, backupInventory);
        }

        private void deleteBackupTransactionFile(ChannelInventory backupInventory) {
            StorageBackupTransactionsFile backupTransactionFile = backupInventory.transactionFile;
            if (backupTransactionFile == null || !backupTransactionFile.exists()) {
                return;
            }
            AFile deletionTargetFile = this.backupSetup.backupFileProvider().provideDeletionTargetFile(backupTransactionFile);
            if (deletionTargetFile == null) {
                backupTransactionFile.delete();
            } else {
                AFS.executeWriting((AFile)deletionTargetFile, wf -> backupTransactionFile.moveTo((AWritableFile)wf));
            }
            backupInventory.transactionFile = null;
        }

        private void synchronizeTransactionFile(StorageInventory storageInventory, ChannelInventory backupInventory) {
            StorageTransactionsAnalysis tfa = storageInventory.transactionsFileAnalysis();
            if (tfa == null) {
                this.deleteBackupTransactionFile(backupInventory);
                return;
            }
            StorageLiveTransactionsFile liveTransactionsFile = tfa.transactionsFile();
            StorageBackupTransactionsFile backupTransactionFile = liveTransactionsFile.ensureBackupFile(this);
            if (!backupTransactionFile.exists()) {
                this.copyFile(liveTransactionsFile, backupTransactionFile);
                return;
            }
            long storageFileLength = liveTransactionsFile.size();
            long backupTargetFileLength = backupTransactionFile.size();
            if (backupTargetFileLength != storageFileLength) {
                this.deleteBackupTransactionFile(backupInventory);
                StorageBackupTransactionsFile backupTransactionFileNew = liveTransactionsFile.ensureBackupFile(this);
                this.copyFile(liveTransactionsFile, backupTransactionFileNew);
            }
        }

        private void copyFile(StorageFile storageFile, StorageBackupFile backupTargetFile) {
            storageFile.copyTo(backupTargetFile);
        }

        private void copyFilePart(StorageChannelFile sourceFile, long sourcePosition, long length, StorageBackupFile backupTargetFile) {
            try {
                long oldBackupFileLength = backupTargetFile.size();
                try {
                    sourceFile.copyTo(backupTargetFile, sourcePosition, length);
                    if (backupTargetFile instanceof StorageBackupDataFile) {
                        this.validatorCreator.createDataFileValidator().validateFile((StorageBackupDataFile)backupTargetFile, oldBackupFileLength, length);
                    }
                }
                catch (Exception e) {
                    throw new StorageExceptionBackupCopying(sourceFile, sourcePosition, length, backupTargetFile, e);
                }
                finally {
                    backupTargetFile.close();
                }
            }
            catch (Exception e) {
                throw new StorageExceptionBackupCopying(sourceFile, sourcePosition, length, backupTargetFile, e);
            }
        }

        @Override
        public void copyFilePart(StorageLiveChannelFile<?> sourceFile, long sourcePosition, long copyLength) {
            StorageBackupChannelFile backupTargetFile = sourceFile.ensureBackupFile(this);
            logger.debug("Copying backup file part from {}, length {}: {}", new Object[]{sourcePosition, copyLength, backupTargetFile.file().toPathString()});
            this.copyFilePart(sourceFile, sourcePosition, copyLength, backupTargetFile);
        }

        @Override
        public void truncateFile(StorageLiveChannelFile<?> file, long newLength) {
            StorageBackupChannelFile backupTargetFile = file.ensureBackupFile(this);
            logger.debug("Truncating backup file to {} bytes: {}", (Object)newLength, (Object)backupTargetFile.file().toPathString());
            StorageFileWriter.truncateFile(backupTargetFile, newLength, this.backupSetup.backupFileProvider());
        }

        @Override
        public void deleteFile(StorageLiveChannelFile<?> file) {
            if (!this.writeController.isFileDeletionEnabled()) {
                return;
            }
            StorageBackupChannelFile backupTargetFile = file.ensureBackupFile(this);
            logger.debug("Deleting backup file: {}", (Object)backupTargetFile.file().toPathString());
            StorageFileWriter.deleteFile(backupTargetFile, this.writeController, this.backupSetup.backupFileProvider());
        }

        final void closeAllDataFiles() {
            DisruptionCollectorExecuting<StorageBackupChannelFile> closer = DisruptionCollectorExecuting.New(file -> file.close());
            for (ChannelInventory channel : this.channelInventories) {
                closer.executeOn(channel.transactionFile);
                for (StorageBackupDataFile dataFile : channel.dataFiles.values()) {
                    closer.executeOn(dataFile);
                }
            }
            if (closer.hasDisruptions()) {
                throw new StorageExceptionBackup((Throwable)closer.toMultiCauseException());
            }
        }

        static final class ChannelInventory
        implements StorageHashChannelPart {
            final int channelIndex;
            final StorageBackupFileProvider backupFileProvider;
            StorageBackupTransactionsFile transactionFile;
            EqHashTable<Long, StorageBackupDataFile> dataFiles;

            ChannelInventory(int channelIndex, StorageBackupFileProvider backupFileProvider) {
                this.channelIndex = channelIndex;
                this.backupFileProvider = backupFileProvider;
            }

            @Override
            public final int channelIndex() {
                return this.channelIndex;
            }

            public final EqHashTable<Long, StorageBackupDataFile> dataFiles() {
                return this.dataFiles;
            }

            final void ensureRegisteredFiles() {
                this.ensureDataFiles();
                this.ensureTransactionsFile();
            }

            final StorageBackupTransactionsFile ensureTransactionsFile() {
                if (this.transactionFile == null) {
                    StorageBackupTransactionsFile transactionsfile = this.backupFileProvider.provideBackupTransactionsFile(this.channelIndex());
                    transactionsfile.file().ensureExists();
                    this.transactionFile = transactionsfile;
                }
                return this.transactionFile;
            }

            final StorageBackupDataFile ensureBackupFile(StorageDataFile sourceFile) {
                StorageBackupDataFile backupFile = (StorageBackupDataFile)this.dataFiles.get((Object)sourceFile.number());
                if (backupFile == null) {
                    backupFile = this.backupFileProvider.provideBackupDataFile(sourceFile);
                    backupFile.file().ensureExists();
                    this.registerBackupFile(backupFile);
                }
                return backupFile;
            }

            private StorageBackupDataFile registerBackupFile(StorageBackupDataFile backupFile) {
                this.dataFiles.add((Object)backupFile.number(), (Object)backupFile);
                return backupFile;
            }

            final void ensureDataFiles() {
                if (this.dataFiles != null) {
                    return;
                }
                BulkList collectedFiles = this.backupFileProvider.collectDataFiles(StorageBackupDataFile::New, BulkList.New(), this.channelIndex()).sort(StorageDataFile::orderByNumber);
                this.dataFiles = EqHashTable.New();
                collectedFiles.iterate(this::registerBackupFile);
            }
        }
    }
}

