/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.afs.types.AFile;
import one.microstream.storage.types.StorageChannelFile;
import one.microstream.storage.types.StorageChannelImportBatch;
import one.microstream.storage.types.StorageFile;
import one.microstream.storage.types.StorageImportSource;

public interface StorageImportSourceFile
extends StorageImportSource {

    public static class Default
    extends StorageImportSource.Abstract
    implements StorageImportSourceFile {
        private final ImportSourceFile sourceFile;

        Default(int channelIndex, AFile file, StorageChannelImportBatch.Default headBatch) {
            super(headBatch);
            this.sourceFile = new ImportSourceFile(file, channelIndex);
        }

        @Override
        public long copyTo(StorageFile target, long sourcePosition, long length) {
            return this.sourceFile.copyTo(target, sourcePosition, length);
        }

        @Override
        public boolean close() {
            return this.sourceFile.close();
        }

        public String toString() {
            return Integer.toString(this.sourceFile.channelIndex()) + " " + (String)(this.sourceFile.file() == null ? "<Dummy>" : this.sourceFile.file().toPathString() + " " + this.headBatch);
        }

        static class ImportSourceFile
        extends StorageChannelFile.Abstract {
            ImportSourceFile(AFile file, int channelIndex) {
                super(file, channelIndex);
            }
        }
    }
}

