/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Consumer;
import one.microstream.afs.types.AFile;
import one.microstream.collections.XArrays;
import one.microstream.storage.types.StorageBackupableFile;
import one.microstream.storage.types.StorageClosableFile;
import one.microstream.storage.types.StorageFile;
import one.microstream.storage.types.StorageFileUser;

public interface StorageLiveFile<S extends StorageLiveFile<S>>
extends StorageClosableFile,
StorageBackupableFile {
    public boolean hasUsers();

    public boolean executeIfUnsued(Consumer<? super S> var1);

    public boolean registerUsage(StorageFileUser var1);

    public boolean clearUsages(StorageFileUser var1);

    public boolean unregisterUsage(StorageFileUser var1);

    public boolean unregisterUsageClosing(StorageFileUser var1, Consumer<? super S> var2);

    public static abstract class Abstract<S extends StorageLiveFile<S>>
    extends StorageFile.Abstract
    implements StorageLiveFile<S> {
        private Usage[] usages = null;
        private int usagesSize = 0;

        protected Abstract(AFile file) {
            super(file);
        }

        protected S $() {
            return (S)this;
        }

        @Override
        public final synchronized boolean hasUsers() {
            return this.usagesSize != 0;
        }

        @Override
        public final synchronized boolean executeIfUnsued(Consumer<? super S> action) {
            if (this.hasUsers()) {
                return false;
            }
            action.accept(this.$());
            return true;
        }

        @Override
        public final synchronized boolean registerUsage(StorageFileUser fileUser) {
            return this.ensureEntry(fileUser).increment();
        }

        private Usage ensureEntry(StorageFileUser fileUser) {
            for (int i = 0; i < this.usagesSize; ++i) {
                if (this.usages[i].user != fileUser) continue;
                return this.usages[i];
            }
            if (this.usages == null) {
                this.usages = new Usage[1];
            } else if (this.usagesSize >= this.usages.length) {
                this.usages = (Usage[])XArrays.enlarge((Object[])this.usages, (int)(this.usages.length * 2));
            }
            Usage usage = new Usage(fileUser);
            this.usages[this.usagesSize++] = usage;
            return usage;
        }

        private void checkForUsagesArrayClearing() {
            if (this.usagesSize == 0) {
                this.usages = null;
            }
        }

        @Override
        public final synchronized boolean clearUsages(StorageFileUser fileUser) {
            for (int i = 0; i < this.usagesSize; ++i) {
                if (this.usages[i].user != fileUser) continue;
                XArrays.removeFromIndex((Object[])this.usages, (int)this.usagesSize--, (int)i);
                this.checkForUsagesArrayClearing();
                return true;
            }
            return false;
        }

        @Override
        public final synchronized boolean unregisterUsage(StorageFileUser fileUser) {
            for (int i = 0; i < this.usagesSize; ++i) {
                if (this.usages[i].user != fileUser) continue;
                if (this.usages[i].decrement()) {
                    XArrays.removeFromIndex((Object[])this.usages, (int)this.usagesSize--, (int)i);
                    this.checkForUsagesArrayClearing();
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean unregisterUsageClosing(StorageFileUser fileUser, Consumer<? super S> closingAction) {
            if (this.unregisterUsage(fileUser) && !this.hasUsers()) {
                if (closingAction != null) {
                    closingAction.accept(this.$());
                }
                this.close();
                return true;
            }
            return false;
        }

        static final class Usage {
            StorageFileUser user;
            int count;

            Usage(StorageFileUser user) {
                this.user = user;
            }

            final boolean increment() {
                return ++this.count == 1;
            }

            final boolean decrement() {
                return --this.count == 0;
            }
        }
    }
}

