/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.Date;
import one.microstream.collections.XUtilsCollection;
import one.microstream.collections.types.XGettingTable;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelSynchronizingTask;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRawFileStatistics;
import one.microstream.storage.types.StorageRequestTask;
import one.microstream.time.XTime;

public interface StorageRequestTaskCreateStatistics
extends StorageRequestTask {
    public StorageRawFileStatistics result();

    public static final class Default
    extends StorageChannelSynchronizingTask.AbstractCompletingTask<StorageRawFileStatistics.ChannelStatistics>
    implements StorageRequestTaskCreateStatistics {
        private final Date creationTime;
        private final StorageRawFileStatistics.ChannelStatistics[] channelResults;
        private StorageRawFileStatistics result;

        Default(long timestamp, int channelCount, StorageOperationController controller) {
            super(timestamp, channelCount, controller);
            this.channelResults = new StorageRawFileStatistics.ChannelStatistics[channelCount];
            this.creationTime = XTime.now();
        }

        @Override
        protected final StorageRawFileStatistics.ChannelStatistics internalProcessBy(StorageChannel channel) {
            return channel.createRawFileStatistics();
        }

        @Override
        protected synchronized void succeed(StorageChannel channel, StorageRawFileStatistics.ChannelStatistics result) {
            this.channelResults[channel.channelIndex()] = result;
        }

        @Override
        public synchronized StorageRawFileStatistics result() {
            if (this.result == null) {
                this.result = this.createResult();
            }
            return this.result;
        }

        private StorageRawFileStatistics createResult() {
            long fileCount = 0L;
            long liveDataLength = 0L;
            long totalDataLength = 0L;
            for (StorageRawFileStatistics.ChannelStatistics result : this.channelResults) {
                fileCount += result.fileCount();
                liveDataLength += result.liveDataLength();
                totalDataLength += result.totalDataLength();
            }
            return StorageRawFileStatistics.New(this.creationTime, fileCount, liveDataLength, totalDataLength, (XGettingTable<Integer, ? extends StorageRawFileStatistics.ChannelStatistics>)XUtilsCollection.toTable((Object[])this.channelResults));
        }
    }
}

