/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AFile;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.storage.types.StorageChannelTaskInitialize;
import one.microstream.storage.types.StorageChannelTaskShutdown;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityTypeExportFileProvider;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestTaskCacheCheck;
import one.microstream.storage.types.StorageRequestTaskCreateStatistics;
import one.microstream.storage.types.StorageRequestTaskExportChannels;
import one.microstream.storage.types.StorageRequestTaskExportEntitiesByType;
import one.microstream.storage.types.StorageRequestTaskFileCheck;
import one.microstream.storage.types.StorageRequestTaskImportDataByteBuffers;
import one.microstream.storage.types.StorageRequestTaskImportDataFiles;
import one.microstream.storage.types.StorageRequestTaskLoadByOids;
import one.microstream.storage.types.StorageRequestTaskLoadByTids;
import one.microstream.storage.types.StorageRequestTaskLoadRoots;
import one.microstream.storage.types.StorageRequestTaskStoreEntities;
import one.microstream.storage.types.StorageTimestampProvider;

public interface StorageRequestTaskCreator {
    public StorageChannelTaskInitialize createInitializationTask(int var1, StorageOperationController var2);

    public StorageRequestTaskStoreEntities createSaveTask(Binary var1, StorageOperationController var2);

    public StorageRequestTaskLoadByOids createLoadTaskByOids(PersistenceIdSet[] var1, StorageOperationController var2);

    public StorageRequestTaskLoadRoots createRootsLoadTask(int var1, StorageOperationController var2);

    public StorageRequestTaskLoadByTids createLoadTaskByTids(PersistenceIdSet var1, int var2, StorageOperationController var3);

    default public StorageRequestTaskExportEntitiesByType createExportTypesTask(int channelCount, StorageEntityTypeExportFileProvider exportFileProvider, StorageOperationController controller) {
        return this.createExportTypesTask(channelCount, exportFileProvider, controller);
    }

    public StorageRequestTaskExportEntitiesByType createExportTypesTask(int var1, StorageEntityTypeExportFileProvider var2, Predicate<? super StorageEntityTypeHandler> var3, StorageOperationController var4);

    public StorageRequestTaskExportChannels createTaskExportChannels(int var1, StorageLiveFileProvider var2, StorageOperationController var3);

    public StorageRequestTaskCreateStatistics createCreateRawFileStatisticsTask(int var1, StorageOperationController var2);

    public StorageRequestTaskFileCheck createFullFileCheckTask(int var1, long var2, StorageOperationController var4);

    public StorageRequestTaskCacheCheck createFullCacheCheckTask(int var1, long var2, StorageEntityCacheEvaluator var4, StorageOperationController var5);

    public StorageRequestTaskImportDataFiles createImportFromFilesTask(int var1, StorageDataFileEvaluator var2, StorageObjectIdRangeEvaluator var3, XGettingEnum<AFile> var4, StorageOperationController var5);

    public StorageRequestTaskImportDataByteBuffers createImportFromByteBuffersTask(int var1, StorageDataFileEvaluator var2, StorageObjectIdRangeEvaluator var3, XGettingEnum<ByteBuffer> var4, StorageOperationController var5);

    public StorageChannelTaskShutdown createShutdownTask(int var1, StorageOperationController var2);

    public static final class Default
    implements StorageRequestTaskCreator {
        private final StorageTimestampProvider timestampProvider;

        public Default(StorageTimestampProvider timestampProvider) {
            this.timestampProvider = (StorageTimestampProvider)X.notNull((Object)timestampProvider);
        }

        @Override
        public StorageChannelTaskInitialize createInitializationTask(int channelCount, StorageOperationController operationController) {
            return new StorageChannelTaskInitialize.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageChannelTaskShutdown createShutdownTask(int channelCount, StorageOperationController operationController) {
            return new StorageChannelTaskShutdown.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskStoreEntities createSaveTask(Binary data, StorageOperationController operationController) {
            return new StorageRequestTaskStoreEntities.Default(this.timestampProvider.currentNanoTimestamp(), data, operationController);
        }

        @Override
        public StorageRequestTaskLoadByOids createLoadTaskByOids(PersistenceIdSet[] loadOids, StorageOperationController operationController) {
            return new StorageRequestTaskLoadByOids.Default(this.timestampProvider.currentNanoTimestamp(), loadOids, operationController);
        }

        @Override
        public StorageRequestTaskLoadRoots createRootsLoadTask(int channelCount, StorageOperationController operationController) {
            return new StorageRequestTaskLoadRoots.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskLoadByTids createLoadTaskByTids(PersistenceIdSet loadTids, int channelCount, StorageOperationController operationController) {
            return new StorageRequestTaskLoadByTids.Default(this.timestampProvider.currentNanoTimestamp(), loadTids, channelCount, operationController);
        }

        @Override
        public StorageRequestTaskExportEntitiesByType createExportTypesTask(int channelCount, StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType, StorageOperationController operationController) {
            return new StorageRequestTaskExportEntitiesByType.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, exportFileProvider, isExportType, operationController);
        }

        @Override
        public StorageRequestTaskExportChannels createTaskExportChannels(int channelCount, StorageLiveFileProvider fileProvider, StorageOperationController operationController) {
            return new StorageRequestTaskExportChannels.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, fileProvider, operationController);
        }

        @Override
        public StorageRequestTaskCreateStatistics createCreateRawFileStatisticsTask(int channelCount, StorageOperationController operationController) {
            return new StorageRequestTaskCreateStatistics.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskFileCheck createFullFileCheckTask(int channelCount, long nanoTimeBudget, StorageOperationController operationController) {
            return new StorageRequestTaskFileCheck.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, nanoTimeBudget, operationController);
        }

        @Override
        public StorageRequestTaskCacheCheck createFullCacheCheckTask(int channelCount, long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator, StorageOperationController operationController) {
            return new StorageRequestTaskCacheCheck.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, nanoTimeBudget, entityEvaluator, operationController);
        }

        @Override
        public StorageRequestTaskImportDataFiles createImportFromFilesTask(int channelCount, StorageDataFileEvaluator fileEvaluator, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, XGettingEnum<AFile> importFiles, StorageOperationController operationController) {
            return new StorageRequestTaskImportDataFiles.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, objectIdRangeEvaluator, importFiles, operationController);
        }

        @Override
        public StorageRequestTaskImportDataByteBuffers createImportFromByteBuffersTask(int channelCount, StorageDataFileEvaluator fileEvaluator, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, XGettingEnum<ByteBuffer> importData, StorageOperationController controller) {
            return new StorageRequestTaskImportDataByteBuffers.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, objectIdRangeEvaluator, importData, controller);
        }
    }
}

