/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.types.StorageTransactionsAnalysis;

public enum StorageTransactionsEntryType {
    FILE_CREATION("CREATION", 0, StorageTransactionsAnalysis.Logic.LENGTH_FILE_CREATION),
    DATA_STORE("STORE", 1, StorageTransactionsAnalysis.Logic.LENGTH_STORE),
    DATA_TRANSFER("TRANSFER", 2, StorageTransactionsAnalysis.Logic.LENGTH_TRANSFER),
    FILE_TRUNCATION("TRUNCATION", 3, StorageTransactionsAnalysis.Logic.LENGTH_FILE_TRUNCATION),
    FILE_DELETION("DELETION", 4, StorageTransactionsAnalysis.Logic.LENGTH_FILE_DELETION);

    private final String typeName;
    private final byte code;
    private final int length;

    private StorageTransactionsEntryType(String typeName, byte code, int length) {
        this.typeName = typeName;
        this.code = code;
        this.length = length;
    }

    public byte code() {
        return this.code;
    }

    public String typeName() {
        return this.typeName;
    }

    public int length() {
        return this.length;
    }

    public String toString() {
        return this.typeName + "(" + this.code + "," + this.length + ")";
    }

    public static StorageTransactionsEntryType fromCode(byte code) {
        switch (code) {
            case 0: {
                return FILE_CREATION;
            }
            case 1: {
                return DATA_STORE;
            }
            case 2: {
                return DATA_TRANSFER;
            }
            case 3: {
                return FILE_TRUNCATION;
            }
            case 4: {
                return FILE_DELETION;
            }
        }
        throw new StorageException("Unknown transactions entry type: " + code);
    }
}

