/*
 * Decompiled with CFR 0.152.
 */
package one.stayfocused.spring.dotenv.config;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import one.stayfocused.spring.dotenv.environment.DotenvPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class DotenvLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DotenvLogger.class);
    private final ConfigurableEnvironment environment;

    public DotenvLogger(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void logDotenvInfo() {
        boolean enabled = this.environment.getPropertySources().contains("dotenv");
        String dotenvPath = this.environment.getProperty("dotenv.path", ".env");
        String priority = this.environment.getProperty("dotenv.priority", "low");
        String failOnMissing = this.environment.getProperty("dotenv.fail-on-missing", String.valueOf(false));
        int variableCount = Optional.ofNullable(this.environment.getPropertySources().get("dotenv")).filter(DotenvPropertySource.class::isInstance).map(DotenvPropertySource.class::cast).map(PropertySource::getSource).map(Map::size).orElse(0);
        log.info("[Dotenv] Status: {}", (Object)(enabled ? "enabled" : "disabled"));
        log.info("[Dotenv] Path: {}", (Object)dotenvPath);
        log.info("[Dotenv] Fail on missing: {}", (Object)failOnMissing);
        log.info("[Dotenv] Priority: {}", (Object)priority);
        log.info("[Dotenv] Loaded variables: {} ", (Object)variableCount);
    }
}

